/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjArrayTypeNode;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.HjTypeNode_c;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class HjArrayTypeNode_c
extends HjTypeNode_c
implements HjArrayTypeNode {
    protected TypeNode base;
    protected boolean isValueType;
    protected Expr distribution;

    public HjArrayTypeNode_c(Position pos, TypeNode base) {
        this(pos, base, false);
    }

    public HjArrayTypeNode_c(Position pos, TypeNode base, boolean isValueType) {
        this(pos, base, isValueType, null);
    }

    public DepParameterExpr indexedSet() {
        return this.dep;
    }

    public HjArrayTypeNode_c(Position pos, TypeNode base, boolean isValueType, DepParameterExpr indexedSet) {
        super(pos);
        this.base = base;
        this.isValueType = isValueType;
        List args = indexedSet == null ? null : indexedSet.args();
        this.distribution = args == null || args.size() < 1 ? null : (Expr)args.get(0);
        this.dep = indexedSet;
    }

    public boolean isValueType() {
        return this.isValueType;
    }

    public TypeNode base() {
        return this.base;
    }

    public HjArrayTypeNode base(TypeNode base) {
        HjArrayTypeNode_c n = (HjArrayTypeNode_c)this.copy();
        n.base = base;
        return n;
    }

    public Expr distribution() {
        return this.distribution;
    }

    public HjArrayTypeNode reconstruct(TypeNode base, Expr indexedSet) {
        if (base != this.base || indexedSet != this.distribution) {
            HjArrayTypeNode_c n = (HjArrayTypeNode_c)this.copy();
            n.base = base;
            this.distribution = indexedSet;
            return n;
        }
        return this;
    }

    protected HjArrayTypeNode_c reconstruct(TypeNode base, DepParameterExpr indexedSet) {
        if (base != this.base || indexedSet != this.distribution) {
            HjArrayTypeNode_c n = (HjArrayTypeNode_c)this.copy();
            n.base = base;
            List args = indexedSet.args();
            this.distribution = args == null ? null : (Expr)args.get(0);
            this.dep = indexedSet;
            return n;
        }
        return this;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.dep && this.type instanceof HjParsedClassType) {
            c = ((HjContext)c).pushDepType((HjParsedClassType)this.type);
        }
        return super.enterChildScope(child, c);
    }

    public Node visitChildren(NodeVisitor v) {
        HjArrayTypeNode n = (HjArrayTypeNode)super.visitChildren(v);
        TypeNode base = (TypeNode)n.visitChild((Node)this.base, v);
        Expr indexedSet = (Expr)n.visitChild((Node)this.distribution, v);
        return n.reconstruct(base, indexedSet);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tb.typeSystem();
        return this.type((Type)ts.array(this.base.type(), this.isValueType, this.distribution));
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)ar.typeSystem();
        NodeFactory nf = ar.nodeFactory();
        Type baseType = this.base.type();
        if (!baseType.isCanonical()) {
            return this;
        }
        HjTypeNode n = ((HjTypeNode)nf.CanonicalTypeNode(this.position(), (Type)ts.array(baseType, this.isValueType, this.distribution))).dep(this.dep);
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check HjArrayType Node " + this + " should have been converted to HjCanonicalTypeNode.");
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check HjArrayType Node " + this + " should have been converted to HjCanonicalTypeNode.");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        System.out.println("HjArrayTypeNode:  base=" + this.base);
        this.print((Node)this.base, w, tr);
        w.write((this.isValueType ? " value " : "") + "[." + (this.distribution == null ? "" : this.distribution.toString()) + "]");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError(this.position(), "Cannot translate ambiguous node " + this + ".");
    }

    public String toString() {
        return this.base.toString() + (this.isValueType ? " value " : "") + "[" + (this.dep == null ? "." + (this.distribution == null ? "" : this.distribution.toString()) : this.dep.toString()) + "]";
    }
}

