/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collection;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjArrayViewConstructor;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class HjArrayViewConstructor_c
extends Expr_c
implements HjArrayViewConstructor {
    protected Expr baseArray;
    protected Expr offset;
    protected Expr region;
    private List arguments;

    public HjArrayViewConstructor_c(Position pos, List args) {
        super(pos);
        this.arguments = TypedList.copyAndCheck((List)args, Expr.class, (boolean)true);
    }

    public Node visitChildren(NodeVisitor v) {
        if (this.arguments != null) {
            List arguments = this.visitList(this.arguments, v);
            return this.reconstruct(arguments);
        }
        Expr nBaseArray = (Expr)this.visitChild((Node)this.baseArray, v);
        Expr nOffset = (Expr)this.visitChild((Node)this.offset, v);
        Expr nDistribution = (Expr)this.visitChild((Node)this.region, v);
        return this.reconstruct(nBaseArray, nOffset, nDistribution);
    }

    protected HjArrayViewConstructor reconstruct(Expr baseArray, Expr offset, Expr region) {
        if (this.baseArray != baseArray || this.offset != offset || this.region != region) {
            HjArrayViewConstructor_c n = (HjArrayViewConstructor_c)this.copy();
            n.baseArray = baseArray;
            n.offset = offset;
            n.region = region;
            return n;
        }
        return this;
    }

    protected HjArrayViewConstructor reconstruct(List arguments) {
        if (!CollectionUtil.equals((Collection)arguments, (Collection)this.arguments)) {
            HjArrayViewConstructor_c n = (HjArrayViewConstructor_c)this.copy();
            n.arguments = TypedList.copyAndCheck((List)arguments, Expr.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Expr baseArray() {
        return this.baseArray;
    }

    public Expr region() {
        return this.region;
    }

    public Expr offset() {
        return this.offset;
    }

    public HjArrayViewConstructor region(Expr region) {
        HjArrayViewConstructor_c n = (HjArrayViewConstructor_c)this.copy();
        n.region = region;
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        if (this.arguments == null) {
            assert (this.baseArray != null);
        } else {
            if (this.arguments.size() != 3) {
                throw new SemanticException("Missing parameter for arrayView, must be (Type [] base, int offset, region r)" + this.position());
            }
            this.baseArray = (Expr)this.arguments.get(0);
            this.offset = (Expr)this.arguments.get(1);
            this.region = (Expr)this.arguments.get(2);
            this.arguments = null;
        }
        if (!this.baseArray.type().isArray()) {
            throw new SemanticException("ArrayView must take a java array as a base array" + this.position());
        }
        if (!this.offset.type().isInt()) {
            throw new SemanticException("ArrayView must take an integer as offset value" + this.position());
        }
        if (!ts.isImplicitCastValid(this.region.type(), (Type)ts.region())) {
            throw new SemanticException("ArrayView must take a region as its last parameter" + this.position());
        }
        Type baseArrayType = ((ArrayType)this.baseArray.type()).base();
        HjParsedClassType p = ((HjParsedClassType)ts.array(baseArrayType, false, this.region)).makeVariant();
        HjParsedClassType t = this.transferAttributes(p, (HjParsedClassType)this.region.type());
        return this.region(this.region).type(t);
    }

    private HjParsedClassType transferAttributes(HjParsedClassType t, HjParsedClassType distType) {
        C_Var rank;
        C_Var base;
        boolean isRect;
        C_Var onePlace;
        C_Var self = distType.self();
        if (self != null) {
            t.setDistribution(self);
        }
        if ((onePlace = distType.onePlace()) != null) {
            t.setOnePlace(onePlace);
        }
        if (isRect = distType.isRect()) {
            t.setRect();
        }
        if ((base = distType.base()) != null) {
            t.setBase(base);
        }
        if ((rank = distType.rank()) != null) {
            t.setRank(rank);
        }
        if (t.hasLocalProperty() && ((HjTypeSystem)t.typeSystem()).ZERO().equals(base) && isRect && ((HjTypeSystem)t.typeSystem()).ONE().equals(rank)) {
            t.setRail();
        }
        return t;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.baseArray, (Term)this, 0);
        v.visitCFG((Term)this.offset, (Term)this, 0);
        v.visitCFG((Term)this.region, (Term)this, 0);
        return succs;
    }

    public Term firstChild() {
        if (this.region != null) {
            return this.region;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("new arrayView(" + this.baseArray + ", ");
        s.append(this.offset + ", ");
        s.append("[" + this.region + "])");
        return s.toString();
    }

    public Type baseArrayType() {
        return ((ArrayType)this.baseArray.type()).base();
    }
}

