/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.CanonicalTypeNode_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode_c;
import polyglot.ext.hj.ast.AnnotationNode;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.GenParameterExpr;
import polyglot.ext.hj.ast.HjCanonicalTypeNode;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.HjTypeNode_c;
import polyglot.ext.hj.extension.HjExt;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjCanonicalTypeNode_c
extends CanonicalTypeNode_c
implements HjCanonicalTypeNode {
    protected DepParameterExpr dep;
    protected GenParameterExpr gen;
    Type lookaheadType = null;

    public DepParameterExpr dep() {
        return this.dep;
    }

    public GenParameterExpr gen() {
        return this.gen;
    }

    public HjCanonicalTypeNode_c(Position pos, Type type) {
        this(pos, type, null, null);
    }

    public HjCanonicalTypeNode_c(Position pos, Type type, GenParameterExpr gen, DepParameterExpr dep) {
        super(pos, type);
        this.gen = gen;
        this.dep = dep;
    }

    public HjTypeNode gen(GenParameterExpr expr) {
        if (expr == this.gen) {
            return this;
        }
        HjTypeNode_c n = (HjTypeNode_c)this.copy();
        n.gen = expr;
        return n;
    }

    public HjTypeNode dep(DepParameterExpr expr) {
        if (expr == this.dep) {
            return this;
        }
        HjCanonicalTypeNode_c n = (HjCanonicalTypeNode_c)this.copy();
        n.dep = expr;
        return n;
    }

    public HjTypeNode dep(GenParameterExpr g, DepParameterExpr d) {
        if (g == this.gen && d == this.dep) {
            return this;
        }
        HjCanonicalTypeNode_c n = (HjCanonicalTypeNode_c)this.copy();
        n.gen = g;
        n.dep = d;
        return n;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.dep) {
            TypeSystem ts = c.typeSystem();
            if (this.lookaheadType instanceof HjNamedType) {
                c = ((HjContext)c).pushDepType((HjNamedType)this.lookaheadType);
            }
        }
        Context cc = super.enterChildScope(child, c);
        return cc;
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover sc) throws SemanticException {
        this.lookaheadType = ((TypeNode_c)super.disambiguate(sc)).type();
        return sc;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        this.lookaheadType = ((TypeNode_c)super.typeCheck(tc)).type();
        return tc;
    }

    public Node visitChildren(NodeVisitor v) {
        GenParameterExpr gen = (GenParameterExpr)this.visitChild((Node)this.gen, v);
        DepParameterExpr dep2 = (DepParameterExpr)this.visitChild((Node)this.dep, v);
        if (gen != this.gen || dep2 != this.dep) {
            HjTypeNode result = this.dep(gen, dep2);
            return result;
        }
        return this;
    }

    public Node disambiguateBase(AmbiguityRemover sc) throws SemanticException {
        return super.disambiguate(sc);
    }

    public Node typeCheckBase(TypeChecker sc) throws SemanticException {
        return super.typeCheck(sc);
    }

    public boolean isTypeChecked() {
        boolean result = this.type != null && this.type.typeSystem().isCanonical(this.type) && this.dep == null;
        return result;
    }

    public boolean isDisambiguated() {
        return !(!super.isDisambiguated() || this.dep != null && !this.dep.isDisambiguated() || this.gen != null && !this.gen.isDisambiguated());
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        boolean val;
        boolean bl = val = this.dep != null && !this.dep.isDisambiguated() || this.gen != null && !this.gen.isDisambiguated();
        if (val) {
            return this;
        }
        HjTypeNode result = (HjTypeNode)super.disambiguate(sc);
        return result.dep(this.gen, this.dep);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.isTypeChecked()) {
            return this;
        }
        HjTypeNode me = (HjTypeNode)this.typeCheckBase(tc);
        Node n = HjTypeNode_c.typeCheckDepClause(me, tc);
        return n;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        this.type.print(w);
        List<AnnotationNode> annotations = ((HjExt)this.ext()).annotations();
        if (annotations.size() > 0) {
            w.allowBreak(2, 2, "", 0);
            w.begin(0);
            for (AnnotationNode n : annotations) {
                this.print(n, w, pp);
                w.allowBreak(0, "");
            }
            w.end();
        }
    }

    public String toString() {
        String typeString = this.type == null ? "<unknown-type>" : ((HjType)this.type).toStringForDisplay();
        return typeString + (this.gen == null ? "" : "/*T:" + this.gen + "*/") + (this.dep == null ? "" : "/*dep" + this.dep + "*/");
    }
}

