/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjComplexConstructor;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjComplexConstructor_c
extends Expr_c
implements HjComplexConstructor {
    private Expr real;
    private Expr imag;

    public HjComplexConstructor_c(Position pos, Expr real, Expr imag) {
        super(pos);
        this.real = real;
        this.imag = imag;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.real, (Term)this, 0);
        v.visitCFG((Term)this.imag, (Term)this, 0);
        return succs;
    }

    public Term firstChild() {
        LinkedList<Expr> l = new LinkedList<Expr>();
        l.add(this.real);
        l.add(this.imag);
        return HjComplexConstructor_c.listChild(l, (Term)this);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        HjType base32 = (HjType)((HjComplexType)xts.Complex32()).base();
        HjType base64 = (HjType)((HjComplexType)xts.Complex64()).base();
        HjType xreal = (HjType)this.real.type();
        HjType ximag = (HjType)this.imag.type();
        if (xts.isImplicitCastValid(xreal, base32) && xts.isImplicitCastValid(ximag, base32)) {
            return this.type((Type)((HjTypeSystem)tc.typeSystem()).Complex32());
        }
        if (xts.isImplicitCastValid(xreal, base64) && xts.isImplicitCastValid(ximag, base64)) {
            return this.type((Type)((HjTypeSystem)tc.typeSystem()).Complex64());
        }
        throw new SemanticException("Complex may only be initialized with float or double as real and imaginary parts");
    }

    public Node visitChildren(NodeVisitor v) {
        Expr vreal = (Expr)this.visitChild((Node)this.real, v);
        Expr vimag = (Expr)this.visitChild((Node)this.imag, v);
        return this.reconstruct(vreal, vimag);
    }

    protected HjComplexConstructor_c reconstruct(Expr vreal, Expr vimag) {
        if (vreal != this.real || vimag != this.imag) {
            HjComplexConstructor_c n = (HjComplexConstructor_c)this.copy();
            n.real = vreal;
            n.imag = vimag;
            return n;
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        this.real.prettyPrint(w, tr);
        w.write(",");
        this.imag.prettyPrint(w, tr);
        w.write(")");
    }

    public Expr real() {
        return (Expr)this.real.copy();
    }

    public Expr type(Type type) {
        return super.type(type);
    }

    public Expr imag() {
        return (Expr)this.imag.copy();
    }

    public HjComplexConstructor imag(Expr imag) {
        HjComplexConstructor_c n = (HjComplexConstructor_c)this.copy();
        n.imag = imag;
        return n;
    }

    public HjComplexConstructor real(Expr real) {
        HjComplexConstructor_c n = (HjComplexConstructor_c)this.copy();
        n.real = real;
        return n;
    }
}

