/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorCall_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.hj.ast.HjNew_c;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class HjConstructorCall_c
extends ConstructorCall_c {
    public HjConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List arguments) {
        super(pos, kind, qualifier, arguments);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjConstructorCall_c n = (HjConstructorCall_c)super.typeCheck(tc);
        if (this.kind().equals((Object)ConstructorCall.SUPER)) {
            Context ctx = tc.context();
            if (!ctx.inCode() || !(ctx.currentCode() instanceof HjConstructorInstance)) {
                throw new SemanticException("A call to super must occur only in the body of a constructor.", this.position());
            }
            HjConstructorInstance ci = (HjConstructorInstance)n.constructorInstance();
            HjType type = ci.returnType();
            HjType retType = HjNew_c.instantiateType(type, this.arguments);
            Constraint c = retType.realClause();
            HjConstructorInstance thisConstructor = (HjConstructorInstance)ctx.currentCode();
            thisConstructor.setSupClause(c);
        }
        return n;
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier + "." : "") + this.kind + this.arguments;
    }
}

