/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ConstructorDecl_c;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjConstructorDecl;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class HjConstructorDecl_c
extends ConstructorDecl_c
implements HjConstructorDecl {
    protected Expr argWhereClause;
    protected TypeNode returnType;

    public HjConstructorDecl_c(Position pos, Flags flags, Id name, TypeNode returnType, List formals, List throwTypes, Block body) {
        super(pos, flags, name, formals, throwTypes, body);
        this.returnType = returnType;
    }

    public HjConstructorDecl_c(Position pos, Flags flags, Id name, TypeNode returnType, List formals, Expr argWhereClause, List throwTypes, Block body) {
        super(pos, flags, name, formals, throwTypes, body);
        this.returnType = returnType;
        this.argWhereClause = argWhereClause;
    }

    public TypeNode returnType() {
        return this.returnType;
    }

    public Expr argWhereClause() {
        return this.argWhereClause;
    }

    public HjConstructorDecl reconstruct(TypeNode returnType) {
        if (returnType != this.returnType) {
            HjConstructorDecl_c n = (HjConstructorDecl_c)this.copy();
            n.returnType = returnType;
            return n;
        }
        return this;
    }

    public Context enterChildScope(Node child, Context c) {
        assert (c.currentCode() == this.constructorInstance());
        if (!this.formals.isEmpty()) {
            c = c.pushBlock();
            for (Formal f : this.formals) {
                f.addDecls(c);
            }
        }
        HjContext cc = (HjContext)super.enterChildScope(child, c);
        if (child == this.returnType) {
            cc.setVarWhoseTypeIsBeingElaborated(null);
        }
        return cc;
    }

    public Node visitChildren(NodeVisitor v) {
        HjConstructorDecl_c result = (HjConstructorDecl_c)super.visitChildren(v);
        TypeNode returnType = (TypeNode)this.visitChild((Node)result.returnType, v);
        return result.reconstruct(returnType);
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        HjConstructorInstance nnci;
        HjType clazz;
        HjType retTypeBase;
        HjConstructorDecl nn = this;
        HjConstructorDecl_c old = nn;
        TypeChecker childtc = (TypeChecker)tc.enter(parent, (Node)nn);
        nn = (HjConstructorDecl)nn.formals(nn.visitList(nn.formals(), (NodeVisitor)childtc));
        if (tc.hasErrors()) {
            throw new SemanticException();
        }
        if (nn != old) {
            List formals = nn.formals();
            ArrayList<HjType> formalTypes = new ArrayList<HjType>(formals.size());
            for (Formal n : formals) {
                HjType newType = (HjType)n.type().type();
                formalTypes.add(newType);
                Constraint clause = newType.realClause();
                if (clause == null || !clause.hasVar(C_Special_c.This)) continue;
                throw new SemanticException("The type of an argument to a constructor may not reference this.", n.position());
            }
            nn.constructorInstance().setFormalTypes(formalTypes);
        }
        TypeChecker childtc1 = (TypeChecker)tc.enter(parent, (Node)nn);
        List onn = nn.visitList(nn.formals(), (NodeVisitor)childtc1);
        TypeNode rett = nn.returnType();
        TypeNode nnt = (TypeNode)nn.visitChild((Node)rett, (NodeVisitor)childtc1);
        nn = nn.reconstruct(nnt);
        if (childtc1.hasErrors()) {
            throw new SemanticException();
        }
        HjType retType = (HjType)nn.returnType().type();
        if (!retType.isCanonical()) {
            return nn;
        }
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals((Type)(retTypeBase = retType.makeNoClauseVariant()), (Type)(clazz = ((HjType)(nnci = (HjConstructorInstance)nn.constructorInstance()).container()).makeNoClauseVariant()))) {
            throw new SemanticException("The return type of the constructor (" + retTypeBase + " must be derived from" + " the type of the class (" + clazz + ") on which the constructor is defined.", this.position());
        }
        nnci.setReturnType(retType);
        TypeChecker childtc2 = (TypeChecker)tc.enter(parent, (Node)nn);
        nn.visitList(nn.formals(), (NodeVisitor)childtc2);
        nn = (HjConstructorDecl)nn.body((Block)nn.visitChild((Node)nn.body(), (NodeVisitor)childtc2));
        if (childtc2.hasErrors()) {
            throw new SemanticException();
        }
        nn = (HjConstructorDecl)childtc2.leave(parent, (Node)old, (Node)nn, (NodeVisitor)childtc2);
        return nn;
    }
}

