/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbExpr;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Formal_c;
import polyglot.ast.Id;
import polyglot.ast.Id_c;
import polyglot.ast.IntLit;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.visit.HjPrettyPrinterVisitor;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjFormal_c
extends Formal_c
implements HjFormal {
    protected List<Formal> vars;
    boolean unnamed;
    int positionInArgList = -1;

    public HjFormal_c(Position pos, Flags flags, TypeNode type, Id name, List<Formal> vars) {
        super(pos, flags, type, (Id)(name == null ? new Id_c(pos, HjPrettyPrinterVisitor.getId()) : name));
        if (vars == null) {
            vars = Collections.EMPTY_LIST;
        }
        this.vars = TypedList.copyAndCheck((List)vars, Formal.class, (boolean)true);
        boolean bl = this.unnamed = name == null;
        assert (vars != null);
    }

    public Node visitChildren(NodeVisitor v) {
        HjFormal_c n = (HjFormal_c)super.visitChildren(v);
        List l = this.visitList(this.vars, v);
        if (!CollectionUtil.equals((Collection)l, this.vars)) {
            if (n == this) {
                n = (HjFormal_c)this.copy();
            }
            n.vars = TypedList.copyAndCheck((List)l, Formal.class, (boolean)true);
        }
        return n;
    }

    @Override
    public List<Formal> vars() {
        return this.vars;
    }

    @Override
    public boolean isUnnamed() {
        return this.unnamed;
    }

    @Override
    public void setPositionInArgList(int i) {
        this.positionInArgList = i;
    }

    @Override
    public int positionInArgList() {
        return this.positionInArgList;
    }

    @Override
    public LocalInstance[] localInstances() {
        LocalInstance[] lis = new LocalInstance[this.vars.size()];
        for (int i = 0; i < this.vars.size(); ++i) {
            lis[i] = this.vars.get(i).localInstance();
        }
        return lis;
    }

    public void addDecls(Context c) {
        super.addDecls(c);
        for (Formal fj : this.vars()) {
            fj.addDecls(c);
        }
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjFormal_c n = (HjFormal_c)super.buildTypes(tb);
        ((HjLocalInstance)n.localInstance()).setPositionInArgList(this.positionInArgList());
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjFormal_c result = (HjFormal_c)super.typeCheck(tc);
        HjLocalInstance li = (HjLocalInstance)result.li;
        HjType declType = (HjType)this.declType();
        li.setType(declType);
        boolean changed = li.setSelfClauseIfFinal();
        if (changed) {
            result = (HjFormal_c)result.type(result.type().type(li.type()));
        }
        return result;
    }

    private String translateVars() {
        StringBuffer sb = new StringBuffer();
        if (!this.vars.isEmpty()) {
            sb.append("[");
            for (int i = 0; i < this.vars.size(); ++i) {
                sb.append(i > 0 ? "," : "").append(this.vars.get(i).name());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String toString() {
        return super.toString() + this.translateVars();
    }

    @Override
    public boolean hasExplodedVars() {
        return !this.vars.isEmpty();
    }

    protected static LocalDecl makeLocalDecl(NodeFactory nf, Position pos, Flags flags, TypeNode type, Id name, LocalInstance li, Expr init) {
        return nf.LocalDecl(pos, flags.set(Flags.FINAL), type, name, init).localInstance(li);
    }

    @Override
    public List<Stmt> explode(NodeFactory nf, TypeSystem ts) {
        return HjFormal_c.explode(nf, ts, this.id(), this.position(), this.flags(), this.vars, this.localInstance());
    }

    @Override
    public List<Stmt> explode(NodeFactory nf, TypeSystem ts, Stmt s) {
        List<Stmt> init = this.explode(nf, ts);
        if (s != null) {
            init.add(s);
        }
        return init;
    }

    @Override
    public List<Stmt> explode(NodeFactory nf, TypeSystem ts, List<Stmt> s, boolean prepend) {
        List<Stmt> init = this.explode(nf, ts);
        if (s != null) {
            if (prepend) {
                init.addAll(s);
            } else {
                init.addAll(0, s);
            }
        }
        return init;
    }

    private static List<Stmt> explode(NodeFactory nf, TypeSystem ts, Id name, Position pos, Flags flags, List<Formal> vars, LocalInstance bli) {
        if (vars == null || vars.isEmpty()) {
            return null;
        }
        HjNodeFactory hjnf = (HjNodeFactory)nf;
        TypedList stmts = new TypedList(new ArrayList(vars.size()), Stmt.class, false);
        AmbExpr arrayBase = bli == null ? nf.AmbExpr(pos, name) : nf.Local(pos, name).localInstance(bli).type(bli.type());
        CanonicalTypeNode intType = hjnf.CanonicalTypeNode(pos, (Type)ts.Int());
        for (int i = 0; i < vars.size(); ++i) {
            Formal var = vars.get(i);
            Expr index = hjnf.IntLit(var.position(), IntLit.INT, i).type((Type)ts.Int());
            Expr init = hjnf.HjArrayAccess1(var.position(), (Expr)arrayBase, index).type((Type)ts.Int());
            LocalInstance li = var.localInstance();
            LocalDecl d = HjFormal_c.makeLocalDecl(nf, var.position(), flags, (TypeNode)intType, var.id(), li, init);
            stmts.add(d);
        }
        return stmts;
    }

    @Override
    public HjFormal_c pickUpTypeFromTypeNode(TypeChecker tc) {
        HjLocalInstance xli = (HjLocalInstance)this.li;
        HjType newType = (HjType)this.type.type();
        xli.setType(newType);
        xli.setSelfClauseIfFinal();
        return (HjFormal_c)this.type(this.type().type(xli.type()));
    }

    public Context enterChildScope(Node child, Context c) {
        HjContext cxt = (HjContext)c;
        if (child == this.type) {
            TypeSystem ts = c.typeSystem();
            LocalInstance li = this.localInstance();
            cxt.addVariable((VarInstance)li);
            cxt.setVarWhoseTypeIsBeingElaborated((VarInstance)li);
        }
        Context cc = super.enterChildScope(child, c);
        return cc;
    }

    public static List explode(NodeFactory nf, TypeSystem ts, Id name, Position pos, Flags flags, List<Formal> vars) {
        return HjFormal_c.explode(nf, ts, name, pos, flags, vars, null);
    }

    @Override
    public Formal vars(List<Formal> l) {
        if (((Object)l).equals(this.vars)) {
            return this;
        }
        HjFormal_c n = (HjFormal_c)this.copy();
        n.vars = l;
        return n;
    }
}

