/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjMethodDecl;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class HjMethodDecl_c
extends MethodDecl_c
implements HjMethodDecl {
    DepParameterExpr thisClause;
    Expr whereClause;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context");

    public HjMethodDecl_c(Position pos, DepParameterExpr thisClause, Flags flags, TypeNode returnType, Id name, List formals, Expr e, List throwTypes, Block body) {
        super(pos, flags, returnType, name, formals, throwTypes, body);
        this.whereClause = e;
    }

    public DepParameterExpr thisClause() {
        return this.thisClause;
    }

    public Expr whereClause() {
        return this.whereClause;
    }

    protected boolean listIsDisambiguated(List l) {
        for (Node o : l) {
            if (o.isDisambiguated()) continue;
            return false;
        }
        return true;
    }

    public boolean isDisambiguated() {
        return !(!this.listIsDisambiguated(this.formals) || this.thisClause != null && !this.thisClause.isDisambiguated() || this.whereClause != null && !this.whereClause.isDisambiguated() || !super.isDisambiguated());
    }

    public Context enterChildScope(Node child, Context c) {
        assert (c.currentCode() == this.methodInstance());
        if (!this.formals.isEmpty() && child != this.body()) {
            c = c.pushBlock();
            for (Formal f : this.formals) {
                f.addDecls(c);
            }
        }
        return super.enterChildScope(child, c);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        int numFormals = this.formals == null ? 0 : this.formals.size();
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(numFormals);
        for (int i = 0; i < numFormals; ++i) {
            formalTypes.add(xts.unknownType(this.position()));
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(this.throwTypes().size());
        for (int i = 0; i < this.throwTypes().size(); ++i) {
            throwTypes.add(xts.unknownType(this.position()));
        }
        Flags f = this.flags;
        if (ct.flags().isInterface()) {
            f = f.Public().Abstract();
        }
        MethodInstance mi = xts.methodInstance(this.position(), (ReferenceType)ct, f, (Type)xts.unknownType(this.position()), this.name.id(), formalTypes, throwTypes);
        ct.addMethod(mi);
        return this.flags(f).methodInstance(mi);
    }

    public void translate(CodeWriter w, Translator tr) {
        Context c = tr.context();
        Flags flags = this.flags();
        if (c.currentClass().flags().isInterface()) {
            flags = flags.clearPublic();
            flags = flags.clearAbstract();
        }
        this.flags = HjFlags.toHjFlags(flags);
        super.translate(w, tr);
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        HjMethodDecl_c nn;
        HjMethodDecl_c old = nn = this;
        int n = this.formals.size();
        List nnFormals = nn.formals();
        TypeChecker childtc = (TypeChecker)tc.enter(parent, (Node)nn);
        List processedFormals = nn.visitList(nnFormals, (NodeVisitor)childtc);
        nn = nn.formals(processedFormals);
        if (this.flags().isNative() && !this.flags().isStatic()) {
            throw new SemanticException("extern method must be declared static", this.position());
        }
        if (tc.hasErrors()) {
            throw new SemanticException();
        }
        if (nn != old) {
            List formals = nn.formals();
            ArrayList<Type> formalTypes = new ArrayList<Type>(n);
            for (int i = 0; i < n; ++i) {
                formalTypes.add(((Formal)formals.get(i)).type().type());
            }
            nn.methodInstance().setFormalTypes(formalTypes);
        }
        TypeChecker childtc1 = (TypeChecker)tc.enter(parent, (Node)nn);
        nn.visitList(nn.formals(), (NodeVisitor)childtc1);
        ((HjContext)childtc1.context()).setVarWhoseTypeIsBeingElaborated(null);
        TypeNode r = (TypeNode)nn.visitChild((Node)nn.returnType(), (NodeVisitor)childtc1);
        nn = nn.returnType(r);
        Type rt = r.type();
        if (childtc1.hasErrors()) {
            throw new SemanticException();
        }
        if (!rt.isCanonical()) {
            return nn;
        }
        nn.methodInstance().setReturnType(rt);
        TypeChecker childtc2 = (TypeChecker)tc.enter(parent, (Node)nn);
        nn.visitList(nn.formals(), (NodeVisitor)childtc2);
        nn = (MethodDecl)nn.body((Block)nn.visitChild((Node)nn.body(), (NodeVisitor)childtc2));
        if (childtc2.hasErrors()) {
            throw new SemanticException();
        }
        nn = (MethodDecl)childtc2.leave(parent, (Node)old, (Node)nn, (NodeVisitor)childtc2);
        return nn;
    }
}

