/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Node;
import polyglot.ast.Special;
import polyglot.ast.Special_c;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class HjSpecial_c
extends Special_c
implements HjSpecial {
    boolean isSelf = false;

    public HjSpecial_c(Position pos, Special.Kind kind, TypeNode qualifier) {
        super(pos, kind, qualifier);
        this.isSelf = kind.equals((Object)SELF);
    }

    public static HjSpecial self(Position pos) {
        HjSpecial_c self = new HjSpecial_c(pos, SELF, null);
        self.isSelf = true;
        return self;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HjSpecial_c)) {
            return false;
        }
        HjSpecial_c o = (HjSpecial_c)other;
        return this.isSelf == o.isSelf && this.kind.equals((Object)o.kind) && (this.qualifier == null ? o.qualifier == null : this.qualifier.equals(o.qualifier));
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        HjContext c = (HjContext)tc.context();
        ClassType t = null;
        if (this.isSelf) {
            HjNamedType tt = c.currentDepType();
            if (tt == null) {
                throw new SemanticException("self may only be used within a dependent type", this.position());
            }
            return this.type(tt);
        }
        if (this.qualifier == null) {
            t = c.currentClass();
        } else {
            if (!this.qualifier.isDisambiguated()) {
                return this;
            }
            if (this.qualifier.type().isClass()) {
                t = this.qualifier.type().toClass();
                if (!c.currentClass().hasEnclosingInstance(t)) {
                    throw new SemanticException("The nested class \"" + c.currentClass() + "\" does not have " + "an enclosing instance of type \"" + t + "\".", this.qualifier.position());
                }
            } else {
                throw new SemanticException("Invalid qualifier for \"this\" or \"super\".", this.qualifier.position());
            }
        }
        if (t == null || c.inStaticContext() && ts.equals((TypeObject)t, (TypeObject)c.currentClass())) {
            throw new SemanticException("Cannot access a non-static field or method, or refer to \"this\" or \"super\" from a static context.", this.position());
        }
        if (this.kind == THIS) {
            HjType tt = (HjType)t.copy();
            tt.setSelfVar(C_Special.This);
            return this.type(tt);
        }
        if (this.kind == SUPER) {
            return this.type(t.superType());
        }
        return this;
    }
}

