/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.HjTypeNode_c;
import polyglot.ext.hj.ast.NullableNode;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class NullableNode_c
extends HjTypeNode_c
implements NullableNode {
    protected TypeNode base;
    Type lookaheadType = null;

    public NullableNode_c(Position pos, TypeNode base) {
        super(pos);
        this.base = base;
    }

    public TypeNode base() {
        return this.base;
    }

    public NullableNode_c base(TypeNode base) {
        NullableNode_c n = (NullableNode_c)this.copy();
        n.base = base;
        return n;
    }

    protected NullableNode_c reconstruct(TypeNode base) {
        return base != this.base ? this.base(base) : this;
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover sc) throws SemanticException {
        HjType type = (HjType)((NullableNode_c)this.disambiguateBase(sc)).type();
        if (type instanceof HjNamedType) {
            this.lookaheadType = type;
        }
        return sc;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)this.base.type().typeSystem();
        HjNamedType type = (HjNamedType)((TypeNode)((HjTypeNode)this.base).typeCheckBase(tc)).type();
        this.lookaheadType = xts.createNullableType(this.position(), type);
        return tc;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.dep && this.lookaheadType instanceof HjNamedType) {
            c = ((HjContext)c).pushDepType((HjNamedType)this.lookaheadType);
        }
        return super.enterChildScope(child, c);
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode base = (TypeNode)this.visitChild((Node)this.base, v);
        NullableNode_c result = this.reconstruct(base);
        return result.superVisitChildren(v);
    }

    public Node superVisitChildren(NodeVisitor v) {
        return super.visitChildren(v);
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        boolean val;
        boolean bl = val = this.dep != null && !this.dep.isDisambiguated() || this.gen != null && !this.gen.isDisambiguated();
        if (val) {
            return this;
        }
        HjTypeNode result = (HjTypeNode)this.disambiguateBase(sc);
        return result.dep(this.gen, this.dep);
    }

    public Node disambiguateBase(AmbiguityRemover sc) throws SemanticException {
        TypeNode newType = (TypeNode)this.base.disambiguate(sc);
        if (!newType.type().isCanonical()) {
            return this;
        }
        NullableNode_c result = this.reconstruct(newType);
        return result.propagateTypeFromBase();
    }

    public NullableNode_c propagateTypeFromBase() {
        HjNamedType baseType = (HjNamedType)this.base.type();
        assert (baseType != null);
        HjTypeSystem ts = (HjTypeSystem)baseType.typeSystem();
        NullableType resultType = ts.createNullableType(this.position(), baseType);
        return (NullableNode_c)this.type(resultType);
    }

    public Node typeCheckBase(TypeChecker tc) throws SemanticException {
        return super.typeCheckBase(tc);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeNode newType = (HjTypeNode)this.base.del().typeCheck(tc);
        NullableNode_c result = this.reconstruct(newType);
        result = result.propagateTypeFromBase();
        return HjTypeNode_c.typeCheckDepClause(result, tc);
    }

    public Node oldTypeCheckBase(TypeChecker tc) throws SemanticException {
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[NullableNode_c] Type checking |" + this + "|:"));
        }
        Node n = this.base.del().typeCheck(tc);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[NullableNode_c] ... yields node |" + n + "|."));
        }
        if (!(n instanceof TypeNode)) {
            throw new SemanticException("Argument to nullable type-constructor does not type-check", this.position());
        }
        TypeNode arg = (TypeNode)n;
        HjNamedType argType = (HjNamedType)arg.type();
        HjTypeSystem ts = (HjTypeSystem)argType.typeSystem();
        NullableType resultType = ts.createNullableType(this.position(), argType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[NullableNode_c] ... sets type to |" + this.type + "|."));
            Report.report((int)5, (String)("[NullableNode_c] ... returns |" + this + "|."));
        }
        return this.type(resultType);
    }

    public String toString() {
        return "nullable<" + this.base.toString() + ">";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        w.write("/*nullable*/");
        this.base.del().prettyPrint(w, pp);
    }
}

