/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbExpr;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjFieldDecl_c;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.PropertyDecl;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDecl_c
extends HjFieldDecl_c
implements PropertyDecl {
    MethodDecl getter;
    MethodDecl abstractGetter;

    public PropertyDecl_c(Position pos, Flags flags, TypeNode type, Id name, HjNodeFactory nf) {
        this(pos, flags, type, name, null, nf);
    }

    public PropertyDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init, HjNodeFactory nf) {
        super(pos, flags, type, name, init);
    }

    public static ClassBody addProperties(List<PropertyDecl> properties, ClassBody body, HjNodeFactory nf) {
        if (properties != null && !properties.isEmpty()) {
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                PropertyDecl p = properties.get(i);
                MethodDecl getter = ((PropertyDecl_c)p).getter(nf);
                body = body.addMember((ClassMember)getter);
                body = body.addMember((ClassMember)p);
            }
            body = body.addMember(PropertyDecl_c.makePropertyNamesField(properties, nf));
        }
        return body;
    }

    public static ClassBody addGetters(List<PropertyDecl> properties, ClassBody body, HjNodeFactory nf) {
        if (properties != null && !properties.isEmpty()) {
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                PropertyDecl p = properties.get(i);
                body = body.addMember((ClassMember)((PropertyDecl_c)p).abstractGetter(nf));
                body = body.addMember((ClassMember)p);
            }
            body = body.addMember(PropertyDecl_c.makePropertyNamesField(properties, nf));
        }
        return body;
    }

    public static ClassMember makePropertyNamesField(List<PropertyDecl> properties, HjNodeFactory nf) {
        Position pos = Position.COMPILER_GENERATED;
        TypeSystem ts = nf.extensionInfo().typeSystem();
        CanonicalTypeNode tn = nf.CanonicalTypeNode(pos, (Type)ts.String());
        StringBuffer s = new StringBuffer();
        for (PropertyDecl p : properties) {
            s = s.append(p.name()).append(" ");
        }
        FieldDecl f = new PropertyDecl_c(pos, Flags.PUBLIC.Static().Final(), (TypeNode)tn, nf.Id(pos, "propertyNames$"), nf.StringLit(pos, s.toString()).type((Type)ts.String()), nf).type((TypeNode)nf.CanonicalTypeNode(pos, (Type)ts.String()));
        return f;
    }

    @Override
    public MethodDecl getter() {
        return this.getter;
    }

    protected MethodDecl getter(HjNodeFactory nf) {
        HjTypeSystem ts = (HjTypeSystem)nf.extensionInfo().typeSystem();
        Position pos = Position.COMPILER_GENERATED;
        Flags flags = Flags.PUBLIC.Final();
        List formals = Collections.EMPTY_LIST;
        List throwTypes = Collections.EMPTY_LIST;
        AmbExpr e = nf.AmbExpr(pos, this.name);
        Return s = nf.Return(pos, (Expr)e);
        Block body = nf.Block(pos, (Stmt)s);
        this.getter = nf.MethodDecl(pos, flags, this.type, this.name, formals, throwTypes, body);
        return this.getter;
    }

    @Override
    public MethodDecl abstractGetter() {
        return this.abstractGetter;
    }

    protected MethodDecl abstractGetter(HjNodeFactory nf) {
        this.abstractGetter = nf.MethodDecl(Position.COMPILER_GENERATED, Flags.PUBLIC.Abstract(), this.type, this.name, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null);
        return this.abstractGetter;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        PropertyDecl_c n = (PropertyDecl_c)super.buildTypes(tb);
        if (n.fi == null) {
            return this;
        }
        Flags f = n.flags;
        f = f.clearStatic();
        if (n.ii != null) {
            n.ii.setFlags(Flags.NONE);
        }
        n.fi.setFlags(f);
        return n.flags(f);
    }
}

