/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ext.hj.ast.HjCall_c;
import polyglot.ext.hj.ast.RectRegionMaker;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Lit_c;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class RectRegionMaker_c
extends HjCall_c
implements RectRegionMaker {
    public RectRegionMaker_c(Position pos, Receiver target, Id name, List arguments) {
        super(pos, target, name, arguments);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        RectRegionMaker_c n = (RectRegionMaker_c)super.typeCheck(tc);
        HjParsedClassType type = ((HjParsedClassType)n.type()).makeVariant();
        type.setRank(new C_Lit_c(new Integer(this.arguments.size()), (Type)xts.Int()));
        boolean isZeroBased = true;
        C_Var base = null;
        for (int i = 0; i < this.arguments.size(); ++i) {
            Expr e = (Expr)this.arguments.get(i);
            HjType t = (HjType)e.type();
            if (!xts.isSubtype(t, (Type)xts.region())) {
                throw new SemanticException("The argument, " + e + ", should be of type region instead of " + t + ".", this.position());
            }
            HjParsedClassType tp = (HjParsedClassType)t;
            C_Var rank = tp.rank();
            if (!xts.ONE().equals(rank)) {
                throw new SemanticException("The argument, " + e + ", should be of type region(:rank==1) instead of " + t + ".", this.position());
            }
            isZeroBased &= tp.isZeroBased();
            base = tp.base();
        }
        if (isZeroBased) {
            type.setBase(xts.ZERO());
        }
        type.setRect();
        Expr ret = n.type(type);
        return ret;
    }
}

