/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.RectRegionMaker;
import polyglot.ext.hj.ast.Tuple;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Tuple_c
extends Expr_c
implements Tuple {
    protected List args;
    protected Receiver pointReceiver;
    protected Receiver regionReceiver;
    protected MethodInstance pointMI;
    protected MethodInstance regionMI;

    public Tuple_c(Position pos, Receiver pointReceiver, Receiver regionReceiver, List args) {
        super(pos);
        this.pointReceiver = pointReceiver;
        this.regionReceiver = regionReceiver;
        this.args = args;
        assert (args.size() > 0);
    }

    public List arguments() {
        return this.args;
    }

    public Receiver pointReceiver() {
        return this.pointReceiver;
    }

    public Receiver regionReceiver() {
        return this.regionReceiver;
    }

    public MethodInstance pointMI() {
        return this.pointMI;
    }

    public MethodInstance regionMI() {
        return this.regionMI;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Type argType = ((Expr)this.args.get(0)).type();
        if (argType.isInt()) {
            return nf.Call(this.position(), this.pointReceiver, nf.Id(this.position(), "point"), this.args).del().typeCheck(tc);
        }
        RectRegionMaker result = (RectRegionMaker)nf.RectRegionMaker(this.position(), this.regionReceiver, nf.Id(this.position(), "region"), this.args).del().typeCheck(tc);
        return result;
    }

    public Term firstChild() {
        return Tuple_c.listChild((List)this.args, null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.args, (Term)this, 0);
        return succs;
    }

    public Tuple_c methodInstance(MethodInstance p, MethodInstance r) {
        Tuple_c n = (Tuple_c)this.copy();
        n.pointMI = p;
        n.regionMI = r;
        return n;
    }

    public Tuple_c reconstruct(Receiver pointR, Receiver regionR, List args) {
        if (this.pointReceiver == pointR && this.regionReceiver == regionR && this.args == args) {
            return this;
        }
        Tuple_c n = (Tuple_c)this.copy();
        n.pointReceiver = pointR;
        n.regionReceiver = regionR;
        n.args = args;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver pointR = (Receiver)this.visitChild((Node)this.pointReceiver, v);
        Receiver regionR = (Receiver)this.visitChild((Node)this.regionReceiver, v);
        List args = this.visitList(this.args, v);
        return this.reconstruct(pointR, regionR, args);
    }

    public void dump(CodeWriter w) {
        w.write("Tuple: ");
        super.dump(w);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        throw new InternalError("Ambiguous Node cannot be rewritten.");
    }
}

