/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.When;
import polyglot.ext.hj.types.HjContext;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class When_c
extends Stmt_c
implements CompoundStmt,
When {
    protected List positions;
    protected List exprs;
    protected List stmts;
    protected Expr expr;
    protected Stmt stmt;

    public Expr expr() {
        return this.expr;
    }

    public Stmt stmt() {
        return this.stmt;
    }

    public When_c(Position p, Expr expr, Stmt stmt) {
        super(p);
        this.expr = expr;
        this.stmt = stmt;
        this.positions = new TypedList(new LinkedList(), Position.class, false);
        this.exprs = new TypedList(new LinkedList(), Expr.class, false);
        this.stmts = new TypedList(new LinkedList(), Stmt.class, false);
    }

    public void addBranch(Position p, Expr e, Stmt s) {
        this.positions.add(p);
        this.exprs.add(e);
        this.stmts.add(s);
    }

    public List exprs() {
        return this.exprs;
    }

    public List stmts() {
        return this.stmts;
    }

    private boolean isSame(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator i = a.iterator();
        Iterator j = b.iterator();
        while (i.hasNext()) {
            if (i.next() == j.next()) continue;
            return false;
        }
        return true;
    }

    public When reconstruct(Expr expr, Stmt stmt, List exprs, List stmts) {
        if (expr == this.expr && stmt == this.stmt && this.isSame(exprs, this.exprs) && this.isSame(stmts, this.stmts)) {
            return this;
        }
        When_c n = (When_c)this.copy();
        n.expr = expr;
        n.stmt = stmt;
        n.exprs = TypedList.copyAndCheck((List)exprs, Expr.class, (boolean)true);
        n.stmts = TypedList.copyAndCheck((List)stmts, Stmt.class, (boolean)true);
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr e = (Expr)this.visitChild((Node)this.expr, v);
        Stmt s = (Stmt)this.visitChild((Node)this.stmt, v);
        List es = this.visitList(this.exprs, v);
        List ss = this.visitList(this.stmts, v);
        return this.reconstruct(e, s, es, ss);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjContext c = (HjContext)tc.context();
        if (c.inNonBlockingCode()) {
            throw new SemanticException("The when statement cannot be used in nonblocking code.", this.position());
        }
        return super.typeCheck(tc);
    }

    public String toString() {
        return "when (" + this.expr + ")" + this.stmt + (this.exprs.size() > 0 ? "..." : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("when (");
        this.printBlock((Node)this.expr, w, tr);
        w.write(") ");
        this.printSubStmt(this.stmt, w, tr);
        if (this.exprs.size() > 0) {
            Iterator es = this.exprs.iterator();
            Iterator ss = this.stmts.iterator();
            while (es.hasNext()) {
                Expr e = (Expr)es.next();
                Stmt s = (Stmt)ss.next();
                w.write("or (");
                this.printBlock((Node)e, w, tr);
                w.write(") ");
                this.printSubStmt(s, w, tr);
            }
        }
    }

    public Term firstChild() {
        return this.expr;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        Expr e = this.expr;
        Stmt s = this.stmt;
        Expr ne = null;
        Iterator es = this.exprs.iterator();
        Iterator ss = this.stmts.iterator();
        while (es.hasNext()) {
            ne = (Expr)es.next();
            v.visitCFG((Term)e, FlowGraph.EDGE_KEY_TRUE, (Term)s, 1, FlowGraph.EDGE_KEY_FALSE, (Term)ne, 1);
            v.visitCFG((Term)s, (Term)this, 0);
            e = ne;
            s = (Stmt)ss.next();
        }
        v.visitCFG((Term)e, FlowGraph.EDGE_KEY_TRUE, (Term)s, 1, FlowGraph.EDGE_KEY_FALSE, (Term)this.expr, 1);
        v.visitCFG((Term)s, (Term)this, 0);
        return succs;
    }
}

