/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import polyglot.ast.Node;
import polyglot.ast.SourceFile;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.dom.DomGenerator;
import polyglot.ext.hj.dom.DomReader;
import polyglot.ext.hj.dom.HjDom;
import polyglot.ext.hj.dom.XMLReader;
import polyglot.ext.hj.dom.XMLWriter;
import polyglot.ext.hj.plugin.CompilerPlugin;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.util.ErrorQueue;
import polyglot.util.QuotedStringTokenizer;
import polyglot.visit.NodeVisitor;

public class ExternalizerPlugin
implements CompilerPlugin {
    public Goal register(ExtensionInfo extInfo, Job job) {
        Goal g = ExternalizerPluginGoal.create(extInfo.scheduler(), job);
        ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)extInfo.scheduler();
        hjSched.addDependencyAndEnqueue(hjSched.HjBoxed(job), g, true);
        return g;
    }

    public static class ExternalizerPluginGoal
    extends AbstractGoal {
        public static Goal create(Scheduler scheduler, Job job) {
            return scheduler.internGoal((Goal)new ExternalizerPluginGoal(job));
        }

        private ExternalizerPluginGoal(Job job) {
            super(job);
        }

        public Collection prerequisiteGoals(Scheduler scheduler) {
            ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)scheduler;
            ArrayList<Goal> l = new ArrayList<Goal>();
            l.add(hjSched.TypeChecked(this.job));
            l.add(hjSched.ConstantsChecked(this.job));
            l.add(hjSched.PropagateAnnotations(this.job));
            l.addAll(super.prerequisiteGoals(scheduler));
            return l;
        }

        public Pass createPass(polyglot.frontend.ExtensionInfo extInfo) {
            return new ExternalizerPass((Goal)this, extInfo);
        }
    }

    protected static class ExternalizerPass
    extends AbstractPass {
        private final polyglot.frontend.ExtensionInfo info;

        protected ExternalizerPass(Goal goal, polyglot.frontend.ExtensionInfo info) {
            super(goal);
            this.info = info;
        }

        public boolean run() {
            Job job = this.goal().job();
            HjTypeSystem ts = (HjTypeSystem)this.info.typeSystem();
            HjNodeFactory nf = (HjNodeFactory)this.info.nodeFactory();
            String xmlFile = this.getXMLFileName(this.info, job);
            ErrorQueue eq = job.compiler().errorQueue();
            String xmlProcessor = Configuration.XML_PROCESSOR;
            boolean exportXML = Configuration.EXTERNALIZE_ASTS;
            boolean importXML = false;
            if (xmlProcessor != null && !xmlProcessor.equals("")) {
                exportXML = true;
                importXML = true;
            }
            if (Report.should_report((String)"xml", (int)1)) {
                exportXML = true;
                importXML = true;
            }
            HjDom dom = new HjDom(ts, nf);
            if (exportXML) {
                DomGenerator gen = new DomGenerator();
                Element e = gen.gen(dom, job.ast());
                try {
                    XMLWriter w = new XMLWriter(xmlFile);
                    w.writeElement(e);
                    w.close();
                }
                catch (IOException ex) {
                    eq.enqueue(2, ex.getMessage());
                    return false;
                }
            }
            if (xmlProcessor != null && !xmlProcessor.equals("") && !this.processXMLFile(xmlFile, xmlProcessor, eq)) {
                return false;
            }
            if (importXML) {
                Element e;
                try {
                    XMLReader r = new XMLReader(xmlFile);
                    e = r.readElement();
                    r.close();
                }
                catch (IOException ex) {
                    eq.enqueue(2, ex.getMessage());
                    return false;
                }
                DomReader ungen = new DomReader(ts, nf, job.source());
                Node n = ungen.fromXML(dom, e);
                job.ast(n);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processXMLFile(String xmlFile, String xmlProcessor, ErrorQueue eq) {
            boolean okay = true;
            Runtime runtime = Runtime.getRuntime();
            QuotedStringTokenizer st = new QuotedStringTokenizer(xmlProcessor);
            int pc_size = st.countTokens();
            String[] cmd = new String[pc_size + 1];
            int j = 0;
            for (int i = 0; i < pc_size; ++i) {
                cmd[j++] = st.nextToken();
            }
            cmd[j++] = xmlFile;
            if (Report.should_report((String)"verbose", (int)1)) {
                StringBuffer cmdStr = new StringBuffer();
                for (int i = 0; i < cmd.length; ++i) {
                    cmdStr.append(cmd[i] + " ");
                }
                Report.report((int)1, (String)("Executing XML processor " + cmdStr));
            }
            try {
                Process proc = runtime.exec(cmd);
                InputStreamReader err = new InputStreamReader(proc.getErrorStream());
                try {
                    int len;
                    char[] c = new char[72];
                    StringBuffer sb = new StringBuffer();
                    while ((len = err.read(c)) > 0) {
                        sb.append(String.valueOf(c, 0, len));
                    }
                    if (sb.length() != 0) {
                        eq.enqueue(6, sb.toString());
                    }
                }
                finally {
                    err.close();
                }
                proc.waitFor();
                if (proc.exitValue() > 0) {
                    eq.enqueue(6, "Non-zero return code: " + proc.exitValue());
                    okay = false;
                }
            }
            catch (Exception ex) {
                eq.enqueue(6, ex.getMessage());
                okay = false;
            }
            return okay;
        }

        protected String getXMLFileName(polyglot.frontend.ExtensionInfo extInfo, Job job) {
            final String[] packageName = new String[1];
            job.ast().visit(new NodeVisitor(){

                public Node override(Node n) {
                    if (n instanceof SourceFile) {
                        SourceFile sf = (SourceFile)n;
                        if (sf.package_() != null) {
                            packageName[0] = sf.package_().package_().fullName();
                        }
                        return n;
                    }
                    return null;
                }
            });
            File f = extInfo.targetFactory().outputFile(packageName[0], job.source());
            String xmlFile = f.getPath();
            int index = f.getPath().lastIndexOf(".java");
            xmlFile = index >= 0 ? f.getPath().substring(0, index) + ".hjml" : f.getPath() + ".hjml";
            return xmlFile;
        }
    }
}

