/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Branch;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.FieldDecl;
import polyglot.ast.FloatLit;
import polyglot.ast.Id;
import polyglot.ast.Import;
import polyglot.ast.IntLit;
import polyglot.ast.MethodDecl;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Precedence;
import polyglot.ast.SourceFile;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.AtEach;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.Finish;
import polyglot.ext.hj.ast.ForEach;
import polyglot.ext.hj.ast.ForLoop;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.ast.HjDelFactory_c;
import polyglot.ext.hj.ast.HjMLSourceFile;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.ast.NullableNode;
import polyglot.ext.hj.dom.DomGenerator;
import polyglot.ext.hj.dom.DomReader;
import polyglot.ext.hj.dom.HjMLClassInitializer;
import polyglot.ext.hj.extension.HjDel;
import polyglot.ext.hj.extension.HjExt;
import polyglot.ext.hj.types.ClosureInstance;
import polyglot.ext.hj.types.ClosureInstance_c;
import polyglot.ext.hj.types.ClosureType;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjMethodInstance;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.constr.C_BinaryTerm;
import polyglot.ext.hj.types.constr.C_BinaryTerm_c;
import polyglot.ext.hj.types.constr.C_EQV;
import polyglot.ext.hj.types.constr.C_EQV_c;
import polyglot.ext.hj.types.constr.C_Field;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Here_c;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Lit_c;
import polyglot.ext.hj.types.constr.C_Local;
import polyglot.ext.hj.types.constr.C_Local_c;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Term_c;
import polyglot.ext.hj.types.constr.C_Type;
import polyglot.ext.hj.types.constr.C_Type_c;
import polyglot.ext.hj.types.constr.C_UnaryTerm;
import polyglot.ext.hj.types.constr.C_UnaryTerm_c;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Constraint_c;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.ext.hj.types.constr.Promise_c;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Declaration;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.InitializerInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NullType;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Enum;
import polyglot.util.IdentityKey;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.util.SubtypeSet;
import polyglot.util.UniqueID;
import polyglot.visit.InitImportsVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjDom {
    HjTypeSystem ts;
    HjNodeFactory nf;
    Map<String, Lens> tagMap;

    public HjDom(HjTypeSystem ts, HjNodeFactory nf) {
        this.ts = ts;
        this.nf = nf;
    }

    public Map<String, Lens> tagMap() {
        if (this.tagMap != null) {
            return this.tagMap;
        }
        this.tagMap = new HashMap<String, Lens>();
        this.tagMap.put("Boolean", new BooleanLens());
        this.tagMap.put("Byte", new ByteLens());
        this.tagMap.put("Short", new ShortLens());
        this.tagMap.put("Char", new CharLens());
        this.tagMap.put("Int", new IntLens());
        this.tagMap.put("Long", new LongLens());
        this.tagMap.put("Float", new FloatLens());
        this.tagMap.put("Double", new DoubleLens());
        this.tagMap.put("String", new StringLens());
        this.tagMap.put("List", new ListLens<Object>(new ObjectLens()));
        this.tagMap.put("StringArray", new StringArrayLens());
        this.tagMap.put("SubtypeSet", new SubtypeSetLens());
        this.tagMap.put("Constraint", new ConstraintLens());
        this.tagMap.put("CTerm", new CTermLens());
        this.tagMap.put("CVar", new CVarLens());
        this.tagMap.put("Promise", new PromiseRefLens());
        this.tagMap.put("Package", new PackageLens());
        this.tagMap.put("TypeRef", new TypeRefLens());
        this.tagMap.put("ConstructorInstanceRef", new ConstructorInstanceRefLens());
        this.tagMap.put("FieldInstanceRef", new FieldInstanceRefLens());
        this.tagMap.put("ClosureInstanceRef", new ClosureInstanceRefLens());
        this.tagMap.put("InitializerInstanceRef", new InitializerInstanceRefLens());
        this.tagMap.put("LocalInstanceRef", new LocalInstanceRefLens());
        this.tagMap.put("MethodInstanceRef", new MethodInstanceRefLens());
        this.tagMap.put("SourceFile", new SourceFileLens());
        this.tagMap.put("NewArray", new NewArrayLens());
        this.tagMap.put("Flags", new FlagsLens());
        this.tagMap.put("Position", new PositionLens());
        this.tagMap.put("AssignOp", new AssignOpLens());
        this.tagMap.put("BinaryOp", new BinaryOpLens());
        this.tagMap.put("UnaryOp", new UnaryOpLens());
        this.tagMap.put("ClassTypeKind", new EnumLens("ClassTypeKind", (Enum[])new ClassType.Kind[]{ClassType.ANONYMOUS, ClassType.LOCAL, ClassType.MEMBER, ClassType.TOP_LEVEL}));
        this.tagMap.put("IntLitKind", new EnumLens("IntLitKind", (Enum[])new IntLit.Kind[]{IntLit.INT, IntLit.LONG}));
        this.tagMap.put("FloatLitKind", new EnumLens("FloatLitKind", (Enum[])new FloatLit.Kind[]{FloatLit.FLOAT, FloatLit.DOUBLE}));
        this.tagMap.put("ImportKind", new EnumLens("ImportKind", (Enum[])new Import.Kind[]{Import.CLASS, Import.PACKAGE}));
        this.tagMap.put("SpecialKind", new EnumLens("SpecialKind", (Enum[])new Special.Kind[]{Special.THIS, Special.SUPER}));
        this.tagMap.put("HjSpecialKind", new EnumLens("HjSpecialKind", (Enum[])new Special.Kind[]{HjSpecial.THIS, HjSpecial.SUPER, HjSpecial.SELF}));
        this.tagMap.put("ConstructorCallKind", new EnumLens("ConstructorCallKind", (Enum[])new ConstructorCall.Kind[]{ConstructorCall.THIS, ConstructorCall.SUPER}));
        this.tagMap.put("BranchKind", new EnumLens("BranchKind", (Enum[])new Branch.Kind[]{Branch.BREAK, Branch.CONTINUE}));
        return this.tagMap;
    }

    public <T> T get(Lens<T> lens, Element e, String tag, DomReader v) {
        T x = this.getImpl(lens, e, tag, v);
        if (x == null) {
            if (lens instanceof ListLens) {
                return (T)Collections.EMPTY_LIST;
            }
            if (lens instanceof MapLens) {
                return (T)Collections.EMPTY_MAP;
            }
        }
        return x;
    }

    protected <T> T getImpl(Lens<T> lens, Element e, String tag, DomReader v) {
        if (e == null) {
            return null;
        }
        Element field = this.getChild(e, tag);
        if (field == null) {
            return null;
        }
        Element child = this.getFirstElement(field);
        if (child == null) {
            return null;
        }
        return lens.fromXML(v, child);
    }

    public <T> void gen(DomGenerator v, String tag, T n) {
        if (n == null) {
            return;
        }
        new ObjectLens().toXML(v.tag(tag), (Object)n);
    }

    public Element getFirstElement(Element e) {
        for (org.w3c.dom.Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public Element getChild(Element e, String tag) {
        for (org.w3c.dom.Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element x;
            if (!(child instanceof Element) || !(x = (Element)child).getTagName().equals(tag)) continue;
            return x;
        }
        return null;
    }

    public <T extends Enum> T getEnum(Element e, String tag, T[] options, DomReader v) {
        String kindStr = this.get(new StringLens(), e, tag, v);
        for (int i = 0; i < options.length; ++i) {
            if (!kindStr.equals(options[i].toString())) continue;
            return options[i];
        }
        throw new InternalCompilerError("Bad kind " + kindStr);
    }

    public <T> void addType(DomGenerator v, T t, Lens<T> lens) {
        IdentityKey tkey = new IdentityKey(t);
        String key = v.typesMap.get(tkey);
        if (key == null) {
            key = this.keyString(t);
            v.typesMap.put(tkey, key);
            DomGenerator v1 = (DomGenerator)v.copy();
            v1.parent = v.createElement(v1.types, "item");
            this.gen(v1, "key", key);
            DomGenerator v2 = v1.tag("value");
            lens.toXML(v2, t);
        }
        new ObjectLens().toXML(v.tag("key"), key);
    }

    public String keyString(Object t) {
        String key = StringUtil.getShortNameComponent((String)t.getClass().getName());
        if (t instanceof Named) {
            key = ((Named)t).fullName().replace('.', '$');
        } else if (t instanceof FieldInstance) {
            key = this.keyString(((FieldInstance)t).container()) + "$" + ((FieldInstance)t).name();
        } else if (t instanceof MethodInstance) {
            key = this.keyString(((MethodInstance)t).container()) + "$" + ((MethodInstance)t).name();
        } else if (t instanceof ConstructorInstance) {
            key = this.keyString(((ConstructorInstance)t).container()) + "$" + ((ClassType)((ConstructorInstance)t).container()).name();
        } else if (t instanceof LocalInstance) {
            key = ((LocalInstance)t).name();
        }
        return UniqueID.newID((String)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeLens
    implements Lens<Node> {
        @Override
        public void toXML(DomGenerator v, Node n) {
            if (n instanceof SourceFile) {
                new SourceFileLens().toXML(v, (SourceFile)n);
                return;
            }
            if (n instanceof NewArray) {
                new NewArrayLens().toXML(v, (NewArray)n);
                return;
            }
            new DefaultLens().toXML(v, n);
        }

        @Override
        public Node fromXML(DomReader v, Element e) {
            if (e == null) {
                return null;
            }
            if (e.getTagName().equals("SourceFile")) {
                SourceFile n = new SourceFileLens().fromXML(v, e);
                return n;
            }
            if (e.getTagName().equals("NewArray")) {
                NewArray n = new NewArrayLens().fromXML(v, e);
                return n;
            }
            Node n = (Node)new DefaultNodeLens().fromXML(v, e);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultLens
    implements Lens<Object> {
        HjDom dom;

        public DefaultLens() {
            this.dom = HjDom.this;
        }

        @Override
        public Object fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (org.w3c.dom.Node x = e.getFirstChild(); x != null; x = x.getNextSibling()) {
                Element child;
                Element field;
                if (!(x instanceof Element) || (field = (Element)x) == null || (child = this.dom.getFirstElement(field)) == null) continue;
                Object o = this.dom.new ObjectLens().fromXML(v, child);
                m.put(field.getTagName(), o);
            }
            String[] names = new String[]{"polyglot.ext.hj.ast." + tag + "_c", "polyglot.ext.hj.ast." + tag, "polyglot.ext.hj.extension." + tag + "_c", "polyglot.ext.hj.extension." + tag, "polyglot.ast." + tag + "_c", "polyglot.ast." + tag, "polyglot.ext.hj.types." + tag + "_c", "polyglot.ext.hj.types." + tag, "polyglot.types." + tag + "_c", "polyglot.types." + tag};
            Class c = null;
            if (tag.equals("Position")) {
                c = Position.class;
            }
            if (c == null) {
                for (String name : names) {
                    try {
                        c = Class.forName(name);
                        break;
                    }
                    catch (ClassNotFoundException exn) {
                    }
                }
            }
            if (c == null) {
                throw new InternalCompilerError("Could not find class for " + tag);
            }
            Object o = this.alloc(c, m);
            this.init(v, tag, e, o, m);
            return o;
        }

        void init(DomReader v, String tag, Element e, Object o, Map<String, Object> fieldMap) {
            try {
                for (Class<?> c = o.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                    AccessibleObject[] fields = c.getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    for (int i = 0; i < fields.length; ++i) {
                        AccessibleObject field = fields[i];
                        if ((((Field)field).getModifiers() & 8) != 0) continue;
                        Object x = fieldMap.get(((Field)field).getName());
                        x = this.overrideField(o, (Field)field, x);
                        if ((((Field)field).getModifiers() & 0x80) != 0) assert (x != null);
                        try {
                            ((Field)field).set(o, x);
                            continue;
                        }
                        catch (IllegalAccessException exn) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (SecurityException exn) {
                // empty catch block
            }
        }

        protected Object overrideField(Object obj, Field field, Object fieldValue) {
            return fieldValue;
        }

        Object alloc(Class c, Map<String, Object> fields) {
            if (c.isInterface()) {
                throw new InternalCompilerError("Attempting to instantiate interface " + c.getName());
            }
            if ((c.getModifiers() & 0x400) != 0) {
                throw new InternalCompilerError("Attempting to instantiate abstract class " + c.getName());
            }
            try {
                AccessibleObject[] ctors = c.getDeclaredConstructors();
                AccessibleObject.setAccessible(ctors, true);
                if (ctors.length == 0) {
                    throw new InternalCompilerError("No constructor found for " + c);
                }
                Map<String, Object> m = fields;
                Class<?>[] formals = ((Constructor)ctors[0]).getParameterTypes();
                Object[] actuals = new Object[formals.length];
                block6: for (int i = 0; i < formals.length; ++i) {
                    actuals[i] = null;
                    for (Object oj : m.values()) {
                        if (!formals[i].isInstance(oj)) continue;
                        actuals[i] = oj;
                        continue block6;
                    }
                    if (formals[i].isPrimitive()) {
                        if (formals[i] == Boolean.TYPE) {
                            actuals[i] = false;
                        }
                        if (formals[i] == Byte.TYPE) {
                            actuals[i] = (byte)0;
                        }
                        if (formals[i] == Character.TYPE) {
                            actuals[i] = Character.valueOf('\u0000');
                        }
                        if (formals[i] == Short.TYPE) {
                            actuals[i] = (short)0;
                        }
                        if (formals[i] == Integer.TYPE) {
                            actuals[i] = 0;
                        }
                        if (formals[i] == Long.TYPE) {
                            actuals[i] = 0L;
                        }
                        if (formals[i] == Float.TYPE) {
                            actuals[i] = Float.valueOf(0.0f);
                        }
                        if (formals[i] == Double.TYPE) {
                            actuals[i] = 0.0;
                        }
                    }
                    if (formals[i] == Position.class) {
                        actuals[i] = Position.COMPILER_GENERATED;
                    }
                    if (formals[i] == List.class) {
                        actuals[i] = Collections.EMPTY_LIST;
                    }
                    if (formals[i] == Flags.class) {
                        actuals[i] = Flags.NONE;
                    }
                    if (formals[i] == String.class) {
                        actuals[i] = "$$$";
                    }
                    if (actuals[i] == null) continue;
                }
                return ((Constructor)ctors[0]).newInstance(actuals);
            }
            catch (IllegalArgumentException exn) {
                throw new InternalCompilerError("No constructor found for " + c + ".", (Throwable)exn);
            }
            catch (IllegalAccessException exn) {
                throw new InternalCompilerError("No constructor found for " + c + ".", (Throwable)exn);
            }
            catch (InstantiationException exn) {
                throw new InternalCompilerError("No constructor found for " + c + ".", (Throwable)exn);
            }
            catch (InvocationTargetException exn) {
                throw new InternalCompilerError("No constructor found for " + c + ".", (Throwable)exn);
            }
            catch (SecurityException exn) {
                throw new InternalCompilerError("No constructor found for " + c + ".", (Throwable)exn);
            }
        }

        String nodeTag(Object n) {
            String tag = n.getClass().getName();
            if ((tag = StringUtil.getShortNameComponent((String)tag)).endsWith("_c")) {
                tag = tag.substring(0, tag.length() - 2);
            }
            return tag;
        }

        @Override
        public void toXML(DomGenerator v, Object n) {
            v = v.tag(this.nodeTag(n));
            try {
                for (Class<?> c = n.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                    AccessibleObject[] fields = c.getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    for (int i = 0; i < fields.length; ++i) {
                        AccessibleObject field = fields[i];
                        if ((((Field)field).getModifiers() & 8) != 0 || (((Field)field).getModifiers() & 0x80) != 0) continue;
                        try {
                            Object o = ((Field)field).get(n);
                            if (o == null || !this.shouldFollow(n, ((Field)field).getName(), o)) continue;
                            this.dom.gen(v, ((Field)field).getName(), o);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new InternalCompilerError((Throwable)e);
                        }
                    }
                }
            }
            catch (SecurityException e) {
                throw new InternalCompilerError((Throwable)e);
            }
        }

        public boolean shouldFollow(Object obj, String name, Object fieldValue) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ObjectLens
    implements Lens<Object> {
        @Override
        public Object fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            Lens lens = HjDom.this.tagMap().get(tag);
            if (lens == null) {
                lens = new DefaultNodeLens();
            }
            return lens.fromXML(v, e);
        }

        @Override
        public void toXML(DomGenerator v, Object o) {
            if (o instanceof Boolean) {
                new BooleanLens().toXML(v, (Boolean)o);
            } else if (o instanceof Character) {
                new CharLens().toXML(v, (Character)o);
            } else if (o instanceof Integer) {
                new IntLens().toXML(v, (Integer)o);
            } else if (o instanceof Long) {
                new LongLens().toXML(v, (Long)o);
            } else if (o instanceof Double) {
                new DoubleLens().toXML(v, (Double)o);
            } else if (o instanceof String) {
                new StringLens().toXML(v, (String)o);
            } else if (o instanceof List) {
                new ListLens<Object>(new ObjectLens()).toXML(v, (List)o);
            } else if (o instanceof Map) {
                new MapLens<Object, Object>(new ObjectLens(), new ObjectLens()).toXML(v, (Map)o);
            } else if (o instanceof Position) {
                new PositionLens().toXML(v, (Position)o);
            } else if (o instanceof Flags) {
                new FlagsLens().toXML(v, (Flags)o);
            } else if (o instanceof LocalInstance) {
                new LocalInstanceRefLens().toXML(v, (LocalInstance)o);
            } else if (o instanceof MethodInstance) {
                new MethodInstanceRefLens().toXML(v, (MethodInstance)o);
            } else if (o instanceof ConstructorInstance) {
                new ConstructorInstanceRefLens().toXML(v, (ConstructorInstance)o);
            } else if (o instanceof FieldInstance) {
                new FieldInstanceRefLens().toXML(v, (FieldInstance)o);
            } else if (o instanceof ClosureInstance) {
                new ClosureInstanceRefLens().toXML(v, (ClosureInstance)o);
            } else if (o instanceof InitializerInstance) {
                new InitializerInstanceRefLens().toXML(v, (InitializerInstance)o);
            } else if (o instanceof Type) {
                new TypeRefLens().toXML(v, (Type)o);
            } else if (o instanceof Package) {
                new PackageLens().toXML(v, (Package)o);
            } else if (o instanceof Node) {
                new NodeLens().toXML(v, (Node)o);
            } else if (o instanceof ClassType.Kind) {
                new EnumLens("ClassTypeKind", (Enum[])new ClassType.Kind[]{ClassType.ANONYMOUS, ClassType.LOCAL, ClassType.MEMBER, ClassType.TOP_LEVEL}).toXML(v, (Enum)o);
            } else if (o instanceof Assign.Operator) {
                new AssignOpLens().toXML(v, (Assign.Operator)o);
            } else if (o instanceof Binary.Operator) {
                new BinaryOpLens().toXML(v, (Binary.Operator)o);
            } else if (o instanceof Unary.Operator) {
                new UnaryOpLens().toXML(v, (Unary.Operator)o);
            } else if (o instanceof IntLit.Kind) {
                new EnumLens("IntLitKind", (Enum[])new IntLit.Kind[]{IntLit.INT, IntLit.LONG}).toXML(v, (Enum)o);
            } else if (o instanceof FloatLit.Kind) {
                new EnumLens("FloatLitKind", (Enum[])new FloatLit.Kind[]{FloatLit.FLOAT, FloatLit.DOUBLE}).toXML(v, (Enum)o);
            } else if (o instanceof Import.Kind) {
                new EnumLens("ImportKind", (Enum[])new Import.Kind[]{Import.CLASS, Import.PACKAGE}).toXML(v, (Enum)o);
            } else if (o instanceof Special.Kind) {
                new EnumLens("SpecialKind", (Enum[])new Special.Kind[]{Special.THIS, Special.SUPER}).toXML(v, (Enum)o);
            } else if (o instanceof Special.Kind) {
                new EnumLens("HjSpecialKind", (Enum[])new Special.Kind[]{HjSpecial.THIS, HjSpecial.SUPER, HjSpecial.SELF}).toXML(v, (Enum)o);
            } else if (o instanceof ConstructorCall.Kind) {
                new EnumLens("ConstructorCallKind", (Enum[])new ConstructorCall.Kind[]{ConstructorCall.THIS, ConstructorCall.SUPER}).toXML(v, (Enum)o);
            } else if (o instanceof Branch.Kind) {
                new EnumLens("BranchKind", (Enum[])new Branch.Kind[]{Branch.BREAK, Branch.CONTINUE}).toXML(v, (Enum)o);
            } else if (o instanceof Precedence) {
                new PrecedenceLens().toXML(v, (Precedence)o);
            } else if (o instanceof Constraint) {
                new ConstraintLens().toXML(v, (Constraint)o);
            } else if (o instanceof C_BinaryTerm) {
                new CBinaryLens().toXML(v, (C_BinaryTerm)o);
            } else if (o instanceof C_UnaryTerm) {
                new CUnaryLens().toXML(v, (C_UnaryTerm)o);
            } else if (o instanceof C_Here_c) {
                new CHereLens().toXML(v, (C_Here_c)o);
            } else if (o instanceof C_Lit) {
                new CLitLens().toXML(v, (C_Lit)o);
            } else if (o instanceof C_Special) {
                new CSpecialLens().toXML(v, (C_Special)o);
            } else if (o instanceof C_EQV) {
                new CEQVLens().toXML(v, (C_EQV)o);
            } else if (o instanceof C_Local) {
                new CLocalLens().toXML(v, (C_Local)o);
            } else if (o instanceof C_Field) {
                new CFieldLens().toXML(v, (C_Field)o);
            } else if (o instanceof C_Var) {
                new CVarLens().toXML(v, (C_Var)o);
            } else if (o instanceof C_Type) {
                new CTypeLens().toXML(v, (C_Type)o);
            } else if (o instanceof Promise) {
                new PromiseRefLens().toXML(v, (Promise)o);
            } else {
                if (o instanceof ImportTable) {
                    return;
                }
                if (o instanceof HjDel) {
                    return;
                }
                if (o instanceof HjExt) {
                    new HjExtLens().toXML(v, (HjExt)o);
                } else {
                    if (o instanceof Source) {
                        return;
                    }
                    if (o instanceof String[]) {
                        new StringArrayLens().toXML(v, (String[])o);
                    } else if (o instanceof SubtypeSet) {
                        new SubtypeSetLens().toXML(v, (SubtypeSet)o);
                    } else {
                        if (o == null) {
                            return;
                        }
                        throw new InternalCompilerError("unimplemented lens for " + o + ": " + o.getClass().getName());
                    }
                }
            }
        }
    }

    protected final class DefaultNodeLens
    extends DefaultLens {
        protected DefaultNodeLens() {
        }

        public Object fromXML(DomReader v, Element e) {
            Object o = super.fromXML(v, e);
            if (o instanceof Node) {
                return this.postprocessNode((Node)o);
            }
            return o;
        }

        protected Node postprocessNode(Node n) {
            if (n.ext() != null) {
                n.ext().init(n);
            }
            n = n instanceof Closure ? n.del(new HjDelFactory_c().delClosureImpl()) : (n instanceof Finish ? n.del(new HjDelFactory_c().delFinishImpl()) : (n instanceof ForEach ? n.del(new HjDelFactory_c().delForEachImpl()) : (n instanceof ForLoop ? n.del(new HjDelFactory_c().delForLoopImpl()) : (n instanceof Async ? n.del(new HjDelFactory_c().delAsyncImpl()) : (n instanceof AtEach ? n.del(new HjDelFactory_c().delAtEachImpl()) : (n instanceof NullableNode ? n.del(new HjDelFactory_c().delNullableNodeImpl()) : (n instanceof FutureNode ? n.del(new HjDelFactory_c().delFutureNodeImpl()) : (n instanceof CanonicalTypeNode ? n.del(new HjDelFactory_c().delCanonicalTypeNode()) : (n instanceof CanonicalTypeNode ? n.del(new HjDelFactory_c().delCanonicalTypeNode()) : (n instanceof Conditional ? n.del(new HjDelFactory_c().delConditional()) : (n instanceof FieldDecl ? n.del(new HjDelFactory_c().delFieldDecl()) : (n instanceof MethodDecl ? n.del(new HjDelFactory_c().delMethodDecl()) : (n instanceof Term ? n.del(new HjDelFactory_c().delTerm()) : (n instanceof Id ? n.del(new HjDelFactory_c().delNode()) : n.del(new HjDelFactory_c().delNode())))))))))))))));
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PackageNodeLens
    implements Lens<PackageNode> {
        @Override
        public PackageNode fromXML(DomReader v, Element e) {
            Position position = HjDom.this.get(new PositionLens(), e, "position", v);
            Package p = HjDom.this.get(new PackageLens(), e, "package", v);
            return HjDom.this.nf.PackageNode(position, p);
        }

        @Override
        public void toXML(DomGenerator v, PackageNode n) {
            HjDom.this.gen(v, "package", n.package_());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SourceFileLens
    implements Lens<SourceFile> {
        @Override
        public SourceFile fromXML(DomReader v, Element e) {
            Position position = HjDom.this.get(new PositionLens(), e, "position", v);
            PackageNode packageName = (PackageNode)HjDom.this.get(new NodeLens(), e, "package", v);
            List imports = (List)HjDom.this.get(new ListLens<Node>(new NodeLens()), e, "imports", v);
            List decls = (List)HjDom.this.get(new ListLens<Node>(new NodeLens()), e, "decls", v);
            HjMLSourceFile n = HjDom.this.nf.HjMLSourceFile(position, packageName, imports, decls);
            n = n.source(v.source());
            n = (SourceFile)n.visit((NodeVisitor)new InitImportsVisitor(HjDom.this.ts.extensionInfo().scheduler().currentJob(), (TypeSystem)HjDom.this.ts, (NodeFactory)HjDom.this.nf));
            return n;
        }

        @Override
        public void toXML(DomGenerator v, SourceFile n) {
            v = v.tag("SourceFile");
            HjDom.this.gen(v, "position", n.position());
            HjDom.this.gen(v, "package", n.package_());
            HjDom.this.gen(v, "imports", n.imports());
            HjDom.this.gen(v, "decls", n.decls());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NewArrayLens
    implements Lens<NewArray> {
        @Override
        public NewArray fromXML(DomReader v, Element e) {
            Position position = HjDom.this.get(new PositionLens(), e, "position", v);
            TypeNode base = (TypeNode)HjDom.this.get(new NodeLens(), e, "base", v);
            List dims = (List)HjDom.this.get(new ListLens<Node>(new NodeLens()), e, "dims", v);
            int addDims = HjDom.this.get(new IntLens(), e, "addDims", v);
            ArrayInit init = (ArrayInit)HjDom.this.get(new NodeLens(), e, "init", v);
            Type t = HjDom.this.get(new TypeRefLens(), e, "type", v);
            return (NewArray)HjDom.this.nf.NewArray(position, base, dims, addDims, init).type(t);
        }

        @Override
        public void toXML(DomGenerator v, NewArray n) {
            v = v.tag("NewArray");
            HjDom.this.gen(v, "position", n.position());
            HjDom.this.gen(v, "base", n.baseType());
            HjDom.this.gen(v, "dims", n.dims());
            HjDom.this.gen(v, "addDims", n.additionalDims());
            HjDom.this.gen(v, "init", n.init());
            HjDom.this.gen(v, "type", n.type());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLens
    implements Lens<Enum> {
        String tag;
        Enum[] options;

        EnumLens(String tag, Enum[] options) {
            this.tag = tag;
            this.options = options;
        }

        @Override
        public Enum fromXML(DomReader v, Element e) {
            String kindStr = new StringLens().fromXML(v, e);
            for (int i = 0; i < this.options.length; ++i) {
                if (!kindStr.equals(this.options[i].toString())) continue;
                return this.options[i];
            }
            throw new InternalCompilerError("Bad kind " + kindStr);
        }

        @Override
        public void toXML(DomGenerator v, Enum n) {
            new StringLens().toXML(v.tag(this.tag), n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeRefLens
    implements RefLens<Type> {
        @Override
        public Type fromXML(DomReader v, Element e) {
            if (e == null) {
                return null;
            }
            String tag = (e = HjDom.this.getFirstElement(e)).getTagName();
            if (tag.equals("ArrayType")) {
                Type type = HjDom.this.get(new TypeRefLens(), e, "base", v);
                return HjDom.this.ts.arrayOf(type);
            }
            if (tag.equals("FutureType")) {
                HjNamedType type = (HjNamedType)HjDom.this.get(new TypeRefLens(), e, "base", v);
                return HjDom.this.ts.createFutureType(Position.COMPILER_GENERATED, type);
            }
            if (tag.equals("NullableType")) {
                HjNamedType type = (HjNamedType)HjDom.this.get(new TypeRefLens(), e, "base", v);
                return HjDom.this.ts.createNullableType(Position.COMPILER_GENERATED, type);
            }
            if (tag.equals("ClosureType")) {
                Type returnType = HjDom.this.get(new TypeRefLens(), e, "return", v);
                List throwsTypes = (List)HjDom.this.get(new ListLens<Type>(new TypeRefLens()), e, "throws", v);
                List argTypes = (List)HjDom.this.get(new ListLens<Type>(new TypeRefLens()), e, "args", v);
                return HjDom.this.ts.closure(Position.COMPILER_GENERATED, returnType, argTypes, throwsTypes);
            }
            if (tag.equals("NullType")) {
                return HjDom.this.ts.Null();
            }
            if (tag.equals("ClassType")) {
                String name = HjDom.this.get(new StringLens(), e, "key", v);
                ClassType t = (ClassType)v.typeMap.get(name).force(HjDom.this);
                if (t != null) {
                    return t;
                }
                return null;
            }
            if (tag.equals("ExternalClassType")) {
                String name = HjDom.this.get(new StringLens(), e, "name", v);
                try {
                    Named n = HjDom.this.ts.systemResolver().find(name);
                    if (n instanceof ClassType) {
                        return (ClassType)n;
                    }
                }
                catch (SemanticException ex) {
                    // empty catch block
                }
                return null;
            }
            if (tag.equals("DependentType")) {
                HjType t = (HjType)HjDom.this.get(new TypeRefLens(), e, "root", v);
                DepParameterExpr dep = (DepParameterExpr)HjDom.this.get(new NodeLens(), e, "dep", v);
                return t.dep(dep);
            }
            if (tag.equals("PrimitiveType")) {
                String t = e.getTextContent();
                if (t.equals("void")) {
                    return HjDom.this.ts.Void();
                }
                if (t.equals("boolean")) {
                    return HjDom.this.ts.Boolean();
                }
                if (t.equals("byte")) {
                    return HjDom.this.ts.Byte();
                }
                if (t.equals("short")) {
                    return HjDom.this.ts.Short();
                }
                if (t.equals("char")) {
                    return HjDom.this.ts.Char();
                }
                if (t.equals("int")) {
                    return HjDom.this.ts.Int();
                }
                if (t.equals("long")) {
                    return HjDom.this.ts.Long();
                }
                if (t.equals("float")) {
                    return HjDom.this.ts.Float();
                }
                if (t.equals("double")) {
                    return HjDom.this.ts.Double();
                }
            }
            return null;
        }

        public void toXMLRoot(DomGenerator v, Type t) {
            if (t instanceof ArrayType) {
                v = v.tag("ArrayType");
                HjDom.this.gen(v, "base", ((ArrayType)t).base());
            } else if (t instanceof HjClassType) {
                ParsedClassType pct;
                if (t instanceof ParsedClassType && (pct = (ParsedClassType)t).job() == null) {
                    v = v.tag("ExternalClassType");
                    HjDom.this.gen(v, "name", HjDom.this.ts.getTransformedClassName((ClassType)pct));
                    return;
                }
                v = v.tag("ClassType");
                HjDom.this.addType(v, (HjClassType)t, new ClassTypeLens(null));
            } else if (t instanceof PrimitiveType) {
                v = v.tag("PrimitiveType");
                v.createText(v.parent, ((PrimitiveType)t).name());
            } else if (t instanceof FutureType) {
                v = v.tag("FutureType");
                HjDom.this.gen(v, "base", ((FutureType)t).base());
            } else if (t instanceof NullableType) {
                v = v.tag("NullableType");
                HjDom.this.gen(v, "base", ((NullableType)t).base());
            } else if (t instanceof ClosureType) {
                v = v.tag("ClosureType");
                HjDom.this.gen(v, "return", ((ClosureType)t).throwTypes());
                HjDom.this.gen(v, "throws", ((ClosureType)t).returnType());
                HjDom.this.gen(v, "args", ((ClosureType)t).argumentTypes());
            } else if (t instanceof NullType) {
                v = v.tag("NullType");
            } else assert (false);
        }

        @Override
        public void toXML(DomGenerator v, Type t) {
            v = v.tag("TypeRef");
            if (t instanceof HjType) {
                HjType xt = (HjType)t;
                if (xt.isRootType()) {
                    this.toXMLRoot(v, xt);
                } else {
                    v = v.tag("DependentType");
                    HjDom.this.gen(v, "root", xt.rootType());
                    HjDom.this.gen(v, "dep", xt.dep());
                }
            } else {
                this.toXMLRoot(v, t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CHereLens
    implements Lens<C_Here_c> {
        @Override
        public C_Here_c fromXML(DomReader v, Element e) {
            return new C_Here_c(HjDom.this.ts);
        }

        @Override
        public void toXML(DomGenerator v, C_Here_c n) {
            v = v.tag("C_Here");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CLitLens
    implements Lens<C_Lit> {
        @Override
        public C_Lit fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("C_Here")) {
                return new CHereLens().fromXML(v, e);
            }
            Object o = HjDom.this.get(new ObjectLens(), e, "value", v);
            Type t = HjDom.this.get(new TypeRefLens(), e, "type", v);
            return new C_Lit_c(o, t);
        }

        @Override
        public void toXML(DomGenerator v, C_Lit n) {
            if (n instanceof C_Here_c) {
                new CHereLens().toXML(v, (C_Here_c)n);
            }
            v = v.tag("C_Lit");
            HjDom.this.gen(v, "value", n.val());
            HjDom.this.gen(v, "type", n.type());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CTypeLens
    implements Lens<C_Type> {
        @Override
        public C_Type fromXML(DomReader v, Element e) {
            Type t = HjDom.this.get(new TypeRefLens(), e, "type", v);
            return new C_Type_c(t);
        }

        @Override
        public void toXML(DomGenerator v, C_Type n) {
            v = v.tag("C_Type");
            HjDom.this.gen(v, "type", n.type());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CTermLens
    implements Lens<C_Term> {
        @Override
        public C_Term fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("C_EQV")) {
                return new CEQVLens().fromXML(v, e);
            }
            if (tag.equals("C_Field")) {
                return new CFieldLens().fromXML(v, e);
            }
            if (tag.equals("C_Local")) {
                return new CLocalLens().fromXML(v, e);
            }
            if (tag.equals("C_Special")) {
                return new CSpecialLens().fromXML(v, e);
            }
            if (tag.equals("C_Lit")) {
                return new CLitLens().fromXML(v, e);
            }
            if (tag.equals("C_UnaryTerm")) {
                return new CUnaryLens().fromXML(v, e);
            }
            if (tag.equals("C_BinaryTerm")) {
                return new CBinaryLens().fromXML(v, e);
            }
            if (tag.equals("C_Type")) {
                return new CTypeLens().fromXML(v, e);
            }
            assert (false);
            return null;
        }

        @Override
        public void toXML(DomGenerator v, C_Term n) {
            assert (false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CBinaryLens
    implements Lens<C_BinaryTerm> {
        @Override
        public C_BinaryTerm fromXML(DomReader v, Element e) {
            String op = HjDom.this.get(new StringLens(), e, "op", v);
            C_Term left = HjDom.this.get(new CTermLens(), e, "left", v);
            C_Term right = HjDom.this.get(new CTermLens(), e, "right", v);
            Type type = HjDom.this.get(new TypeRefLens(), e, "type", v);
            return new C_BinaryTerm_c(op, left, right, type);
        }

        @Override
        public void toXML(DomGenerator v, C_BinaryTerm n) {
            v = v.tag("C_Binary");
            HjDom.this.gen(v, "op", n.op());
            HjDom.this.gen(v, "left", n.left());
            HjDom.this.gen(v, "right", n.right());
            HjDom.this.gen(v, "type", n.type());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CUnaryLens
    implements Lens<C_UnaryTerm> {
        @Override
        public C_UnaryTerm fromXML(DomReader v, Element e) {
            String op = HjDom.this.get(new StringLens(), e, "op", v);
            C_Term arg = HjDom.this.get(new CTermLens(), e, "arg", v);
            Type type = HjDom.this.get(new TypeRefLens(), e, "type", v);
            return new C_UnaryTerm_c(op, arg, type);
        }

        @Override
        public void toXML(DomGenerator v, C_UnaryTerm n) {
            v = v.tag("C_Unary");
            HjDom.this.gen(v, "op", n.op());
            HjDom.this.gen(v, "arg", n.arg());
            HjDom.this.gen(v, "type", n.type());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CEQVLens
    implements Lens<C_EQV> {
        @Override
        public C_EQV fromXML(DomReader v, Element e) {
            LocalInstance li = HjDom.this.get(new LocalInstanceRefLens(), e, "local", v);
            Boolean isSelf = HjDom.this.get(new BooleanLens(), e, "isSelf", v);
            Boolean hidden = HjDom.this.get(new BooleanLens(), e, "isEQV", v);
            return new C_EQV_c(li, (boolean)isSelf, (boolean)hidden);
        }

        @Override
        public void toXML(DomGenerator v, C_EQV n) {
            v = v.tag("C_EQV");
            HjDom.this.gen(v, "local", n.localInstance());
            HjDom.this.gen(v, "isSelf", n.isSelfVar());
            HjDom.this.gen(v, "isEQV", n.isEQV());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CSpecialLens
    implements Lens<C_Special> {
        @Override
        public C_Special fromXML(DomReader v, Element e) {
            Type type = HjDom.this.get(new TypeRefLens(), e, "type", v);
            Type qualifier = HjDom.this.get(new TypeRefLens(), e, "qualifier", v);
            Boolean isThis = HjDom.this.get(new BooleanLens(), e, "this", v);
            Boolean isSuper = HjDom.this.get(new BooleanLens(), e, "super", v);
            Boolean isSelf = HjDom.this.get(new BooleanLens(), e, "self", v);
            C_Special.C_Kind kind = isThis != false ? C_Special.THIS : (isSuper != false ? C_Special.SUPER : C_Special.SELF);
            return new C_Special_c(type, qualifier, kind);
        }

        @Override
        public void toXML(DomGenerator v, C_Special n) {
            v = v.tag("C_Special");
            HjDom.this.gen(v, "type", n.type());
            HjDom.this.gen(v, "qualifier", n.qualifier());
            HjDom.this.gen(v, "this", n.kind() == C_Special.THIS);
            HjDom.this.gen(v, "super", n.kind() == C_Special.SUPER);
            HjDom.this.gen(v, "self", n.kind() == C_Special.SELF);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CLocalLens
    implements Lens<C_Local> {
        @Override
        public C_Local fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("C_EQV")) {
                return new CEQVLens().fromXML(v, e);
            }
            LocalInstance li = HjDom.this.get(new LocalInstanceRefLens(), e, "local", v);
            Boolean isSelf = HjDom.this.get(new BooleanLens(), e, "isSelf", v);
            return new C_Local_c(li, isSelf);
        }

        @Override
        public void toXML(DomGenerator v, C_Local n) {
            v = v.tag("C_Local");
            HjDom.this.gen(v, "local", n.localInstance());
            HjDom.this.gen(v, "isSelf", n.isSelfVar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CFieldLens
    implements Lens<C_Field> {
        @Override
        public C_Field fromXML(DomReader v, Element e) {
            FieldInstance fi = HjDom.this.get(new FieldInstanceRefLens(), e, "field", v);
            C_Var receiver = HjDom.this.get(new CVarLens(), e, "receiver", v);
            return new C_Field_c(fi, receiver);
        }

        @Override
        public void toXML(DomGenerator v, C_Field n) {
            v = v.tag("C_Field");
            HjDom.this.gen(v, "field", n.fieldInstance());
            HjDom.this.gen(v, "receiver", n.receiver());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CVarLens
    implements Lens<C_Var> {
        @Override
        public C_Var fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("C_EQV")) {
                return new CEQVLens().fromXML(v, e);
            }
            if (tag.equals("C_Field")) {
                return new CFieldLens().fromXML(v, e);
            }
            if (tag.equals("C_Local")) {
                return new CLocalLens().fromXML(v, e);
            }
            if (tag.equals("C_Special")) {
                return new CSpecialLens().fromXML(v, e);
            }
            if (tag.equals("C_Lit")) {
                return new CLitLens().fromXML(v, e);
            }
            assert (false);
            return null;
        }

        @Override
        public void toXML(DomGenerator v, C_Var n) {
            assert (false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PromiseRefLens
    implements Lens<Promise> {
        @Override
        public Promise fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("C_Here")) {
                return new CHereLens().fromXML(v, e);
            }
            if (tag.equals("C_Type")) {
                return new CTypeLens().fromXML(v, e);
            }
            if (tag.equals("C_Lit")) {
                return new CLitLens().fromXML(v, e);
            }
            if (tag.equals("PromiseRef")) {
                String name = HjDom.this.get(new StringLens(), e, "key", v);
                Promise t = (Promise)v.typeMap.get(name).force(HjDom.this);
                if (t != null) {
                    return t;
                }
                return null;
            }
            assert (false);
            return null;
        }

        @Override
        public void toXML(DomGenerator v, Promise n) {
            v = v.tag("PromiseRef");
            HjDom.this.addType(v, n, new PromiseLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PromiseLens
    extends LTOLens<Promise> {
        public PromiseLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public Promise fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("Promise")) {
                C_Var var = HjDom.this.get(new CVarLens(), e, "var", v);
                Promise value = HjDom.this.get(new PromiseRefLens(), e, "value", v);
                Map fields = (Map)HjDom.this.get(new MapLens<String, Promise>(new StringLens(), new PromiseRefLens()), e, "var", v);
                Promise_c o = new Promise_c(var, value, fields);
                this.lto.o = o;
                return o;
            }
            assert (false);
            return null;
        }

        @Override
        public void toXML(DomGenerator v, Promise n) {
            v = v.tag("Promise");
            HjDom.this.gen(v, "var", n.term());
            HjDom.this.gen(v, "value", n.value());
            HjDom.this.gen(v, "fields", n.fields());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class LTOLens<T>
    implements Lens<T> {
        DomReader.LazyTypeObject lto;

        LTOLens(DomReader.LazyTypeObject lto) {
            this.lto = lto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConstraintLens
    implements Lens<Constraint> {
        @Override
        public Constraint fromXML(DomReader v, Element e) {
            Boolean consistent = HjDom.this.get(new BooleanLens(), e, "consistent", v);
            Boolean placeIsHere = HjDom.this.get(new BooleanLens(), e, "placeIsHere", v);
            Boolean placePossiblyNull = HjDom.this.get(new BooleanLens(), e, "placePossiblyNull", v);
            Boolean valid = HjDom.this.get(new BooleanLens(), e, "valid", v);
            Integer eqvCount = HjDom.this.get(new IntLens(), e, "eqvCount", v);
            C_Var selfVar = HjDom.this.get(new CVarLens(), e, "selfVar", v);
            C_Term_c placeTerm = (C_Term_c)HjDom.this.get(new CTermLens(), e, "placeTerm", v);
            Map roots = (Map)HjDom.this.get(new MapLens<C_Var, Promise>(new CVarLens(), new PromiseRefLens()), e, "roots", v);
            Constraint_c n = new Constraint_c(HjDom.this.ts, eqvCount, consistent, placeIsHere, placeTerm, placePossiblyNull, roots, valid, selfVar);
            return n;
        }

        @Override
        public void toXML(DomGenerator v, Constraint n) {
            v = v.tag("Constraint");
            HjDom.this.gen(v, "eqvCount", n.eqvCount());
            HjDom.this.gen(v, "consistent", n.consistent());
            HjDom.this.gen(v, "placeIsHere", n.placeIsHere());
            HjDom.this.gen(v, "placeTerm", n.placeTerm());
            HjDom.this.gen(v, "placePossiblyNull", n.placePossiblyNull());
            HjDom.this.gen(v, "roots", n.roots());
            HjDom.this.gen(v, "valid", n.valid());
            HjDom.this.gen(v, "selfVar", n.selfVar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PrecedenceLens
    implements Lens<Precedence> {
        @Override
        public Precedence fromXML(DomReader v, Element e) {
            Precedence p = (Precedence)new DefaultLens().fromXML(v, e);
            return (Precedence)p.intern();
        }

        @Override
        public void toXML(DomGenerator v, Precedence n) {
            new DefaultLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeObjectLens
    implements Lens<Object> {
        DomReader.LazyTypeObject lto;

        @Override
        public Object fromXML(DomReader v, Element e) {
            String tag = e.getTagName();
            if (tag.equals("MethodInstance")) {
                return new MethodInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("HjMethodInstance")) {
                return new MethodInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("FieldInstance")) {
                return new FieldInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("HjFieldInstance")) {
                return new FieldInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("ConstructorInstance")) {
                return new ConstructorInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("HjConstructorInstance")) {
                return new ConstructorInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("LocalInstance")) {
                return new LocalInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("HjLocalInstance")) {
                return new LocalInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("InitializerInstance")) {
                return new InitializerInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("ClosureInstance")) {
                return new ClosureInstanceLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("ClassType")) {
                return new ClassTypeLens(this.lto).fromXML(v, e);
            }
            if (tag.equals("Promise")) {
                return new PromiseLens(this.lto).fromXML(v, e);
            }
            throw new InternalCompilerError("No lens found for " + tag);
        }

        @Override
        public void toXML(DomGenerator v, Object n) {
            assert (false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PackageLens
    implements Lens<Package> {
        @Override
        public Package fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return HjDom.this.ts.packageForName(s);
            }
            catch (SemanticException ex) {
                throw new InternalCompilerError((Throwable)ex);
            }
        }

        @Override
        public void toXML(DomGenerator v, Package t) {
            v = v.tag("Package");
            v.createText(v.parent, t.fullName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LocalInstanceRefLens
    implements RefLens<LocalInstance> {
        @Override
        public LocalInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            LocalInstance t = (LocalInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, LocalInstance n) {
            v = v.tag("LocalInstanceRef");
            HjDom.this.addType(v, n, new LocalInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LocalInstanceLens
    extends LTOLens<LocalInstance> {
        public LocalInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public LocalInstance fromXML(DomReader v, Element e) {
            Position pos = Position.COMPILER_GENERATED;
            HjLocalInstance li = (HjLocalInstance)HjDom.this.ts.localInstance(pos, Flags.NONE, (Type)HjDom.this.ts.unknownType(pos), "-");
            this.lto.o = li;
            HjLocalInstance proto = (HjLocalInstance)new DefaultTypeObjectLens().fromXML(v, e);
            proto.setDeclaration((Declaration)proto);
            li.setFlags(proto.flags());
            li.setType(proto.type());
            li.setName(proto.name());
            if (proto.annotationsSet()) {
                li.setAnnotations(proto.annotations());
            } else {
                li.setAnnotations(Collections.EMPTY_LIST);
            }
            if (proto.constantValueSet() && proto.isConstant()) {
                li.setConstantValue(proto.constantValue());
            } else {
                li.setNotConstant();
            }
            li.setPositionInArgList(proto.positionInArgList());
            return li;
        }

        @Override
        public void toXML(DomGenerator v, LocalInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FieldInstanceLens
    extends LTOLens<FieldInstance> {
        public FieldInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public FieldInstance fromXML(DomReader v, Element e) {
            Position pos = Position.COMPILER_GENERATED;
            HjFieldInstance fi = (HjFieldInstance)HjDom.this.ts.fieldInstance(pos, (ReferenceType)HjDom.this.ts.HjObject(), Flags.NONE, (Type)HjDom.this.ts.unknownType(pos), "-");
            this.lto.o = fi;
            HjFieldInstance proto = (HjFieldInstance)new DefaultTypeObjectLens().fromXML(v, e);
            proto.setDeclaration((Declaration)proto);
            fi.setContainer(proto.container());
            fi.setFlags(proto.flags());
            fi.setType(proto.type());
            fi.setName(proto.name());
            if (proto.annotationsSet()) {
                fi.setAnnotations(proto.annotations());
            } else {
                fi.setAnnotations(Collections.EMPTY_LIST);
            }
            if (proto.depTypeSet()) {
                fi.setDepType(proto.type());
            }
            if (proto.isPropertyInitialized() && proto.isProperty()) {
                fi.setProperty();
            }
            if (proto.constantValueSet() && proto.isConstant()) {
                fi.setConstantValue(proto.constantValue());
            } else {
                fi.setNotConstant();
            }
            return fi;
        }

        @Override
        public void toXML(DomGenerator v, FieldInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FieldInstanceRefLens
    implements RefLens<FieldInstance> {
        @Override
        public FieldInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            FieldInstance t = (FieldInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, FieldInstance n) {
            v = v.tag("FieldInstanceRef");
            HjDom.this.addType(v, n, new FieldInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClosureInstanceRefLens
    implements RefLens<ClosureInstance> {
        @Override
        public ClosureInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            ClosureInstance t = (ClosureInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, ClosureInstance n) {
            v = v.tag("ClosureInstanceRef");
            HjDom.this.addType(v, n, new ClosureInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InitializerInstanceRefLens
    implements RefLens<InitializerInstance> {
        @Override
        public InitializerInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            InitializerInstance t = (InitializerInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, InitializerInstance n) {
            v = v.tag("InitializerInstanceRef");
            HjDom.this.addType(v, n, new InitializerInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInstanceRefLens
    implements RefLens<MethodInstance> {
        @Override
        public MethodInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            MethodInstance t = (MethodInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, MethodInstance n) {
            v = v.tag("MethodInstanceRef");
            HjDom.this.addType(v, n, new MethodInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConstructorInstanceRefLens
    implements RefLens<ConstructorInstance> {
        @Override
        public ConstructorInstance fromXML(DomReader v, Element e) {
            String name = HjDom.this.get(new StringLens(), e, "key", v);
            ConstructorInstance t = (ConstructorInstance)v.typeMap.get(name).force(HjDom.this);
            if (t != null) {
                return t;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, ConstructorInstance n) {
            v = v.tag("ConstructorInstanceRef");
            HjDom.this.addType(v, n, new ConstructorInstanceLens(null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInstanceLens
    extends LTOLens<MethodInstance> {
        public MethodInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public MethodInstance fromXML(DomReader v, Element e) {
            Position pos = Position.COMPILER_GENERATED;
            HjMethodInstance mi = (HjMethodInstance)HjDom.this.ts.methodInstance(pos, null, Flags.NONE, (Type)HjDom.this.ts.unknownType(pos), "-", Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.lto.o = mi;
            HjMethodInstance proto = (HjMethodInstance)new DefaultTypeObjectLens().fromXML(v, e);
            proto.setDeclaration((Declaration)proto);
            mi.setContainer(proto.container());
            mi.setFlags(proto.flags());
            mi.setReturnType(proto.returnType());
            mi.setName(proto.name());
            mi.setFormalTypes(proto.formalTypes());
            mi.setThrowTypes(proto.throwTypes());
            if (proto.annotationsSet()) {
                mi.setAnnotations(proto.annotations());
            } else {
                mi.setAnnotations(Collections.EMPTY_LIST);
            }
            return mi;
        }

        @Override
        public void toXML(DomGenerator v, MethodInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConstructorInstanceLens
    extends LTOLens<ConstructorInstance> {
        public ConstructorInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public ConstructorInstance fromXML(DomReader v, Element e) {
            Position pos = Position.COMPILER_GENERATED;
            HjConstructorInstance ci = (HjConstructorInstance)HjDom.this.ts.constructorInstance(pos, null, Flags.NONE, (HjType)HjDom.this.ts.HjObject(), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.lto.o = ci;
            HjConstructorInstance proto = (HjConstructorInstance)new DefaultTypeObjectLens().fromXML(v, e);
            proto.setDeclaration((Declaration)proto);
            ci.setContainer(proto.container());
            ci.setFlags(proto.flags());
            ci.setReturnType(proto.returnType());
            ci.setFormalTypes(proto.formalTypes());
            ci.setThrowTypes(proto.throwTypes());
            if (proto.annotationsSet()) {
                ci.setAnnotations(proto.annotations());
            } else {
                ci.setAnnotations(Collections.EMPTY_LIST);
            }
            ci.setSupClause(proto.supClause());
            return ci;
        }

        @Override
        public void toXML(DomGenerator v, ConstructorInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    protected class DefaultTypeObjectLens
    extends DefaultLens {
        protected DefaultTypeObjectLens() {
        }

        public boolean shouldFollow(Object obj, String name, Object fieldValue) {
            return !(name.equals("ts") && fieldValue instanceof TypeSystem || name.equals("decl") && fieldValue == obj);
        }

        public Object overrideField(Object obj, Field f, Object fieldValue) {
            if (f.getName().equals("decl") && f.getType().isAssignableFrom(obj.getClass()) && fieldValue == null) {
                return obj;
            }
            if (TypeSystem.class.isAssignableFrom(f.getType()) && f.getType().isAssignableFrom(HjDom.this.ts.getClass())) {
                return HjDom.this.ts;
            }
            return fieldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InitializerInstanceLens
    extends LTOLens<InitializerInstance> {
        public InitializerInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public InitializerInstance fromXML(DomReader v, Element e) {
            InitializerInstance ii = HjDom.this.ts.initializerInstance(Position.COMPILER_GENERATED, HjDom.this.ts.HjObject(), Flags.NONE);
            this.lto.o = ii;
            InitializerInstance proto = (InitializerInstance)new DefaultTypeObjectLens().fromXML(v, e);
            ii.setContainer(proto.container());
            ii.setFlags(proto.flags());
            return ii;
        }

        @Override
        public void toXML(DomGenerator v, InitializerInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClosureInstanceLens
    extends LTOLens<ClosureInstance> {
        public ClosureInstanceLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public ClosureInstance fromXML(DomReader v, Element e) {
            Position pos = Position.COMPILER_GENERATED;
            ClosureInstance ci = HjDom.this.ts.closureInstance(pos, null, null, (Type)HjDom.this.ts.unknownType(pos), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.lto.o = ci;
            ClosureInstance proto = (ClosureInstance)new DefaultTypeObjectLens().fromXML(v, e);
            proto.setDeclaration(proto);
            ci.setMethodContainer(proto.methodContainer());
            ci.setReturnType(proto.returnType());
            ci.setFormalTypes(proto.formalTypes());
            ci.setThrowTypes(proto.throwTypes());
            ((ClosureInstance_c)ci).setContainer(((ClosureInstance_c)proto).container());
            return ci;
        }

        @Override
        public void toXML(DomGenerator v, ClosureInstance n) {
            new DefaultTypeObjectLens().toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassTypeLens
    extends LTOLens<HjClassType> {
        public ClassTypeLens(DomReader.LazyTypeObject lto) {
            super(lto);
        }

        @Override
        public HjClassType fromXML(DomReader v, Element e) {
            Named n;
            Package pkg = HjDom.this.get(new PackageLens(), e, "package", v);
            ClassType.Kind kind = (ClassType.Kind)HjDom.this.get(new EnumLens("ClassTypeKind", (Enum[])new ClassType.Kind[]{ClassType.ANONYMOUS, ClassType.LOCAL, ClassType.MEMBER, ClassType.TOP_LEVEL}), e, "kind", v);
            String name = null;
            if (kind != ClassType.ANONYMOUS) {
                name = HjDom.this.get(new StringLens(), e, "name", v);
            }
            ClassType outer = null;
            if (kind != ClassType.TOP_LEVEL) {
                outer = (ClassType)HjDom.this.get(new TypeRefLens(), e, "outer", v);
            }
            String fullName = null;
            if (name != null) {
                if (kind == ClassType.TOP_LEVEL) {
                    fullName = pkg != null ? pkg.fullName() + "." + name : name;
                } else if (kind == ClassType.MEMBER && outer != null) {
                    fullName = outer.fullName() + "." + name;
                }
            }
            if (fullName != null && (n = HjDom.this.ts.systemResolver().check(fullName)) instanceof HjClassType) {
                return (HjClassType)n;
            }
            HjParsedClassType ct = (HjParsedClassType)HjDom.this.ts.createClassType(new HjMLClassInitializer(HjDom.this.ts, HjDom.this, v, e));
            this.lto.o = ct;
            ct.package_(pkg);
            ct.setJob(HjDom.this.ts.extensionInfo().scheduler().currentJob());
            ct.kind(kind);
            if (kind != ClassType.TOP_LEVEL) {
                ct.outer(outer);
            }
            if (name != null) {
                ct.name(name);
            }
            if (fullName != null) {
                try {
                    HjDom.this.ts.systemResolver().addNamed(fullName, (Named)ct);
                }
                catch (SemanticException ex2) {
                    throw new InternalCompilerError((Throwable)ex2);
                }
            }
            Flags flags = HjDom.this.get(new FlagsLens(), e, "flags", v);
            ct.setFlags(flags);
            Constraint realClause = HjDom.this.get(new ConstraintLens(), e, "realClause", v);
            ct.setRealClause(realClause);
            List annotations = (List)HjDom.this.get(new ListLens<Type>(new TypeRefLens()), e, "annotations", v);
            ct.setAnnotations(annotations);
            List classAnnotations = (List)HjDom.this.get(new ListLens<Type>(new TypeRefLens()), e, "classAnnotations", v);
            ct.setClassAnnotations(classAnnotations);
            return ct;
        }

        @Override
        public void toXML(DomGenerator v, HjClassType n) {
            v = v.tag("ClassType");
            HjDom.this.gen(v, "package", n.package_());
            HjDom.this.gen(v, "kind", n.kind());
            if (!n.isAnonymous() && n.name() != null) {
                if (!StringUtil.isNameShort((String)n.name())) {
                    HjDom.this.gen(v, "name", StringUtil.getShortNameComponent((String)n.name()));
                } else {
                    HjDom.this.gen(v, "name", n.name());
                }
            }
            if (n.isNested()) {
                HjDom.this.gen(v, "outer", n.outer());
            }
            HjDom.this.gen(v, "flags", n.flags());
            HjDom.this.gen(v, "superclass", n.superType());
            HjDom.this.gen(v, "interfaces", n.interfaces());
            HjDom.this.gen(v, "fields", n.fields());
            HjDom.this.gen(v, "methods", n.methods());
            HjDom.this.gen(v, "constructors", n.constructors());
            HjDom.this.gen(v, "memberClasses", n.memberClasses());
            if (n.annotationsSet()) {
                HjDom.this.gen(v, "annotations", n.annotations());
            }
            if (n instanceof HjParsedClassType && ((HjParsedClassType)n).classAnnotationsSet()) {
                HjDom.this.gen(v, "classAnnotations", ((HjParsedClassType)n).classAnnotations());
            }
            HjDom.this.gen(v, "realClause", n.realClause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PositionLens
    implements Lens<Position> {
        @Override
        public Position fromXML(DomReader v, Element e) {
            String path = HjDom.this.get(new StringLens(), e, "path", v);
            String file = HjDom.this.get(new StringLens(), e, "file", v);
            Integer line = HjDom.this.get(new IntLens(), e, "line", v);
            Integer column = HjDom.this.get(new IntLens(), e, "column", v);
            Integer offset = HjDom.this.get(new IntLens(), e, "offset", v);
            Integer endLine = HjDom.this.get(new IntLens(), e, "endLine", v);
            Integer endColumn = HjDom.this.get(new IntLens(), e, "endColumn", v);
            Integer endOffset = HjDom.this.get(new IntLens(), e, "endOffset", v);
            if (line == null) {
                return Position.COMPILER_GENERATED;
            }
            return new Position(path, file, line.intValue(), column.intValue(), endLine.intValue(), endColumn.intValue(), offset.intValue(), endOffset.intValue());
        }

        @Override
        public void toXML(DomGenerator v, Position n) {
            v = v.tag("Position");
            if (n == Position.COMPILER_GENERATED) {
                return;
            }
            HjDom.this.gen(v, "path", n.path());
            HjDom.this.gen(v, "file", n.file());
            HjDom.this.gen(v, "line", n.line());
            HjDom.this.gen(v, "column", n.column());
            HjDom.this.gen(v, "offset", n.offset());
            HjDom.this.gen(v, "endLine", n.endLine());
            HjDom.this.gen(v, "endColumn", n.endColumn());
            HjDom.this.gen(v, "endOffset", n.endOffset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FlagsLens
    implements Lens<Flags> {
        @Override
        public Flags fromXML(DomReader v, Element e) {
            HashSet<Flags> fs = new HashSet<Flags>();
            fs.add(Flags.PUBLIC);
            fs.add(Flags.PRIVATE);
            fs.add(Flags.PROTECTED);
            fs.add(Flags.ABSTRACT);
            fs.add(Flags.FINAL);
            fs.add(Flags.INTERFACE);
            fs.add(Flags.NATIVE);
            fs.add(Flags.STATIC);
            fs.add(Flags.STRICTFP);
            fs.add(Flags.SYNCHRONIZED);
            fs.add(Flags.TRANSIENT);
            fs.add(Flags.VOLATILE);
            fs.add(HjFlags.VALUE);
            fs.add(HjFlags.REFERENCE);
            fs.add(HjFlags.ATOMIC);
            fs.add(HjFlags.PURE);
            fs.add(HjFlags.MUTABLE);
            fs.add(HjFlags.SAFE);
            fs.add(HjFlags.LOCAL);
            fs.add(HjFlags.NON_BLOCKING);
            fs.add(HjFlags.SEQUENTIAL);
            Flags f = Flags.NONE;
            List l = (List)HjDom.this.get(new ListLens<Object>(new ObjectLens()), e, "list", v);
            block0: for (int i = 0; i < l.size(); ++i) {
                String s = (String)l.get(i);
                for (Flags fj : fs) {
                    if (!fj.flags().contains(s)) continue;
                    if (fj instanceof HjFlags) {
                        f = ((HjFlags)fj).setX(f);
                        continue block0;
                    }
                    if (f instanceof HjFlags) {
                        f = ((HjFlags)f).setX(fj);
                        continue block0;
                    }
                    f = f.set(fj);
                    continue block0;
                }
            }
            return f;
        }

        @Override
        public void toXML(DomGenerator v, Flags n) {
            v = v.tag("Flags");
            ArrayList names = new ArrayList(n.flags());
            HjDom.this.gen(v, "list", names);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DoubleLens
    implements Lens<Double> {
        @Override
        public Double fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad long " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Double n) {
            v = v.tag("Double");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FloatLens
    implements Lens<Float> {
        @Override
        public Float fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad long " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Float n) {
            v = v.tag("Float");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LongLens
    implements Lens<Long> {
        @Override
        public Long fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad long " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Long n) {
            v = v.tag("Long");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IntLens
    implements Lens<Integer> {
        @Override
        public Integer fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad int " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Integer n) {
            v = v.tag("Int");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ShortLens
    implements Lens<Short> {
        @Override
        public Short fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return (short)Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad int " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Short n) {
            v = v.tag("Short");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ByteLens
    implements Lens<Byte> {
        @Override
        public Byte fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            try {
                return (byte)Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new InternalCompilerError("Bad int " + s);
            }
        }

        @Override
        public void toXML(DomGenerator v, Byte n) {
            v = v.tag("Byte");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CharLens
    implements Lens<Character> {
        @Override
        public Character fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (s.length() == 0) {
                return null;
            }
            return Character.valueOf(s.charAt(0));
        }

        @Override
        public void toXML(DomGenerator v, Character n) {
            v = v.tag("Char");
            v.createText(v.parent, n.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BooleanLens
    implements Lens<Boolean> {
        @Override
        public Boolean fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (s.equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public void toXML(DomGenerator v, Boolean s) {
            v = v.tag("Boolean");
            v.createText(v.parent, s.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringLens
    implements Lens<String> {
        boolean trim;

        StringLens() {
            this(true);
        }

        StringLens(boolean trim) {
            this.trim = trim;
        }

        @Override
        public String fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (this.trim) {
                s = s.trim();
            }
            return s;
        }

        @Override
        public void toXML(DomGenerator v, String s) {
            v = v.tag("String");
            v.createText(v.parent, s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnaryOpLens
    implements Lens<Unary.Operator> {
        @Override
        public Unary.Operator fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (s.equals("neg")) {
                return Unary.NEG;
            }
            if (s.equals("not")) {
                return Unary.NOT;
            }
            if (s.equals("comp")) {
                return Unary.BIT_NOT;
            }
            if (s.equals("preinc")) {
                return Unary.PRE_INC;
            }
            if (s.equals("predec")) {
                return Unary.PRE_DEC;
            }
            if (s.equals("postinc")) {
                return Unary.POST_INC;
            }
            if (s.equals("postdec")) {
                return Unary.POST_DEC;
            }
            throw new InternalCompilerError("Bad unary operator " + s);
        }

        @Override
        public void toXML(DomGenerator v, Unary.Operator n) {
            v = v.tag("UnaryOp");
            String tag = null;
            if (n == Unary.NEG) {
                tag = "neg";
            }
            if (n == Unary.NOT) {
                tag = "not";
            }
            if (n == Unary.BIT_NOT) {
                tag = "comp";
            }
            if (n == Unary.PRE_INC) {
                tag = "preinc";
            }
            if (n == Unary.PRE_DEC) {
                tag = "predec";
            }
            if (n == Unary.POST_INC) {
                tag = "postinc";
            }
            if (n == Unary.POST_DEC) {
                tag = "postdec";
            }
            if (tag == null) {
                throw new InternalCompilerError("Bad unary operator " + n);
            }
            v.createText(v.parent, tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BinaryOpLens
    implements Lens<Binary.Operator> {
        @Override
        public Binary.Operator fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (s.equals("add")) {
                return Binary.ADD;
            }
            if (s.equals("sub")) {
                return Binary.SUB;
            }
            if (s.equals("mul")) {
                return Binary.MUL;
            }
            if (s.equals("div")) {
                return Binary.DIV;
            }
            if (s.equals("mod")) {
                return Binary.MOD;
            }
            if (s.equals("cor")) {
                return Binary.COND_OR;
            }
            if (s.equals("cand")) {
                return Binary.COND_AND;
            }
            if (s.equals("bor")) {
                return Binary.BIT_OR;
            }
            if (s.equals("bxor")) {
                return Binary.BIT_XOR;
            }
            if (s.equals("band")) {
                return Binary.BIT_AND;
            }
            if (s.equals("shl")) {
                return Binary.SHL;
            }
            if (s.equals("shr")) {
                return Binary.SHR;
            }
            if (s.equals("ushr")) {
                return Binary.USHR;
            }
            if (s.equals("eq")) {
                return Binary.EQ;
            }
            if (s.equals("ne")) {
                return Binary.NE;
            }
            if (s.equals("gt")) {
                return Binary.GT;
            }
            if (s.equals("ge")) {
                return Binary.GE;
            }
            if (s.equals("lt")) {
                return Binary.LT;
            }
            if (s.equals("le")) {
                return Binary.LE;
            }
            throw new InternalCompilerError("Bad binary operator " + s);
        }

        @Override
        public void toXML(DomGenerator v, Binary.Operator n) {
            v = v.tag("BinaryOp");
            String tag = null;
            if (n == Binary.ADD) {
                tag = "add";
            }
            if (n == Binary.SUB) {
                tag = "sub";
            }
            if (n == Binary.MUL) {
                tag = "mul";
            }
            if (n == Binary.DIV) {
                tag = "div";
            }
            if (n == Binary.MOD) {
                tag = "mod";
            }
            if (n == Binary.EQ) {
                tag = "eq";
            }
            if (n == Binary.NE) {
                tag = "ne";
            }
            if (n == Binary.LT) {
                tag = "lt";
            }
            if (n == Binary.LE) {
                tag = "le";
            }
            if (n == Binary.GT) {
                tag = "gt";
            }
            if (n == Binary.GE) {
                tag = "ge";
            }
            if (n == Binary.BIT_OR) {
                tag = "bor";
            }
            if (n == Binary.BIT_XOR) {
                tag = "bxor";
            }
            if (n == Binary.BIT_AND) {
                tag = "band";
            }
            if (n == Binary.SHL) {
                tag = "shl";
            }
            if (n == Binary.SHR) {
                tag = "shr";
            }
            if (n == Binary.USHR) {
                tag = "ushr";
            }
            if (n == Binary.COND_OR) {
                tag = "cor";
            }
            if (n == Binary.COND_AND) {
                tag = "cand";
            }
            if (tag == null) {
                throw new InternalCompilerError("Bad binary operator " + n);
            }
            v.createText(v.parent, tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AssignOpLens
    implements Lens<Assign.Operator> {
        @Override
        public Assign.Operator fromXML(DomReader v, Element e) {
            String s = e.getTextContent();
            if (s.equals("assign")) {
                return Assign.ASSIGN;
            }
            if (s.equals("add")) {
                return Assign.ADD_ASSIGN;
            }
            if (s.equals("sub")) {
                return Assign.SUB_ASSIGN;
            }
            if (s.equals("mul")) {
                return Assign.MUL_ASSIGN;
            }
            if (s.equals("div")) {
                return Assign.DIV_ASSIGN;
            }
            if (s.equals("mod")) {
                return Assign.MOD_ASSIGN;
            }
            if (s.equals("bor")) {
                return Assign.BIT_OR_ASSIGN;
            }
            if (s.equals("bxor")) {
                return Assign.BIT_XOR_ASSIGN;
            }
            if (s.equals("band")) {
                return Assign.BIT_AND_ASSIGN;
            }
            if (s.equals("shl")) {
                return Assign.SHL_ASSIGN;
            }
            if (s.equals("shr")) {
                return Assign.SHR_ASSIGN;
            }
            if (s.equals("ushr")) {
                return Assign.USHR_ASSIGN;
            }
            throw new InternalCompilerError("Bad assign operator " + s);
        }

        @Override
        public void toXML(DomGenerator v, Assign.Operator n) {
            v = v.tag("AssignOp");
            String tag = null;
            if (n == Assign.ASSIGN) {
                tag = "assign";
            }
            if (n == Assign.ADD_ASSIGN) {
                tag = "add";
            }
            if (n == Assign.SUB_ASSIGN) {
                tag = "sub";
            }
            if (n == Assign.MUL_ASSIGN) {
                tag = "mul";
            }
            if (n == Assign.DIV_ASSIGN) {
                tag = "div";
            }
            if (n == Assign.MOD_ASSIGN) {
                tag = "mod";
            }
            if (n == Assign.BIT_OR_ASSIGN) {
                tag = "bor";
            }
            if (n == Assign.BIT_XOR_ASSIGN) {
                tag = "bxor";
            }
            if (n == Assign.BIT_AND_ASSIGN) {
                tag = "band";
            }
            if (n == Assign.SHL_ASSIGN) {
                tag = "shl";
            }
            if (n == Assign.SHR_ASSIGN) {
                tag = "shr";
            }
            if (n == Assign.USHR_ASSIGN) {
                tag = "ushr";
            }
            if (tag == null) {
                throw new InternalCompilerError("Bad assign operator " + n);
            }
            v.createText(v.parent, tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HjExtLens
    implements Lens<HjExt> {
        @Override
        public HjExt fromXML(DomReader v, Element e) {
            return (HjExt)new DefaultLens().fromXML(v, e);
        }

        @Override
        public void toXML(DomGenerator v, HjExt n) {
            new DefaultLens(){

                public boolean shouldFollow(Object obj, String field, Object fieldValue) {
                    return !field.equals("node") || !(fieldValue instanceof Node);
                }
            }.toXML(v, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapLens<K, V>
    implements Lens<Map<K, V>> {
        Lens<K> klens;
        Lens<V> vlens;

        MapLens(Lens<K> klens, Lens<V> vlens) {
            this.klens = klens;
            this.vlens = vlens;
        }

        @Override
        public Map<K, V> fromXML(DomReader v, Element e) {
            if (e == null) {
                return Collections.emptyMap();
            }
            HashMap r = new HashMap();
            for (org.w3c.dom.Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                Object x = new EntryLens<K, V>(this.klens, this.vlens).fromXML(v, (Element)child);
                r.put(((Entry)x).k, ((Entry)x).v);
            }
            return r;
        }

        @Override
        public void toXML(DomGenerator v, Map<K, V> l) {
            for (Map.Entry<K, V> e : l.entrySet()) {
                DomGenerator vi = v.tag("entry");
                new EntryLens<K, V>(this.klens, this.vlens).toXML(vi, new Entry<K, V>(e.getKey(), e.getValue()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryLens<K, V>
    implements Lens<Entry<K, V>> {
        Lens<K> klens;
        Lens<V> vlens;

        EntryLens(Lens<K> klens, Lens<V> vlens) {
            this.klens = klens;
            this.vlens = vlens;
        }

        @Override
        public Entry<K, V> fromXML(DomReader r, Element e) {
            K k = HjDom.this.get(this.klens, e, "key", r);
            V v = HjDom.this.get(this.vlens, e, "value", r);
            return new Entry<K, V>(k, v);
        }

        @Override
        public void toXML(DomGenerator v, Entry<K, V> e) {
            v = v.tag("Entry");
            this.klens.toXML(v.tag("key"), e.k);
            this.vlens.toXML(v.tag("value"), e.v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<K, V> {
        K k;
        V v;

        Entry(K k, V v) {
            this.k = k;
            this.v = v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubtypeSetLens
    implements Lens<SubtypeSet> {
        @Override
        public SubtypeSet fromXML(DomReader v, Element e) {
            List l = (List)HjDom.this.get(new ListLens<Object>(new ObjectLens()), e, "list", v);
            SubtypeSet s = new SubtypeSet((TypeSystem)HjDom.this.ts);
            s.addAll((Collection)l);
            return s;
        }

        @Override
        public void toXML(DomGenerator v, SubtypeSet a) {
            v = v.tag("SubtypeSet");
            HjDom.this.gen(v, "list", new ArrayList(a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringArrayLens
    implements Lens<String[]> {
        @Override
        public String[] fromXML(DomReader v, Element e) {
            List l = (List)HjDom.this.get(new ListLens<Object>(new ObjectLens()), e, "list", v);
            return new ArrayList(l).toArray(new String[0]);
        }

        @Override
        public void toXML(DomGenerator v, String[] a) {
            v = v.tag("StringArray");
            HjDom.this.gen(v, "list", Arrays.asList(a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListLens<T>
    implements Lens<List<T>> {
        Lens<T> lens;

        ListLens(Lens<T> lens) {
            this.lens = lens;
        }

        @Override
        public List<T> fromXML(DomReader v, Element e) {
            if (e == null) {
                return Collections.emptyList();
            }
            ArrayList<T> r = new ArrayList<T>();
            for (org.w3c.dom.Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                assert (((Element)child).getTagName().equals("item"));
                Element x = HjDom.this.getFirstElement((Element)child);
                T o = this.lens.fromXML(v, x);
                r.add(o);
            }
            return r;
        }

        @Override
        public void toXML(DomGenerator v, List<T> l) {
            v = v.tag("List");
            for (T o : l) {
                this.lens.toXML(v.tag("item"), o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RefLens<T>
    extends Lens<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Lens<T> {
        public T fromXML(DomReader var1, Element var2);

        public void toXML(DomGenerator var1, T var2);
    }
}

