/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.util.List;
import org.w3c.dom.Element;
import polyglot.ext.hj.dom.DomReader;
import polyglot.ext.hj.dom.HjDom;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.Type;

public class HjMLClassInitializer
implements LazyClassInitializer {
    HjTypeSystem ts;
    HjParsedClassType ct;
    HjDom dom;
    DomReader v;
    Element e;
    protected boolean init;
    protected boolean constructorsInitialized;
    protected boolean fieldsInitialized;
    protected boolean interfacesInitialized;
    protected boolean memberClassesInitialized;
    protected boolean methodsInitialized;
    protected boolean superclassInitialized;

    public HjMLClassInitializer(HjTypeSystem ts, HjDom dom, DomReader v, Element e) {
        this.ts = ts;
        this.dom = dom;
        this.v = v;
        this.e = e;
    }

    public void setClass(ParsedClassType ct) {
        this.ct = (HjParsedClassType)ct;
    }

    public boolean fromClassFile() {
        return false;
    }

    public void initTypeObject() {
        if (this.ct.isMember() && this.ct.outer() instanceof ParsedClassType) {
            ParsedClassType outer = (ParsedClassType)this.ct.outer();
            outer.addMemberClass((ClassType)this.ct);
        }
        for (ParsedClassType ct : this.ct.memberClasses()) {
            ct.initializer().initTypeObject();
        }
        this.init = true;
    }

    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    public void initSuperclass() {
        if (this.superclassInitialized) {
            return;
        }
        Type superclass = this.dom.get(this.dom.new HjDom.TypeRefLens(), this.e, "superclass", this.v);
        this.ct.superType(superclass);
        this.superclassInitialized = true;
        if (this.superclassInitialized && this.interfacesInitialized) {
            this.ct.setSupertypesResolved(true);
        }
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    public void initInterfaces() {
        if (this.interfacesInitialized) {
            return;
        }
        HjDom hjDom = this.dom;
        hjDom.getClass();
        List interfaces = (List)this.dom.get(hjDom.new HjDom.ListLens<Type>(this.dom.new HjDom.TypeRefLens()), this.e, "interfaces", this.v);
        this.ct.setInterfaces(interfaces);
        this.interfacesInitialized = true;
        if (this.superclassInitialized && this.interfacesInitialized) {
            this.ct.setSupertypesResolved(true);
        }
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    public void initMemberClasses() {
        if (this.memberClassesInitialized) {
            return;
        }
        HjDom hjDom = this.dom;
        hjDom.getClass();
        List memberClasses = (List)this.dom.get(hjDom.new HjDom.ListLens<Type>(this.dom.new HjDom.TypeRefLens()), this.e, "memberClasses", this.v);
        this.ct.setMemberClasses(memberClasses);
        this.memberClassesInitialized = true;
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    public void canonicalFields() {
        this.initFields();
    }

    public void canonicalMethods() {
        this.initMethods();
    }

    public void canonicalConstructors() {
        this.initConstructors();
    }

    public void initFields() {
        if (this.fieldsInitialized) {
            return;
        }
        HjDom hjDom = this.dom;
        hjDom.getClass();
        List fields = (List)this.dom.get(hjDom.new HjDom.ListLens<FieldInstance>(this.dom.new HjDom.FieldInstanceRefLens()), this.e, "fields", this.v);
        this.ct.setFields(fields);
        this.fieldsInitialized = true;
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    public void initMethods() {
        if (this.methodsInitialized) {
            return;
        }
        HjDom hjDom = this.dom;
        hjDom.getClass();
        List methods = (List)this.dom.get(hjDom.new HjDom.ListLens<MethodInstance>(this.dom.new HjDom.MethodInstanceRefLens()), this.e, "methods", this.v);
        this.ct.setMethods(methods);
        this.methodsInitialized = true;
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    public void initConstructors() {
        if (this.constructorsInitialized) {
            return;
        }
        HjDom hjDom = this.dom;
        hjDom.getClass();
        List constructors = (List)this.dom.get(hjDom.new HjDom.ListLens<ConstructorInstance>(this.dom.new HjDom.ConstructorInstanceRefLens()), this.e, "constructors", this.v);
        this.ct.setConstructors(constructors);
        this.constructorsInitialized = true;
        if (this.initialized()) {
            this.v = null;
            this.e = null;
            this.dom = null;
        }
    }

    protected boolean initialized() {
        return this.superclassInitialized && this.interfacesInitialized && this.memberClassesInitialized && this.methodsInitialized && this.fieldsInitialized && this.constructorsInitialized;
    }
}

