/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import polyglot.util.InternalCompilerError;

public class XMLReader {
    protected Document doc;
    protected DocumentBuilder builder;

    public XMLReader() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }

    public XMLReader(Reader reader) throws IOException {
        this();
        try {
            this.doc = this.builder.parse(new ReaderInputStream(reader));
        }
        catch (SAXException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }

    public XMLReader(String name) throws IOException {
        this();
        try {
            this.doc = this.builder.parse(name);
        }
        catch (SAXException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }

    public Element readElement() throws IOException {
        return this.doc.getDocumentElement();
    }

    public void close() throws IOException {
    }

    protected static class ReaderInputStream
    extends InputStream {
        private Reader r;

        public ReaderInputStream(Reader r) {
            this.r = r;
        }

        public int read() throws IOException {
            return this.r.read();
        }
    }
}

