/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import polyglot.util.InternalCompilerError;

public class XMLWriter {
    FileOutputStream w;

    public XMLWriter(String name) throws IOException {
        File f = new File(name);
        File dir = f.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.w = new FileOutputStream(f);
    }

    public void writeElement(Element n) throws IOException {
        DOMSource source = new DOMSource(n);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer format = transFactory.newTransformer();
            format.setOutputProperty("omit-xml-declaration", "yes");
            format.setOutputProperty("encoding", "UTF-8");
            format.setOutputProperty("indent", "yes");
            format.transform(source, new StreamResult(this.w));
        }
        catch (TransformerException e) {
            throw new InternalCompilerError("Error in serializing data to stream");
        }
    }

    public void close() throws IOException {
        this.w.close();
    }
}

