/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.StringLit;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.plugin.LoadPlugins;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.types.SemanticException;
import polyglot.visit.NodeVisitor;

public class LoadJobPlugins
extends VisitorGoal {
    public LoadJobPlugins(Job job) {
        super(job, (NodeVisitor)new LoadJobPluginsVisitor(job));
    }

    public static Goal create(ExtensionInfo.HjScheduler scheduler, Job job) {
        return scheduler.internGoal((Goal)new LoadJobPlugins(job));
    }

    public Collection prerequisiteGoals(Scheduler scheduler) {
        ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)scheduler;
        ArrayList<Goal> l = new ArrayList<Goal>();
        l.add(hjSched.LoadPlugins());
        l.add(hjSched.PropagateAnnotations(this.job));
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    public static class LoadJobPluginsVisitor
    extends NodeVisitor {
        Job job;

        LoadJobPluginsVisitor(Job job) {
            this.job = job;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            if (n instanceof ClassDecl) {
                ClassDecl cd = (ClassDecl)n;
                HjParsedClassType ct = (HjParsedClassType)cd.type();
                try {
                    HjClassType baseClass = (HjClassType)ct.typeSystem().systemResolver().find("hj.lang.annotation.PluginClass");
                    List pluginClasses = ct.annotationMatching(baseClass);
                    for (HjClassType pluginClass : pluginClasses) {
                        DepParameterExpr dep = pluginClass.dep();
                        Expr e = (Expr)dep.args().get(0);
                        if (!(e instanceof StringLit)) continue;
                        StringLit s = (StringLit)e;
                        LoadPlugins.loadPlugin((ExtensionInfo)this.job.extensionInfo(), s.value());
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return super.leave(old, n, v);
        }
    }
}

