/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Unary;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.HjCast;
import polyglot.ext.hj.ast.HjInstanceof;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.ParExpr;
import polyglot.ext.hj.plugin.CompilerPlugin;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjMethodInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.goals.VisitorGoal;
import polyglot.types.ArrayType;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleTypeAnnotationPlugin
implements CompilerPlugin {
    public SimpleTypeAnnotationPlugin() {
        System.out.println("Registering " + this.getClass().getName());
    }

    public Expr checkField(Field f, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjFieldInstance fi = (HjFieldInstance)f.fieldInstance();
        List memberAnnotations = ((HjFieldInstance)fi.orig()).annotations();
        HjType type = (HjType)fi.orig().type();
        List typeAnnotations = type.annotations();
        return this.propagate((Expr)f, type, memberAnnotations, typeAnnotations);
    }

    public Expr checkLocal(Local l, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjLocalInstance li = (HjLocalInstance)l.localInstance();
        List memberAnnotations = ((HjLocalInstance)li.orig()).annotations();
        HjType type = (HjType)li.orig().type();
        List typeAnnotations = type.annotations();
        return this.propagate((Expr)l, type, memberAnnotations, typeAnnotations);
    }

    public Expr checkCall(Call c, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjMethodInstance mi = (HjMethodInstance)c.methodInstance();
        List memberAnnotations = ((HjMethodInstance)mi.orig()).annotations();
        HjType type = (HjType)mi.orig().returnType();
        List typeAnnotations = type.annotations();
        return this.propagate((Expr)c, type, memberAnnotations, typeAnnotations);
    }

    public Expr checkNew(New n, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjConstructorInstance ci = (HjConstructorInstance)n.constructorInstance();
        List memberAnnotations = ((HjConstructorInstance)ci.orig()).annotations();
        HjType type = (HjType)ci.orig().container();
        List typeAnnotations = type.annotations();
        return this.propagate((Expr)n, type, memberAnnotations, typeAnnotations);
    }

    public Expr propagate(Expr e, HjType declType, List<HjClassType> memberAnnotations, List<HjClassType> typeAnnotations) {
        HjType t = (HjType)e.type();
        t = (HjType)t.annotations(typeAnnotations);
        return e.type((Type)t);
    }

    public HjType binaryPromote(Binary b, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return (HjType)b.type();
    }

    public HjType unaryPromote(Unary u, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return (HjType)u.type();
    }

    public Expr checkCast(HjType castType, Expr e, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjType etype = (HjType)e.type();
        if (ts.isCastValid(etype, castType) && this.checkCastCoercion(castType, etype, context, ts, nf)) {
            return e;
        }
        throw new SemanticException("Cannot cast " + e + "(" + etype + ") to " + castType + ".", e.position());
    }

    public boolean checkCastCoercion(HjType toType, HjType fromType, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return true;
    }

    public Expr checkImplicitCoercion(HjType toType, Expr e, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        HjType etype = (HjType)e.type();
        if (ts.isImplicitCastValid(etype, toType) && this.checkImplicitCoercion(toType, etype, context, ts, nf)) {
            return e;
        }
        if (e.isConstant() && ts.numericConversionValid(toType, e.constantValue()) && this.checkNumericCoercion(toType, e, context, ts, nf)) {
            return e;
        }
        throw new SemanticException("Cannot coerce " + e + " (" + etype + ") to " + toType + ".", e.position());
    }

    public boolean checkNumericCoercion(HjType toType, Expr e, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return true;
    }

    public boolean checkImplicitCoercion(HjType toType, HjType fromType, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return true;
    }

    protected Expr rewriteCast(HjCast n, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return n;
    }

    protected Expr rewriteInstanceof(HjInstanceof e, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return e;
    }

    protected CheckVisitor checkVisitor(ExtensionInfo extInfo, Job job) {
        return new CheckVisitor(job, extInfo.typeSystem(), extInfo.nodeFactory());
    }

    protected CastRewriteVisitor castRewriteVisitor(ExtensionInfo extInfo, Job job) {
        return new CastRewriteVisitor(job, extInfo.typeSystem(), extInfo.nodeFactory());
    }

    @Override
    public Goal register(ExtensionInfo extInfo, Job job) {
        Goal check = CheckerGoal.create(extInfo.scheduler(), job, (NodeVisitor)this.checkVisitor(extInfo, job));
        Goal cast = CasterGoal.create(extInfo.scheduler(), job, (NodeVisitor)this.castRewriteVisitor(extInfo, job), check);
        ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)extInfo.scheduler();
        hjSched.addDependencyAndEnqueue(hjSched.HjBoxed(job), cast, true);
        return cast;
    }

    protected Expr annotationCast(Expr e, HjContext context, HjTypeSystem ts, HjNodeFactory nf) throws SemanticException {
        return e;
    }

    public class CastRewriteVisitor
    extends ContextVisitor {
        public CastRewriteVisitor(Job job, TypeSystem ts, NodeFactory nf) {
            super(job, ts, nf);
        }

        public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
            if (n instanceof HjCast) {
                return SimpleTypeAnnotationPlugin.this.rewriteCast((HjCast)n, (HjContext)this.context, (HjTypeSystem)this.ts, (HjNodeFactory)this.nf);
            }
            if (n instanceof HjInstanceof) {
                return SimpleTypeAnnotationPlugin.this.rewriteInstanceof((HjInstanceof)n, (HjContext)this.context, (HjTypeSystem)this.ts, (HjNodeFactory)this.nf);
            }
            return n;
        }

        public SimpleTypeAnnotationPlugin plugin() {
            return SimpleTypeAnnotationPlugin.this;
        }

        public int hashCode() {
            return super.hashCode() + this.plugin().hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o) && this.plugin() == ((CheckVisitor)((Object)o)).plugin();
        }
    }

    public class CheckVisitor
    extends ContextVisitor {
        public CheckVisitor(Job job, TypeSystem ts, NodeFactory nf) {
            super(job, ts, nf);
        }

        public NodeVisitor begin() {
            return super.begin();
        }

        public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
            Unary b;
            Object c;
            HjContext context = (HjContext)this.context;
            HjTypeSystem ts = (HjTypeSystem)this.ts;
            HjNodeFactory nf = (HjNodeFactory)this.nf;
            if (n instanceof LocalDecl) {
                LocalDecl ld = (LocalDecl)n;
                HjType type = (HjType)ld.type().type();
                if (ld.init() != null) {
                    Expr newInit = SimpleTypeAnnotationPlugin.this.checkImplicitCoercion(type, ld.init(), context, ts, nf);
                    return ld.init(newInit);
                }
                if (ld.init() instanceof ArrayInit && type instanceof ArrayType) {
                    ArrayInit init = (ArrayInit)ld.init();
                    ArrayList<Expr> newElements = new ArrayList<Expr>(init.elements().size());
                    for (Expr e : init.elements()) {
                        Expr newE = SimpleTypeAnnotationPlugin.this.checkImplicitCoercion((HjType)((ArrayType)type).base(), e, context, ts, nf);
                        newElements.add(newE);
                    }
                    return ld.init((Expr)init.elements(newElements));
                }
            }
            if (n instanceof Assign) {
                Assign a = (Assign)n;
                Expr newRight = SimpleTypeAnnotationPlugin.this.checkImplicitCoercion((HjType)a.left().type(), a.right(), context, ts, nf);
                return SimpleTypeAnnotationPlugin.this.annotationCast((Expr)a.right(newRight), context, ts, nf);
            }
            if (n instanceof ProcedureCall) {
                c = (ProcedureCall)n;
                ArrayList<Expr> newActuals = new ArrayList<Expr>(c.arguments().size());
                ProcedureInstance pi = c.procedureInstance();
                for (int i = 0; i < c.arguments().size(); ++i) {
                    Expr e = (Expr)c.arguments().get(i);
                    Type t = (Type)pi.formalTypes().get(i);
                    Expr newE = SimpleTypeAnnotationPlugin.this.checkImplicitCoercion((HjType)t, e, context, ts, nf);
                    newActuals.add(newE);
                }
                if ((c = c.arguments(newActuals)) instanceof Call) {
                    return SimpleTypeAnnotationPlugin.this.annotationCast(SimpleTypeAnnotationPlugin.this.checkCall((Call)c, context, ts, nf), context, ts, nf);
                }
                if (c instanceof New) {
                    return SimpleTypeAnnotationPlugin.this.annotationCast(SimpleTypeAnnotationPlugin.this.checkNew((New)c, context, ts, nf), context, ts, nf);
                }
                if (c instanceof Expr) {
                    return SimpleTypeAnnotationPlugin.this.annotationCast((Expr)c, context, ts, nf);
                }
                return c;
            }
            if (n instanceof ParExpr) {
                ParExpr p = (ParExpr)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(p.type(p.expr().type()), context, ts, nf);
            }
            if (n instanceof Field) {
                Field f = (Field)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(SimpleTypeAnnotationPlugin.this.checkField(f, context, ts, nf), context, ts, nf);
            }
            if (n instanceof Local) {
                Local l = (Local)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(SimpleTypeAnnotationPlugin.this.checkLocal(l, context, ts, nf), context, ts, nf);
            }
            if (n instanceof HjCast) {
                c = (HjCast)n;
                Expr e = SimpleTypeAnnotationPlugin.this.checkCast((HjType)c.castType().type(), c.expr(), context, ts, nf);
                return SimpleTypeAnnotationPlugin.this.annotationCast((Expr)c.expr(e), context, ts, nf);
            }
            if (n instanceof Unary) {
                b = (Unary)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(b.type((Type)SimpleTypeAnnotationPlugin.this.unaryPromote(b, ts, nf)), context, ts, nf);
            }
            if (n instanceof Binary) {
                b = (Binary)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(b.type((Type)SimpleTypeAnnotationPlugin.this.binaryPromote((Binary)b, ts, nf)), context, ts, nf);
            }
            if (n instanceof Expr) {
                Expr e = (Expr)n;
                return SimpleTypeAnnotationPlugin.this.annotationCast(e, context, ts, nf);
            }
            return n;
        }

        public SimpleTypeAnnotationPlugin plugin() {
            return SimpleTypeAnnotationPlugin.this;
        }

        public int hashCode() {
            return super.hashCode() + this.plugin().hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o) && this.plugin() == ((CheckVisitor)((Object)o)).plugin();
        }
    }

    public static class CasterGoal
    extends VisitorGoal {
        Goal checkGoal;

        public static Goal create(Scheduler scheduler, Job job, NodeVisitor v, Goal checkGoal) {
            return scheduler.internGoal((Goal)new CasterGoal(job, v, checkGoal));
        }

        private CasterGoal(Job job, NodeVisitor v, Goal checkGoal) {
            super(job, v);
            this.checkGoal = checkGoal;
        }

        public Collection prerequisiteGoals(Scheduler scheduler) {
            ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)scheduler;
            ArrayList<Goal> l = new ArrayList<Goal>();
            l.add(this.checkGoal);
            l.addAll(super.prerequisiteGoals(scheduler));
            return l;
        }

        public int hashCode() {
            return super.hashCode() + this.v.hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o) && this.v.equals(((VisitorGoal)o).visitor());
        }
    }

    public static class CheckerGoal
    extends VisitorGoal {
        Goal precheckGoal;

        public static Goal create(Scheduler scheduler, Job job, NodeVisitor v) {
            return scheduler.internGoal((Goal)new CheckerGoal(job, v));
        }

        private CheckerGoal(Job job, NodeVisitor v) {
            super(job, v);
        }

        public Collection prerequisiteGoals(Scheduler scheduler) {
            ExtensionInfo.HjScheduler hjSched = (ExtensionInfo.HjScheduler)scheduler;
            ArrayList<Goal> l = new ArrayList<Goal>();
            l.add(hjSched.TypeChecked(this.job));
            l.add(hjSched.ConstantsChecked(this.job));
            l.add(hjSched.PropagateAnnotations(this.job));
            l.addAll(super.prerequisiteGoals(scheduler));
            return l;
        }

        public int hashCode() {
            return super.hashCode() + this.v.hashCode();
        }

        public boolean equals(Object o) {
            return super.equals(o) && this.v.equals(((VisitorGoal)o).visitor());
        }
    }
}

