/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.query;

import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjArrayAccess1Assign;
import polyglot.ext.hj.ast.HjArrayAccess1Unary;
import polyglot.ext.hj.ast.HjArrayAccess1_c;
import polyglot.ext.hj.ast.HjArrayAccessAssign;
import polyglot.ext.hj.ast.HjArrayAccessUnary;
import polyglot.ext.hj.ast.HjArrayAccess_c;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Type;

public class QueryEngine {
    private static QueryEngine instance_;
    private ExtensionInfo ext;

    public static void init(ExtensionInfo ext) {
        instance_ = new QueryEngine(ext);
    }

    public static QueryEngine INSTANCE() {
        return instance_;
    }

    private QueryEngine(ExtensionInfo ext) {
        this.ext = ext;
    }

    public boolean isRectangularRankOneLowZero(HjArrayAccess1_c a) {
        if (a.array().type() instanceof HjParsedClassType) {
            HjParsedClassType t = (HjParsedClassType)a.array().type();
            return t.isZeroBased() && t.isRankOne() && t.isRect();
        }
        return false;
    }

    public boolean isRectangularRankOneLowZero(HjParsedClassType t) {
        return t.isZeroBased() && t.isRankOne() && t.isRect();
    }

    public boolean isRectangularRankOneLowZero(HjArrayAccess_c a) {
        if (a.array().type() instanceof HjParsedClassType) {
            HjParsedClassType t = (HjParsedClassType)a.array().type();
            return t.isZeroBased() && t.isRankOne() && t.isRect();
        }
        return false;
    }

    public boolean isRectangularRankTwoLowZero(HjParsedClassType t) {
        return t.isZeroBased() && t.isRankTwo() && t.isRect();
    }

    public boolean isRectangularRankTwoLowZero(HjArrayAccess_c a) {
        if (a.array().type() instanceof HjParsedClassType) {
            HjParsedClassType t = (HjParsedClassType)a.array().type();
            return t.isZeroBased() && t.isRankTwo() && t.isRect();
        }
        return false;
    }

    public boolean isRectangularRankThreeLowZero(HjParsedClassType t) {
        return t.isZeroBased() && t.isRankThree() && t.isRect();
    }

    public boolean isRectangularRankThreeLowZero(HjArrayAccess_c a) {
        if (a.array().type() instanceof HjParsedClassType) {
            HjParsedClassType t = (HjParsedClassType)a.array().type();
            return t.isZeroBased() && t.isRankThree() && t.isRect();
        }
        return false;
    }

    public boolean isPrimitiveIndex(HjArrayAccess_c a) {
        if (a != null && a.index() != null) {
            for (Expr indexExpr : a.index()) {
                if (indexExpr.type().isPrimitive()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isPrimitiveIndex(List indexList) {
        for (Expr indexExpr : indexList) {
            if (indexExpr.type().isPrimitive()) continue;
            return false;
        }
        return true;
    }

    protected boolean needsHereCheck(Type t) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            return false;
        }
        if (t instanceof HjType) {
            HjTypeSystem ts = (HjTypeSystem)t.typeSystem();
            if (ts.isPoint(t)) {
                return true;
            }
            if (ts.isValueType(t)) {
                return false;
            }
        }
        return true;
    }

    public boolean needsHereCheck(Call c) {
        return this.needsHereCheck(c.target().type());
    }

    public boolean needsHereCheck(Field f) {
        return this.needsHereCheck(f.target().type());
    }

    public boolean needsHereCheck(HjArrayAccess1 a) {
        return this.needsHereCheck(a.array().type());
    }

    public boolean needsHereCheck(HjArrayAccess a) {
        return this.needsHereCheck(a.array().type());
    }

    public boolean needsHereCheck(HjArrayAccess1Assign a) {
        return this.needsHereCheck(((HjArrayAccess1)a.left()).array().type());
    }

    public boolean needsHereCheck(HjArrayAccessAssign a) {
        return this.needsHereCheck(((HjArrayAccess)a.left()).array().type());
    }

    public boolean needsHereCheck(HjArrayAccess1Unary a) {
        return this.needsHereCheck(((HjArrayAccess1)a.expr()).array().type());
    }

    public boolean needsHereCheck(HjArrayAccessUnary a) {
        return this.needsHereCheck(((HjArrayAccess)a.expr()).array().type());
    }
}

