/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeObject;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.HjType_c;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.constr.C_Lit_c;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Constraint_c;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.types.FieldInstance;
import polyglot.types.PrimitiveType;
import polyglot.types.PrimitiveType_c;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPrimitiveType_c
extends PrimitiveType_c
implements HjPrimitiveType {
    protected List<HjClassType> annotations;
    protected Constraint depClause;
    protected List typeParameters;
    protected HjType rootType = this;
    protected transient DepParameterExpr dep;

    @Override
    public List<HjClassType> annotations() {
        if (this.annotations == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public boolean annotationsSet() {
        return true;
    }

    @Override
    public void setAnnotations(List<HjClassType> annotations) {
        if (annotations == null) {
            annotations = null;
        }
        this.annotations = new ArrayList<HjClassType>(annotations);
    }

    @Override
    public HjTypeObject annotations(List<HjClassType> annotations) {
        HjPrimitiveType_c n = (HjPrimitiveType_c)this.copy();
        n.setAnnotations(annotations);
        return n;
    }

    @Override
    public List<HjClassType> annotationMatching(Type t) {
        ArrayList<HjClassType> l = new ArrayList<HjClassType>();
        for (HjClassType ct : this.annotations()) {
            if (!ct.isSubtype(t)) continue;
            l.add(ct);
        }
        return l;
    }

    protected HjPrimitiveType_c() {
    }

    public HjPrimitiveType_c(TypeSystem ts, PrimitiveType.Kind kind) {
        super(ts, kind);
    }

    public boolean isNumeric() {
        return super.isNumeric() || this.kind == COMPLEX_32 || this.kind == COMPLEX_64;
    }

    @Override
    public HjType rootType() {
        return this.rootType;
    }

    @Override
    public boolean isRootType() {
        return this.rootType == this;
    }

    @Override
    public boolean isParametric() {
        return this.typeParameters != null && !this.typeParameters.isEmpty();
    }

    public List typeParameters() {
        return this.typeParameters;
    }

    @Override
    public Constraint depClause() {
        return this.depClause;
    }

    @Override
    public Constraint realClause() {
        return this.depClause;
    }

    @Override
    public boolean propertiesElaborated() {
        return true;
    }

    @Override
    public boolean isConstrained() {
        return this.depClause != null && !this.depClause.valid();
    }

    public void setDepGen(Constraint d, List l) {
        this.depClause = d;
        this.typeParameters = l;
    }

    @Override
    public C_Var selfVar() {
        return this.depClause == null ? null : this.depClause.selfVar();
    }

    @Override
    public void setSelfVar(C_Var v) {
        Constraint c = this.depClause();
        if (c == null) {
            this.depClause = new Constraint_c((HjTypeSystem)this.ts);
        }
        this.depClause.setSelfVar(v);
    }

    @Override
    public void addBinding(C_Var t1, C_Var t2) {
        if (this.depClause == null) {
            this.depClause = new Constraint_c((HjTypeSystem)this.ts);
        }
        this.depClause = this.depClause.addBinding(t1, t2);
    }

    @Override
    public boolean consistent() {
        return this.depClause == null || this.depClause.consistent();
    }

    @Override
    public HjType makeDepVariant(Constraint d, List<Type> l) {
        return this.makeVariant(d, l);
    }

    @Override
    public HjType dep(DepParameterExpr dep) {
        HjPrimitiveType_c n = (HjPrimitiveType_c)this.copy();
        n.dep = dep;
        return n;
    }

    @Override
    public DepParameterExpr dep() {
        return this.dep;
    }

    @Override
    public HjType makeVariant(Constraint d, List<Type> l) {
        if (d == null && (l == null || l.isEmpty())) {
            return this;
        }
        HjPrimitiveType_c n = (HjPrimitiveType_c)this.copy();
        n.typeParameters = l == null || l.isEmpty() ? this.typeParameters : l;
        n.depClause = d;
        return n;
    }

    @Override
    public HjType makeNoClauseVariant() {
        HjPrimitiveType_c n = (HjPrimitiveType_c)this.copy();
        n.depClause = new Constraint_c((HjTypeSystem)this.ts);
        n.typeParameters = this.typeParameters;
        n.dep = null;
        return n;
    }

    @Override
    public C_Term propVal(String name) {
        return this.depClause == null ? null : this.depClause.find(name);
    }

    public boolean typeEqualsImpl(Type o) {
        boolean result = this.equalsImpl((TypeObject)o) && ((HjTypeSystem)this.typeSystem()).equivClause(this, (HjType)o);
        return result;
    }

    public int hashCode() {
        return (this.rootType == this ? super.hashCode() : this.rootType.hashCode()) + (this.depClause == null || this.depClause.valid() ? 0 : this.depClause.hashCode()) + (this.typeParameters == null || this.typeParameters.isEmpty() ? 0 : ((Object)this.typeParameters).hashCode());
    }

    public boolean equalsImpl(TypeObject o) {
        if (!(o instanceof HjPrimitiveType_c)) {
            return false;
        }
        if (!super.equalsImpl(o)) {
            return false;
        }
        HjPrimitiveType_c other = (HjPrimitiveType_c)o;
        return ((HjTypeSystem)this.typeSystem()).equivClause(this, other);
    }

    @Override
    public boolean equalsWithoutClauseImpl(HjType o) {
        if (!(o instanceof HjPrimitiveType_c)) {
            return false;
        }
        return super.equalsImpl((TypeObject)o);
    }

    public boolean descendsFromImpl(Type ancestor) {
        HjTypeSystem xts = (HjTypeSystem)this.ts;
        return this.ts.equals((TypeObject)ancestor, (TypeObject)xts.HjObject()) || this.ts.equals((TypeObject)ancestor, (TypeObject)xts.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImplicitCastValidImpl(Type toType) {
        boolean result;
        block9: {
            HjType targetType;
            block8: {
                block7: {
                    targetType = (HjType)toType;
                    result = false;
                    if (!toType.isArray()) break block7;
                    boolean bl = false;
                    return bl;
                }
                result = this.ts.isSubtype((Type)this, (Type)targetType);
                if (!result) break block8;
                boolean bl = result;
                return bl;
            }
            NullableType realTarget = targetType.toNullable();
            if (realTarget != null) {
                result = this.ts.isSubtype((Type)this, (Type)realTarget.base());
            }
            if (!result) break block9;
            boolean bl = result;
            return bl;
        }
        HjTypeSystem xts = (HjTypeSystem)this.typeSystem();
        HjType other = (HjType)toType;
        if (xts.isComplex32(toType) || xts.isComplex64(toType)) {
            toType = ((HjComplexType)toType).base();
        }
        boolean bl = result = super.isImplicitCastValidImpl(toType) && xts.entailsClause(this, other);
        return bl;
    }

    public boolean isCastValidImpl(Type origType) {
        boolean result;
        HjTypeSystem xts = (HjTypeSystem)this.ts;
        HjType toType = (HjType)origType;
        NullableType nullType = toType.toNullable();
        if (nullType != null) {
            toType = nullType.base();
        }
        boolean bl = result = this.ts.equals((TypeObject)toType, (TypeObject)xts.Object()) || this.ts.equals((TypeObject)toType, (TypeObject)xts.HjObject()) || !toType.isComplex32() && !toType.isComplex64() && this.ts.equals((TypeObject)toType, (TypeObject)xts.boxedType((HjPrimitiveType)this.makeVariant(new Constraint_c((HjTypeSystem)this.ts), null)));
        if (result) {
            return result;
        }
        if (this.isVoid() || toType.isVoid()) {
            result = false;
            return false;
        }
        if (this.ts.typeEquals((Type)this, (Type)toType)) {
            result = true;
            return true;
        }
        if (xts.isBoxedType(toType)) {
            toType = (HjType)xts.boxedTypeToPrimitiveType(toType);
        }
        if (this.isNumeric() && toType.isNumeric()) {
            Constraint toRC;
            C_Var t;
            Promise p;
            Constraint rc = this.realClause();
            if (rc != null && (p = rc.lookup(C_Special_c.Self)) != null && (t = p.term()) != null && (toRC = toType.realClause()) != null) {
                C_Var t2 = toRC.lookup(C_Special_c.Self).term();
                result = t2 == null || t.equals(t2);
                return result;
            }
            result = true;
            return true;
        }
        HjType base = this.rootType();
        if (base != this) {
            return ((PrimitiveType)base).isCastValidImpl((Type)toType);
        }
        return false;
    }

    public void print(CodeWriter w) {
        w.write(super.toString());
    }

    public String toString() {
        return this.toStringForDisplay();
    }

    private static String getStackTrace() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] trace = new Throwable().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            sb.append("\t").append(trace[i]).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toStringForDisplay() {
        String clause = "";
        if (this.depClause != null) {
            clause = this.depClause.toString();
        }
        return (this.rootType == this ? super.toString() : ((HjPrimitiveType_c)this.rootType).toString()) + (this.isParametric() ? this.typeParameters.toString() : "") + (this.depClause == null ? "" : clause);
    }

    @Override
    public String typeName() {
        return this.rootType == this ? super.toString() : ((HjPrimitiveType_c)this.rootType).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean numericConversionValidImpl(Object value) {
        HjType tb;
        boolean result;
        HjTypeSystem ts;
        HjPrimitiveType_c xme;
        block5: {
            block4: {
                xme = this;
                ts = (HjTypeSystem)xme.typeSystem();
                result = false;
                tb = xme.rootType();
                if (xme != tb) break block4;
                boolean bl = result = super.numericConversionValidImpl(value);
                return bl;
            }
            result = super.numericConversionValidImpl(value);
            if (result) break block5;
            boolean bl = result;
            return bl;
        }
        C_Special_c self = new C_Special_c(HjSpecial.SELF, tb);
        C_Lit_c val = new C_Lit_c(value, tb);
        Constraint c = Constraint_c.makeBinding(self, val, ts);
        boolean bl = result = ts.entailsClause(xme.realClause(), c);
        return bl;
    }

    public boolean isSubtypeImpl(Type other) {
        return HjType_c.isSubtypeImpl(this, other);
    }

    public boolean isValueType() {
        return ((HjTypeSystem)this.typeSystem()).isValueType(this);
    }

    @Override
    public List<FieldInstance> properties() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<FieldInstance> definedProperties() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public NullableType toNullable() {
        return HjType_c.toNullable(this);
    }

    @Override
    public FutureType toFuture() {
        return HjType_c.toFuture(this);
    }

    @Override
    public boolean safe() {
        return true;
    }

    @Override
    public boolean isComplex32() {
        return this.kind == COMPLEX_32;
    }

    @Override
    public boolean isComplex64() {
        return this.kind == COMPLEX_64;
    }
}

