/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ast.Expr;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.AsyncInstance_c;
import polyglot.ext.hj.types.ClosureInstance;
import polyglot.ext.hj.types.ClosureInstance_c;
import polyglot.ext.hj.types.ClosureType;
import polyglot.ext.hj.types.ClosureType_c;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.FutureTypeVoid_c;
import polyglot.ext.hj.types.FutureType_c;
import polyglot.ext.hj.types.HjArrayType_c;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjComplexType_c;
import polyglot.ext.hj.types.HjConstructorInstance_c;
import polyglot.ext.hj.types.HjContext_c;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjFieldInstance_c;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjLocalInstance_c;
import polyglot.ext.hj.types.HjMethodInstance;
import polyglot.ext.hj.types.HjMethodInstance_c;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjNullType_c;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjParsedClassType_c;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjPrimitiveType_c;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeObject;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.HjUnknownType_c;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.NullableType_c;
import polyglot.ext.hj.types.constr.C_Here_c;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Lit_c;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.TypeTranslator;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.UnknownType;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjTypeSystem_c
extends TypeSystem_c
implements HjTypeSystem,
Serializable {
    private static final Set<String> primitiveTypeNames = new HashSet<String>();
    protected final PrimitiveType COMPLEX_64_ = this.createPrimitive(HjPrimitiveType.COMPLEX_64);
    protected final PrimitiveType COMPLEX_32_ = this.createPrimitive(HjPrimitiveType.COMPLEX_32);
    protected final HjFlags Hj_TOP_LEVEL_CLASS_FLAGS = (HjFlags)this.legalTopLevelClassFlags();
    protected final HjFlags Hj_INTERFACE_FLAGS = (HjFlags)this.legalInterfaceFlags();
    protected final Flags Hj_MEMBER_CLASS_FLAGS = (HjFlags)this.legalMemberClassFlags();
    protected final HjFlags Hj_LOCAL_CLASS_FLAGS = (HjFlags)this.legalLocalClassFlags();
    private static final String WRAPPER_PACKAGE = "hj.compilergenerated";
    protected ClassType hjObjectType_;
    protected ClassType parameter1Type_;
    protected ClassType placeType_;
    protected ClassType regionType_;
    protected ClassType pointType_;
    protected ClassType valueType_;
    protected ClassType distributionType_;
    protected ClassType activityType_;
    protected ClassType futureActivityType_;
    protected ClassType hjArrayType_;
    protected ClassType phaserType_;
    protected ClassType phaserMode_;
    protected ClassType runtimeType_;
    protected ClassType operatorPointwiseType_;
    protected ClassType operatorBinaryType_;
    protected ClassType operatorUnaryType_;
    protected ClassType arrayOperationsType_;
    protected HjParsedClassType booleanArrayType_;
    protected HjParsedClassType charArrayType_;
    protected HjParsedClassType byteArrayType_;
    protected HjParsedClassType shortArrayType_;
    protected HjParsedClassType intArrayType_;
    protected HjParsedClassType longArrayType_;
    protected HjParsedClassType floatArrayType_;
    protected HjParsedClassType doubleArrayType_;
    protected HjParsedClassType complexFloatArrayType_;
    protected HjParsedClassType complexDoubleArrayType_;
    protected HjParsedClassType objectArrayType_;
    protected ClassType indexableType_ = null;
    protected ClassType arrayType_ = null;
    Constraint rect;
    protected TypeTranslator eval = new TypeTranslator(this);
    protected C_Here_c hereConstraintLit;
    protected C_Lit FALSE;
    protected C_Lit TRUE;
    protected C_Lit NEG_ONE;
    protected C_Lit ZERO;
    protected C_Lit ONE;
    protected C_Lit TWO;
    protected C_Lit THREE;
    protected C_Lit NULL;
    protected final Flags Hj_METHOD_FLAGS = this.legalMethodFlags();

    public HjTypeSystem_c() {
        this.unknownType = new HjUnknownType_c(this);
    }

    public boolean isCanonical(Type type) {
        return super.isCanonical(type);
    }

    @Override
    public boolean isPrimitiveTypeName(String name) {
        return primitiveTypeNames.contains(name);
    }

    public Context createContext() {
        return new HjContext_c(this);
    }

    public Flags legalMethodFlags() {
        HjFlags x = HjFlags.toHjFlags(this.legalAccessFlags().Abstract().Static().Final().Native().Synchronized().StrictFP());
        x = x.Safe().Local().NonBlocking().Sequential();
        return x;
    }

    public Flags legalTopLevelClassFlags() {
        return HjFlags.toHjFlags(super.legalTopLevelClassFlags()).Safe();
    }

    public Flags legalInterfaceFlags() {
        return HjFlags.toHjFlags(super.legalInterfaceFlags()).Safe();
    }

    public Flags legalMemberClassFlags() {
        return HjFlags.toHjFlags(super.legalMemberClassFlags()).Safe();
    }

    public Flags legalLocalClassFlags() {
        return HjFlags.toHjFlags(super.legalLocalClassFlags()).Safe();
    }

    public MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List argTypes, List excTypes) {
        this.assert_((TypeObject)container);
        this.assert_((TypeObject)returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new HjMethodInstance_c(this, pos, container, flags, returnType, name, argTypes, excTypes);
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        this.assert_((TypeObject)fromType);
        this.assert_((TypeObject)toType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[HjTypeSystem_c] isImplicitCastValid |" + fromType.getClass() + "| to |" + toType + "|?"));
        }
        boolean result = fromType.isImplicitCastValidImpl(toType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[HjTypeSystem_c] ... " + result));
        }
        return result;
    }

    @Override
    public NullableType createNullableType(Position pos, HjNamedType type) {
        NullableType t = NullableType_c.makeNullable(this, pos, type);
        return t;
    }

    @Override
    public FutureType createFutureType(Position pos, HjNamedType type) {
        if (type.isVoid()) {
            return new FutureTypeVoid_c(this, pos, type);
        }
        return new FutureType_c(this, pos, type);
    }

    protected UnknownType createUnknownType() {
        return this.unknownType;
    }

    @Override
    public CodeInstance asyncWithReturnCodeInstance(Type returnType) {
        return this.asyncCodeInstance_(returnType, true);
    }

    @Override
    public CodeInstance asyncCodeInstance(Type returnType) {
        return this.asyncCodeInstance_(returnType, false);
    }

    private CodeInstance asyncCodeInstance_(Type returnType, boolean isAsyncWithReturn) {
        return new AsyncInstance_c(this, Position.COMPILER_GENERATED, (ReferenceType)this.Runtime(), this.Public(), returnType, "$dummyAsync$", Collections.EMPTY_LIST, Collections.EMPTY_LIST, isAsyncWithReturn);
    }

    @Override
    public ClosureType closure(Position p, Type returnType, List<Type> argTypes, List<Type> throwTypes) {
        return new ClosureType_c(this, p, returnType, argTypes, throwTypes);
    }

    @Override
    public ClosureInstance closureInstance(Position p, ClassType typeContainer, MethodInstance methodContainer, Type returnType, List argTypes, List excTypes) {
        return new ClosureInstance_c(this, p, typeContainer, methodContainer, returnType, argTypes, excTypes);
    }

    protected NullType createNull() {
        return new HjNullType_c(this);
    }

    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        if (Report.should_report((String)"debug", (int)3)) {
            Report.report((int)3, (String)("HjTypeSystem_c: Creating Class fromSource =|" + fromSource + "|"));
        }
        return new HjParsedClassType_c(this, init, fromSource);
    }

    public PrimitiveType createPrimitive(PrimitiveType.Kind kind) {
        if (kind == HjPrimitiveType.COMPLEX_32 || kind == HjPrimitiveType.COMPLEX_64) {
            return new HjComplexType_c(this, kind);
        }
        return new HjPrimitiveType_c(this, kind);
    }

    @Override
    public ClassType HjObject() {
        if (this.hjObjectType_ == null) {
            this.hjObjectType_ = this.load("hj.lang.Object");
        }
        return this.hjObjectType_;
    }

    @Override
    public ClassType parameter1() {
        if (this.parameter1Type_ == null) {
            this.parameter1Type_ = this.load("hj.compilergenerated.Parameter1");
        }
        return this.parameter1Type_;
    }

    @Override
    public ClassType place() {
        if (this.placeType_ == null) {
            this.placeType_ = this.load("hj.lang.place");
        }
        return this.placeType_;
    }

    @Override
    public ClassType region() {
        if (this.regionType_ == null) {
            this.regionType_ = this.load("hj.lang.region");
        }
        return this.regionType_;
    }

    @Override
    public ClassType point() {
        if (this.pointType_ == null) {
            this.pointType_ = this.load("hj.lang.point");
        }
        return this.pointType_;
    }

    @Override
    public ClassType value() {
        if (this.valueType_ == null) {
            this.valueType_ = this.load("hj.lang.ValueType");
        }
        return this.valueType_;
    }

    @Override
    public ClassType distribution() {
        if (this.distributionType_ == null) {
            this.distributionType_ = this.load("hj.lang.dist");
        }
        return this.distributionType_;
    }

    @Override
    public ClassType Activity() {
        if (this.activityType_ == null) {
            this.activityType_ = this.load("hj.lang.Activity");
        }
        return this.activityType_;
    }

    @Override
    public ClassType FutureActivity() {
        if (this.futureActivityType_ == null) {
            this.futureActivityType_ = this.load("hj.lang.Activity$Expr");
        }
        return this.futureActivityType_;
    }

    @Override
    public ClassType array() {
        if (this.hjArrayType_ == null) {
            this.hjArrayType_ = this.load("hj.array.lang.hjArray");
        }
        return this.hjArrayType_;
    }

    @Override
    public ClassType phaser() {
        if (this.phaserType_ == null) {
            this.phaserType_ = this.load("hj.lang.phaser");
        }
        return this.phaserType_;
    }

    @Override
    public ClassType phaserMode() {
        if (this.phaserMode_ == null) {
            this.phaserMode_ = this.load("hj.lang.phaserMode");
        }
        return this.phaserMode_;
    }

    @Override
    public ClassType Runtime() {
        if (this.runtimeType_ == null) {
            this.runtimeType_ = this.load("hj.lang.Runtime");
        }
        return this.runtimeType_;
    }

    @Override
    public ClassType OperatorPointwise() {
        if (this.operatorPointwiseType_ == null) {
            this.operatorPointwiseType_ = this.load("hj.array.Operator.Pointwise");
        }
        return this.operatorPointwiseType_;
    }

    @Override
    public ClassType OperatorBinary() {
        if (this.operatorBinaryType_ == null) {
            this.operatorBinaryType_ = this.load("hj.array.Operator.Binary");
        }
        return this.operatorBinaryType_;
    }

    @Override
    public ClassType OperatorUnary() {
        if (this.operatorUnaryType_ == null) {
            this.operatorUnaryType_ = this.load("hj.array.Operator.Unary");
        }
        return this.operatorUnaryType_;
    }

    @Override
    public ClassType ArrayOperations() {
        if (this.arrayOperationsType_ == null) {
            this.arrayOperationsType_ = this.load("hj.array.lang.ArrayOperations");
        }
        return this.arrayOperationsType_;
    }

    protected ArrayType arrayType(Position pos, Type type) {
        return new HjArrayType_c(this, pos, type);
    }

    @Override
    public ReferenceType array(Type type, boolean isValueType, Expr distribution) {
        return this.arrayView(type);
    }

    @Override
    public ReferenceType array(Type type, Expr distribution) {
        return this.array(type, false, distribution);
    }

    @Override
    public ReferenceType array(Type type, boolean isValue) {
        return this.array(type, isValue, null);
    }

    @Override
    public ReferenceType array(Type type) {
        return this.array(type, false, null);
    }

    @Override
    public ClassType booleanArray() {
        if (this.booleanArrayType_ == null) {
            this.booleanArrayType_ = (HjParsedClassType)this.load("hj.array.view.BooleanArrayView");
        }
        HjParsedClassType result = this.booleanArrayType_;
        return result;
    }

    @Override
    public ClassType charArray() {
        if (this.charArrayType_ == null) {
            this.charArrayType_ = (HjParsedClassType)this.load("hj.array.view.CharArrayView");
        }
        HjParsedClassType result = this.charArrayType_;
        return result;
    }

    @Override
    public ClassType byteArray() {
        if (this.byteArrayType_ == null) {
            this.byteArrayType_ = (HjParsedClassType)this.load("hj.array.view.ByteArrayView");
        }
        HjParsedClassType result = this.byteArrayType_;
        return result;
    }

    @Override
    public ClassType shortArray() {
        if (this.shortArrayType_ == null) {
            this.shortArrayType_ = (HjParsedClassType)this.load("hj.array.view.ShortArrayView");
        }
        HjParsedClassType result = this.shortArrayType_;
        return result;
    }

    @Override
    public ClassType intArray() {
        if (this.intArrayType_ == null) {
            this.intArrayType_ = (HjParsedClassType)this.load("hj.array.view.IntArrayView");
        }
        HjParsedClassType result = this.intArrayType_;
        return result;
    }

    @Override
    public ClassType longArray() {
        if (this.longArrayType_ == null) {
            this.longArrayType_ = (HjParsedClassType)this.load("hj.array.view.LongArrayView");
        }
        HjParsedClassType result = this.longArrayType_;
        return result;
    }

    @Override
    public ClassType floatArray() {
        if (this.floatArrayType_ == null) {
            this.floatArrayType_ = (HjParsedClassType)this.load("hj.array.view.FloatArrayView");
        }
        HjParsedClassType result = this.floatArrayType_;
        return result;
    }

    @Override
    public ClassType doubleArray() {
        if (this.doubleArrayType_ == null) {
            this.doubleArrayType_ = (HjParsedClassType)this.load("hj.array.view.DoubleArrayView");
        }
        HjParsedClassType result = this.doubleArrayType_;
        return result;
    }

    @Override
    public ClassType complexFloatArray() {
        if (this.complexFloatArrayType_ == null) {
            this.complexFloatArrayType_ = (HjParsedClassType)this.load("hj.array.view.ComplexFloatArrayView");
        }
        HjParsedClassType result = this.complexFloatArrayType_;
        return result;
    }

    @Override
    public ClassType complexDoubleArray() {
        if (this.complexDoubleArrayType_ == null) {
            this.complexDoubleArrayType_ = (HjParsedClassType)this.load("hj.array.view.ComplexDoubleArrayView");
        }
        HjParsedClassType result = this.complexDoubleArrayType_;
        return result;
    }

    public ClassType genericArray(List<Type> typeParams) {
        if (this.objectArrayType_ == null) {
            this.objectArrayType_ = (HjParsedClassType)this.load("hj.array.view.ObjectArrayView");
        }
        ClassType result = (ClassType)this.objectArrayType_.makeVariant(null, typeParams);
        return result;
    }

    @Override
    public ClassType Indexable() {
        if (this.indexableType_ == null) {
            this.indexableType_ = this.load("hj.lang.Indexable");
        }
        return this.indexableType_;
    }

    @Override
    public ClassType ArrayView() {
        if (this.arrayType_ == null) {
            this.arrayType_ = this.load("hj.lang.ArrayView");
        }
        return this.arrayType_;
    }

    @Override
    public MethodInstance primitiveEquals() {
        String name = "hj.compilergenerated.BoxedNumber";
        try {
            Type ct = (Type)this.systemResolver().find(name);
            LinkedList<ClassType> args = new LinkedList<ClassType>();
            args.add(this.HjObject());
            args.add(this.HjObject());
            Iterator i = ct.toClass().methods("equals", args).iterator();
            if (i.hasNext()) {
                MethodInstance mi = (MethodInstance)i.next();
                return mi;
            }
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e.getMessage());
        }
        throw new InternalCompilerError("Could not find equals method.");
    }

    @Override
    public MethodInstance getter(HjPrimitiveType t) {
        String methodName = t.typeName() + "Value";
        ConstructorInstance ci = this.wrapper(t);
        for (MethodInstance mi : ci.container().methods()) {
            if (!mi.name().equals(methodName) || !mi.formalTypes().isEmpty()) continue;
            return mi;
        }
        throw new InternalCompilerError("Could not find getter for " + t);
    }

    @Override
    public HjNamedType boxedType(HjPrimitiveType t) {
        HjNamedType namedType = (HjNamedType)this.wrapper(t).container();
        return namedType;
    }

    @Override
    public boolean isBoxedType(Type t) {
        t = this.isNullable(t) ? ((NullableType)t).base() : t;
        String targetCanonicalName = t.toString();
        return t instanceof HjParsedClassType && targetCanonicalName.startsWith("hj.compilergenerated.Boxed");
    }

    @Override
    public String getGetterName(Type t) {
        if (this.isBoxedType(t)) {
            t = this.isNullable(t) ? ((NullableType)t).base() : t;
            return this.boxedGetterAsString((HjParsedClassType)t);
        }
        throw new InternalCompilerError(t + " is not a primitive type boxed");
    }

    @Override
    public ConstructorInstance wrapper(HjPrimitiveType t) {
        String name = "hj.compilergenerated.Boxed" + this.wrapperTypeString(t).substring("java.lang.".length());
        try {
            ClassType ct = ((Type)this.systemResolver().find(name)).toClass();
            for (ConstructorInstance ci : ct.constructors()) {
                Type argType;
                if (ci.formalTypes().size() != 1 || !this.typeBaseEquals(argType = (Type)ci.formalTypes().get(0), t)) continue;
                if (t.depClause() != null) {
                    ci.setContainer((ReferenceType)((HjNamedType)ci.container()).makeVariant(t.depClause(), null));
                }
                return ci;
            }
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e.getMessage());
        }
        throw new InternalCompilerError("Could not find constructor for " + t);
    }

    @Override
    public Type boxedTypeToPrimitiveType(Type presumedBoxedType) {
        if (this.isBoxedType(presumedBoxedType)) {
            HjType t = (HjType)this.boxedTypeToPrimitiveType((HjParsedClassType)presumedBoxedType);
            return t.makeVariant(((HjType)presumedBoxedType).depClause(), null);
        }
        throw new InternalCompilerError("can't get primitive type from " + presumedBoxedType + " because it is not a boxed type");
    }

    private String boxedToPrimitiveName(String boxedClassName) {
        String prefix = "Boxed";
        return boxedClassName.substring(prefix.length(), boxedClassName.length());
    }

    private Type boxedTypeToPrimitiveType(HjParsedClassType t) {
        this.assert_(t);
        String boxedTypeName = this.boxedToPrimitiveName(t.name());
        if (boxedTypeName.equals("Boolean")) {
            return this.Boolean();
        }
        if (boxedTypeName.equals("Character")) {
            return this.Char();
        }
        if (boxedTypeName.equals("Byte")) {
            return this.Byte();
        }
        if (boxedTypeName.equals("Short")) {
            return this.Short();
        }
        if (boxedTypeName.equals("Integer")) {
            return this.Int();
        }
        if (boxedTypeName.equals("Long")) {
            return this.Long();
        }
        if (boxedTypeName.equals("Float")) {
            return this.Float();
        }
        if (boxedTypeName.equals("Double")) {
            return this.Double();
        }
        throw new InternalCompilerError(t + " is not a primitive type boxed");
    }

    private String boxedGetterAsString(HjParsedClassType t) {
        this.assert_(t);
        String boxedTypeName = this.boxedToPrimitiveName(t.name());
        if (boxedTypeName.equals("Boolean")) {
            return "booleanValue";
        }
        if (boxedTypeName.equals("Character")) {
            return "charValue";
        }
        if (boxedTypeName.equals("Byte")) {
            return "byteValue";
        }
        if (boxedTypeName.equals("Short")) {
            return "shortValue";
        }
        if (boxedTypeName.equals("Integer")) {
            return "intValue";
        }
        if (boxedTypeName.equals("Long")) {
            return "longValue";
        }
        if (boxedTypeName.equals("Float")) {
            return "floatValue";
        }
        if (boxedTypeName.equals("Double")) {
            return "doubleValue";
        }
        throw new InternalCompilerError(t + " is not a primitive type boxed");
    }

    public Flags flagsForBits(int bits) {
        Flags sf = super.flagsForBits(bits);
        if (sf.isInterface()) {
            return sf.Static();
        }
        return sf;
    }

    public FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        this.assert_((TypeObject)container);
        this.assert_((TypeObject)type);
        return new HjFieldInstance_c((TypeSystem)this, pos, container, flags, type, name);
    }

    @Override
    public HjFieldInstance propertyInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        this.assert_((TypeObject)container);
        this.assert_((TypeObject)type);
        return new HjFieldInstance_c((TypeSystem)this, pos, container, flags, type, name);
    }

    public boolean isCastValid(Type fromType, Type toType) {
        return super.isCastValid(fromType, toType);
    }

    @Override
    public boolean isPrimitiveTypeArray(Type me1) {
        HjType me = (HjType)me1;
        return this.isBooleanArray(me) || this.isCharArray(me) || this.isByteArray(me) || this.isShortArray(me) || this.isIntArray(me) || this.isLongArray(me) || this.isFloatArray(me) || this.isDoubleArray(me) || this.isComplexFloatArray(me) || this.isComplexDoubleArray(me);
    }

    @Override
    public boolean isNullable(Type me) {
        return me instanceof NullableType;
    }

    @Override
    public boolean isFuture(Type me) {
        NullableType r = ((HjType)me).toNullable();
        if (r != null) {
            me = r.base();
        }
        return me instanceof FutureType;
    }

    protected boolean isHjSubtype(Type me, Type sup) {
        NullableType r = ((HjType)me).toNullable();
        if (r != null) {
            me = r.base();
        }
        boolean result = this.isSubtype(me, sup);
        return result;
    }

    protected boolean isHjBaseSubtype(Type me, Type sup) {
        HjType xme = (HjType)me;
        HjType xsup = (HjType)sup;
        xme = xme.rootType();
        xsup = xsup.rootType();
        return this.isHjSubtype(xme, xsup);
    }

    @Override
    public boolean isIndexable(Type me) {
        HjType mex = (HjType)me;
        return this.isHjSubtype(mex.makeNoClauseVariant(), (Type)this.Indexable());
    }

    @Override
    public boolean isHjArrayView(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.ArrayView());
    }

    @Override
    public boolean isTypeConstrained(Type me) {
        HjType target = this.isNullable(me) ? ((NullableType)me).base() : (HjType)me;
        return target.depClause() != null;
    }

    @Override
    public boolean isBooleanArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.booleanArray());
    }

    @Override
    public boolean isCharArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.charArray());
    }

    @Override
    public boolean isByteArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.byteArray());
    }

    @Override
    public boolean isShortArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.shortArray());
    }

    @Override
    public boolean isIntArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.intArray());
    }

    @Override
    public boolean isLongArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.longArray());
    }

    @Override
    public boolean isFloatArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.floatArray());
    }

    @Override
    public boolean isDoubleArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.doubleArray());
    }

    @Override
    public boolean isComplexFloatArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.complexFloatArray());
    }

    @Override
    public boolean isComplexDoubleArray(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.complexDoubleArray());
    }

    @Override
    public boolean isPhaser(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.phaser());
    }

    @Override
    public boolean isPoint(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.point());
    }

    @Override
    public boolean isHjObject(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.HjObject());
    }

    @Override
    public boolean isPlace(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.place());
    }

    @Override
    public boolean isRegion(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.region());
    }

    @Override
    public boolean isDistribution(Type me) {
        return this.isHjSubtype(((HjType)me).makeNoClauseVariant(), (Type)this.distribution());
    }

    @Override
    public boolean isDistributedArray(Type me) {
        return this.isHjArrayView(me);
    }

    @Override
    public boolean isValueType(Type me) {
        return this.isHjBaseSubtype((HjType)me, (Type)this.value());
    }

    @Override
    public Type baseType(Type theType) {
        Type me = theType;
        if (this.isBooleanArray(me)) {
            return this.Boolean();
        }
        if (this.isByteArray(me)) {
            return this.Byte();
        }
        if (this.isCharArray(me)) {
            return this.Char();
        }
        if (this.isShortArray(me)) {
            return this.Short();
        }
        if (this.isIntArray(me)) {
            return this.Int();
        }
        if (this.isLongArray(me)) {
            return this.Long();
        }
        if (this.isFloatArray(me)) {
            return this.Float();
        }
        if (this.isDoubleArray(me)) {
            return this.Double();
        }
        if (this.isComplexFloatArray(me)) {
            return this.Complex32();
        }
        if (this.isComplexDoubleArray(me)) {
            return this.Complex64();
        }
        if (!this.isHjArrayView(me)) {
            return null;
        }
        return ((HjType)me).rootType();
    }

    @Override
    public VarInstance createSelf(HjType t) {
        HjLocalInstance_c v = new HjLocalInstance_c(this, Position.COMPILER_GENERATED, Flags.PUBLIC, t, "self");
        return v;
    }

    @Override
    public TypeTranslator typeTranslator() {
        return this.eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equivClause(HjType me, HjType other) {
        boolean result = true;
        HjType bt1 = me.rootType();
        HjType bt2 = other.rootType();
        if (!(result &= bt1 == bt2)) {
            return result;
        }
        List<Type> tp1 = me.typeParameters();
        List<Type> tp2 = other.typeParameters();
        if (tp1 == null || tp1.isEmpty()) {
            if (tp2 != null && !tp2.isEmpty()) {
                return false;
            }
        } else {
            int n = tp1.size();
            if (n > 0) {
                if (tp2 == null) return false;
                if (n != tp2.size()) {
                    return false;
                }
                Iterator<Type> it1 = tp1.iterator();
                Iterator<Type> it2 = tp2.iterator();
                while (it1.hasNext()) {
                    Type t2;
                    Type t1 = it1.next();
                    if (result &= t1.equals(t2 = it2.next())) continue;
                    return result;
                }
                if (!result) {
                    return result;
                }
            }
        }
        if (!this.entailsClause(me, other)) return false;
        if (!this.entailsClause(other, me)) return false;
        return true;
    }

    @Override
    public boolean equivClause(Constraint c1, Constraint c2) {
        boolean result = c1 == null ? (c2 == null ? true : c2.valid()) : c1.equiv(c2);
        return result;
    }

    @Override
    public boolean entailsClause(Constraint c1, Constraint c2) {
        boolean result = c1 == null ? c2 == null || c2.valid() : c1.entails(c2);
        return result;
    }

    @Override
    public boolean entailsClause(HjType me, HjType other) {
        Constraint c1 = me.realClause();
        Constraint c2 = other.depClause();
        return this.entailsClause(c1, c2);
    }

    @Override
    public C_Here_c here() {
        if (this.hereConstraintLit == null) {
            this.hereConstraintLit = new C_Here_c(this);
        }
        return this.hereConstraintLit;
    }

    @Override
    public C_Lit FALSE() {
        if (this.FALSE == null) {
            this.FALSE = new C_Lit_c(false, this);
        }
        return this.FALSE;
    }

    @Override
    public C_Lit TRUE() {
        if (this.TRUE == null) {
            this.TRUE = new C_Lit_c(true, this);
        }
        return this.TRUE;
    }

    @Override
    public C_Lit NEG_ONE() {
        if (this.NEG_ONE == null) {
            this.NEG_ONE = new C_Lit_c(new Integer(-1), (Type)this.Int());
        }
        return this.NEG_ONE;
    }

    @Override
    public C_Lit ZERO() {
        if (this.ZERO == null) {
            this.ZERO = new C_Lit_c(new Integer(0), (Type)this.Int());
        }
        return this.ZERO;
    }

    @Override
    public C_Lit ONE() {
        if (this.ONE == null) {
            this.ONE = new C_Lit_c(new Integer(1), (Type)this.Int());
        }
        return this.ONE;
    }

    @Override
    public C_Lit TWO() {
        if (this.TWO == null) {
            this.TWO = new C_Lit_c(new Integer(2), (Type)this.Int());
        }
        return this.TWO;
    }

    @Override
    public C_Lit THREE() {
        if (this.THREE == null) {
            this.THREE = new C_Lit_c(new Integer(3), (Type)this.Int());
        }
        return this.THREE;
    }

    @Override
    public C_Lit NULL() {
        if (this.NULL == null) {
            this.NULL = new C_Lit_c(null, (Type)this.Null());
        }
        return this.NULL;
    }

    public Flags createNewFlag(String name, Flags after) {
        Flags f = HjFlags.createFlag(name, after);
        this.flagsForName.put(name, f);
        return f;
    }

    protected void initFlags() {
        super.initFlags();
        this.flagsForName.put("local", HjFlags.LOCAL);
        this.flagsForName.put("nonblocking", HjFlags.NON_BLOCKING);
        this.flagsForName.put("safe", HjFlags.SAFE);
        this.flagsForName.put("sequential", HjFlags.SEQUENTIAL);
    }

    public Flags Local() {
        return HjFlags.LOCAL;
    }

    public Flags Sequential() {
        return HjFlags.SEQUENTIAL;
    }

    public Flags Safe() {
        return HjFlags.SAFE;
    }

    public Flags NonBlocking() {
        return HjFlags.NON_BLOCKING;
    }

    public void checkMethodFlags(Flags f) throws SemanticException {
        if (!f.clear(this.Hj_METHOD_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare method with flags " + f.clear(this.Hj_METHOD_FLAGS) + ".");
        }
        if (f.isAbstract() && !f.clear(this.ABSTRACT_METHOD_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare abstract method with flags " + f.clear(this.ABSTRACT_METHOD_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        if (!f.clear((Flags)this.Hj_TOP_LEVEL_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level class with flag(s) " + f.clear((Flags)this.Hj_TOP_LEVEL_CLASS_FLAGS) + ".");
        }
        if (f.isInterface() && !f.clear((Flags)this.Hj_INTERFACE_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare interface with flags " + f.clear((Flags)this.Hj_INTERFACE_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.Hj_MEMBER_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.Hj_MEMBER_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkLocalClassFlags(Flags f) throws SemanticException {
        if (f.isInterface()) {
            throw new SemanticException("Cannot declare a local interface.");
        }
        if (!f.clear((Flags)this.Hj_LOCAL_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a local class with flag(s) " + f.clear((Flags)this.Hj_LOCAL_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    @Override
    public FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, String name, String initValue) {
        this.assert_((TypeObject)container);
        return new HjFieldInstance_c((TypeSystem)this, pos, container, flags, name, initValue);
    }

    @Override
    public boolean equalsWithoutClause(HjType type1, HjType type2) {
        this.assert_(type1);
        this.assert_(type2);
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.equalsWithoutClauseImpl(type2);
    }

    public PrimitiveType promote(Type t) throws SemanticException {
        PrimitiveType pt = super.promote(t);
        if (pt instanceof HjPrimitiveType) {
            return (HjPrimitiveType)((HjPrimitiveType)pt).rootType();
        }
        return pt;
    }

    public PrimitiveType promote(Type t1, Type t2) throws SemanticException {
        PrimitiveType pt = super.promote(t1, t2);
        if (pt instanceof HjPrimitiveType) {
            return (HjPrimitiveType)((HjPrimitiveType)pt).rootType();
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        block25: {
            HjType result;
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    block18: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    block17: {
                                                                        this.assert_((TypeObject)type1);
                                                                        this.assert_((TypeObject)type2);
                                                                        result = null;
                                                                        if (!this.typeBaseEquals(type1, type2)) break block17;
                                                                        HjType hjType = result = ((HjType)type1).rootType();
                                                                        return hjType;
                                                                    }
                                                                    if (!type1.isNumeric() || !type2.isNumeric()) break block18;
                                                                    if (!this.isImplicitCastValid(type1, type2)) break block19;
                                                                    result = type2;
                                                                    Type type = result;
                                                                    return type;
                                                                }
                                                                if (!this.isImplicitCastValid(type2, type1)) break block20;
                                                                result = type1;
                                                                Type type = result;
                                                                return type;
                                                            }
                                                            if ((!type1.isChar() || !type2.isByte()) && (!type1.isByte() || !type2.isChar())) break block21;
                                                            result = this.Int();
                                                            PrimitiveType primitiveType = result;
                                                            return primitiveType;
                                                        }
                                                        if ((!type1.isChar() || !type2.isShort()) && (!type1.isShort() || !type2.isChar())) break block18;
                                                        result = this.Int();
                                                        PrimitiveType primitiveType = result;
                                                        return primitiveType;
                                                    }
                                                    if (!type1.isArray() || !type2.isArray()) break block22;
                                                    result = this.arrayOf(this.leastCommonAncestor(type1.toArray().base(), type2.toArray().base()));
                                                    ArrayType arrayType = result;
                                                    return arrayType;
                                                }
                                                if (!type1.isReference() || !type2.isNull()) break block23;
                                                result = type1;
                                                Type type = result;
                                                return type;
                                            }
                                            if (!type2.isReference() || !type1.isNull()) break block24;
                                            result = type2;
                                            Type type = result;
                                            return type;
                                        }
                                        if (!type1.isReference() || !type2.isReference()) break block25;
                                        if (!type1.isClass() || !type1.toClass().flags().isInterface()) break block26;
                                        result = this.Object();
                                        ClassType classType = result;
                                        return classType;
                                    }
                                    if (!type2.isClass() || !type2.toClass().flags().isInterface()) break block27;
                                    result = this.Object();
                                    ClassType classType = result;
                                    return classType;
                                }
                                if (!this.typeEquals(type1, (Type)this.Object())) break block28;
                                result = type1;
                                Type type = result;
                                return type;
                            }
                            if (!this.typeEquals(type2, (Type)this.Object())) break block29;
                            result = type2;
                            Type type = result;
                            return type;
                        }
                        if (!this.isSubtype(type1, type2)) break block30;
                        result = type2;
                        Type type = result;
                        return type;
                    }
                    if (!this.isSubtype(type2, type1)) break block31;
                    result = type1;
                    Type type = result;
                    return type;
                }
                Type t1 = this.leastCommonAncestor(type1.toReference().superType(), type2);
                Type t2 = this.leastCommonAncestor(type2.toReference().superType(), type1);
                if (!this.typeEquals(t1, t2)) break block32;
                result = t1;
                Type type = result;
                return type;
            }
            result = this.Object();
            ClassType classType = result;
            return classType;
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    @Override
    public boolean typeBaseEquals(Type type1, Type type2) {
        this.assert_((TypeObject)type1);
        this.assert_((TypeObject)type2);
        return ((HjType)type1).equalsWithoutClauseImpl((HjType)type2);
    }

    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        this.assert_((TypeObject)type);
        return new HjLocalInstance_c(this, pos, flags, type, name);
    }

    public static String listToString(List l) {
        return TypeSystem_c.listToString((List)l);
    }

    protected List findAcceptableMethods(ReferenceType container, String name, List argTypes, ClassType currClass) throws SemanticException {
        this.assert_((TypeObject)container);
        this.assert_(argTypes);
        NoMemberException error = null;
        ArrayList<MethodInstance> acceptable = new ArrayList<MethodInstance>();
        ArrayList<MethodInstance> unacceptable = new ArrayList<MethodInstance>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        LinkedList<Object> typeQueue = new LinkedList<Object>();
        typeQueue.addLast(container);
        while (!typeQueue.isEmpty()) {
            Type type = (Type)typeQueue.removeFirst();
            if (visitedTypes.contains(type)) continue;
            visitedTypes.add(type);
            if (Report.should_report((String)"types", (int)2)) {
                Report.report((int)2, (String)("Searching type " + type + " for method " + name + "(" + HjTypeSystem_c.listToString(argTypes) + ")"));
            }
            if (!type.isReference()) {
                throw new SemanticException("Cannot call method in  non-reference type " + type + ".");
            }
            for (MethodInstance mi : type.toReference().methods()) {
                if (Report.should_report((String)"types", (int)3)) {
                    Report.report((int)3, (String)("Trying " + mi));
                }
                if (!mi.name().equals(name)) continue;
                if (this.methodCallValid(mi = ((HjMethodInstance)mi).instantiateForThis((HjType)container), name, argTypes)) {
                    if (this.isAccessible((MemberInstance)mi, currClass)) {
                        if (Report.should_report((String)"types", (int)3)) {
                            Report.report((int)3, (String)("->acceptable: " + mi + " in " + mi.container()));
                        }
                        acceptable.add(mi);
                        continue;
                    }
                    unacceptable.add(mi);
                    if (error != null) continue;
                    error = new NoMemberException(1, "Method " + mi.signature() + " in " + container + " is inaccessible.");
                    continue;
                }
                if (error != null) continue;
                error = new NoMemberException(1, "Method " + mi.signature() + " in " + container + " cannot be called with arguments " + "(" + HjTypeSystem_c.listToString(argTypes) + ").");
            }
            if (type.toReference().superType() != null) {
                typeQueue.addLast(type.toReference().superType());
            }
            typeQueue.addAll(type.toReference().interfaces());
        }
        if (error == null) {
            error = new NoMemberException(1, "No valid method call found for " + name + "(" + HjTypeSystem_c.listToString(argTypes) + ")" + " in " + container + ".");
        }
        if (acceptable.size() == 0) {
            throw error;
        }
        for (MethodInstance mi : unacceptable) {
            acceptable.removeAll(mi.overrides());
        }
        if (acceptable.size() == 0) {
            throw error;
        }
        return acceptable;
    }

    @Override
    public boolean equalTypeParameters(List<Type> a, List<Type> b) {
        int j;
        if (a == null || a.isEmpty()) {
            return b == null || b.isEmpty();
        }
        if (b == null || b.isEmpty()) {
            return false;
        }
        int i = a.size();
        if (i != (j = b.size())) {
            return false;
        }
        boolean result = true;
        for (int k = 0; result && k < i; ++k) {
            result = this.equals((TypeObject)a.get(k), (TypeObject)b.get(k));
        }
        return result;
    }

    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List argTypes, List excTypes) {
        this.assert_((TypeObject)container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new HjConstructorInstance_c(this, pos, container, flags, argTypes, excTypes);
    }

    @Override
    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, HjType returnType, List argTypes, List excTypes) {
        this.assert_((TypeObject)container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new HjConstructorInstance_c(this, pos, container, flags, returnType, argTypes, excTypes);
    }

    @Override
    public HjTypeObject addAnnotation(HjTypeObject o, HjClassType annoType, boolean replace) {
        ArrayList<HjClassType> newATs = new ArrayList<HjClassType>();
        if (replace) {
            for (HjClassType at : o.annotations()) {
                if (at.isSubtype(annoType.rootType())) continue;
                newATs.add(at);
            }
        } else {
            newATs.addAll(o.annotations());
        }
        newATs.add(annoType);
        return o.annotations(newATs);
    }

    @Override
    public HjClassType instantiateType(HjClassType baseType, List<Expr> args, HjNodeFactory nf) {
        TypeSystem ts = baseType.typeSystem();
        DepParameterExpr dep = (DepParameterExpr)nf.DepParameterExpr(Position.COMPILER_GENERATED, args, nf.BooleanLit(Position.COMPILER_GENERATED, true).type((Type)ts.Boolean())).type((Type)ts.Boolean());
        return (HjClassType)baseType.dep(dep);
    }

    @Override
    public PrimitiveType Complex64() {
        return this.COMPLEX_64_;
    }

    @Override
    public PrimitiveType Complex32() {
        return this.COMPLEX_32_;
    }

    @Override
    public boolean isComplex64(Type type) {
        if (type.isPrimitive()) {
            return ((HjPrimitiveType)type).isComplex64();
        }
        return false;
    }

    @Override
    public boolean isComplex32(Type type) {
        if (type.isPrimitive()) {
            return ((HjPrimitiveType)type).isComplex32();
        }
        return false;
    }

    protected PrimitiveType promoteNumeric(PrimitiveType t1, PrimitiveType t2) {
        if (this.isComplex64((Type)t1) || this.isComplex64((Type)t2)) {
            return this.Complex64();
        }
        if (this.isComplex32((Type)t1) || this.isComplex32((Type)t2)) {
            return this.Complex32();
        }
        return super.promoteNumeric(t1, t2);
    }

    public ReferenceType arrayView(Type type) {
        HjType hjType = (HjType)type;
        if (type.isBoolean()) {
            return this.booleanArray();
        }
        if (type.isChar()) {
            return this.charArray();
        }
        if (type.isByte()) {
            return this.byteArray();
        }
        if (type.isShort()) {
            return this.shortArray();
        }
        if (type.isInt()) {
            return this.intArray();
        }
        if (type.isFloat()) {
            return this.floatArray();
        }
        if (type.isDouble()) {
            return this.doubleArray();
        }
        if (type.isLong()) {
            return this.longArray();
        }
        if (hjType.isComplex32()) {
            return this.complexFloatArray();
        }
        if (hjType.isComplex64()) {
            return this.complexDoubleArray();
        }
        LinkedList<Type> list = new LinkedList<Type>();
        list.add(type);
        ClassType result = this.genericArray(list);
        return result;
    }

    @Override
    public boolean isString(Type toType) {
        return toType.equalsImpl((TypeObject)this.STRING_);
    }

    static {
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
        primitiveTypeNames.add("complex32");
        primitiveTypeNames.add("complex64");
    }
}

