/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types.constr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import polyglot.ext.hj.types.constr.C_Field;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Failure;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.types.FieldInstance;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promise_c
implements Promise,
Serializable {
    protected C_Var var;
    protected Promise value;
    protected HashMap<String, Promise> fields;
    int lookupReturnValue;

    public Promise_c(C_Var c) {
        this.value = null;
        this.var = c;
    }

    public Promise_c(C_Var var, Promise value, Map<String, Promise> fields) {
        this.var = var;
        this.value = value;
        this.fields = new HashMap<String, Promise>(fields);
    }

    @Override
    public C_Var term() {
        return this.var;
    }

    @Override
    public void setTerm(C_Var term) {
        this.var = term;
        if (this.var != null && this.fields != null) {
            for (Map.Entry<String, Promise> entry : this.fields.entrySet()) {
                String key = entry.getKey();
                Promise p = entry.getValue();
                FieldInstance f = ((C_Field)p.term()).fieldInstance();
                p.setTerm(new C_Field_c(f, term));
            }
        }
    }

    @Override
    public boolean forwarded() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return this.fields != null;
    }

    public void setVar(C_Var v) {
        this.var = v;
    }

    protected Promise_c clone() {
        Promise_c result = null;
        try {
            result = (Promise_c)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Promise cloneRecursively(HashMap<Promise, Promise> env) {
        Promise_c clone = this.clone();
        env.put(this, clone);
        if (this.value != null) {
            Promise valueClone = env.get(this.value);
            if (valueClone == null) {
                valueClone = this.value.cloneRecursively(env);
            }
            clone.value = valueClone;
        }
        if (this.fields != null) {
            HashMap<String, Promise> cloneFields = new HashMap<String, Promise>();
            for (Map.Entry<String, Promise> entry : this.fields.entrySet()) {
                String key = entry.getKey();
                Promise p = entry.getValue();
                Promise cloneP = env.get(p);
                if (cloneP == null) {
                    cloneP = p.cloneRecursively(env);
                }
                cloneFields.put(key, cloneP);
            }
            clone.fields = cloneFields;
        }
        return clone;
    }

    public int lookupReturnValue() {
        return this.lookupReturnValue;
    }

    @Override
    public Promise lookup(C_Var[] vars, int index) {
        if (this.value != null) {
            return this.value.lookup(vars, index);
        }
        if (index == vars.length) {
            this.lookupReturnValue = index;
            return this;
        }
        if (this.fields == null) {
            this.lookupReturnValue = index;
            return this;
        }
        String s = vars[index].name();
        Promise p = this.fields.get(s);
        if (p == null) {
            this.lookupReturnValue = index;
            return this;
        }
        return p.lookup(vars, index + 1);
    }

    @Override
    public Promise lookup() {
        if (this.value != null) {
            return this.value.lookup();
        }
        return this;
    }

    @Override
    public Promise lookup(String s) {
        if (this.value != null) {
            return this.value.lookup(s);
        }
        if (this.fields == null) {
            return null;
        }
        Promise p = this.fields.get(s);
        return p == null ? null : p.lookup();
    }

    @Override
    public Promise intern(C_Var[] vars, int index) {
        return this.intern(vars, index, null);
    }

    @Override
    public Promise intern(C_Var[] vars, int index, Promise last) {
        String s;
        Promise p;
        if (this.value != null) {
            return this.value.intern(vars, index, last);
        }
        if (index == vars.length) {
            return this;
        }
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        if ((p = this.fields.get(s = vars[index].name())) == null) {
            p = index == vars.length - 1 && last != null ? last : new Promise_c(vars[index]);
            this.fields.put(s, p);
        }
        return p.intern(vars, index + 1, last);
    }

    @Override
    public void addIn(String s, Promise orphan) throws Failure {
        Promise child;
        if (this.value != null) {
            throw new InternalCompilerError("The node " + this + " is forwarded to " + this.value + "; the " + s + " child, " + orphan + ", cannot be added to it.");
        }
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        if ((child = this.fields.get(s)) != null) {
            orphan.bind(child);
            return;
        }
        this.fields.put(s, orphan);
    }

    @Override
    public boolean bind(Promise target) throws Failure {
        if (this.forwarded()) {
            throw new InternalCompilerError("The promise " + this + " is already bound to " + this.value + "; cannot bind it to " + target + ".");
        }
        if (this == target) {
            return false;
        }
        if (this.canReach(target) || target.canReach(this)) {
            throw new Failure("Binding " + this + " to " + target + " creates a cycle.");
        }
        if (!this.term().prefersBeingBound() && target.term().prefersBeingBound()) {
            return target.bind(this);
        }
        this.value = target;
        if (this.fields != null) {
            for (Map.Entry<String, Promise> i : this.fields.entrySet()) {
                target.addIn(i.getKey(), i.getValue());
            }
        }
        this.fields = null;
        return true;
    }

    @Override
    public boolean canReach(Promise p) {
        if (p == this) {
            return true;
        }
        if (this.value != null) {
            return this.value.canReach(p);
        }
        if (this.fields != null) {
            for (Promise q : this.fields.values()) {
                if (!q.canReach(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dump(HashMap<C_Var, C_Var> result, C_Term prefix) {
        this.dump(result, prefix, null, null);
    }

    @Override
    public void dump(HashMap<C_Var, C_Var> result, C_Term prefix, C_Var newSelf, C_Var newThis) {
        if (this.value != null) {
            C_Var t1 = this.term();
            if (t1 == null || t1.isEQV()) {
                return;
            }
            C_Var t2 = this.value.term();
            if (prefix != null && !prefix.prefixes(t1) && !prefix.prefixes(t2)) {
                return;
            }
            if (newSelf != null) {
                t1 = t1.substitute(newSelf, C_Special.Self);
                t2 = t2.substitute(newSelf, C_Special.Self);
            }
            if (newThis != null) {
                t1 = t1.substitute(newThis, C_Special.This);
                t2 = t2.substitute(newThis, C_Special.This);
            }
            result.put(t1, t2);
            return;
        }
        if (this.fields != null) {
            Iterator<Promise> it = this.fields.values().iterator();
            while (it.hasNext()) {
                it.next().dump(result, prefix, newSelf, newThis);
            }
        }
    }

    public String toString() {
        return this.var.toString() + (this.value != null ? "-> " + this.value : (this.fields != null ? this.fields.toString() : ""));
    }

    @Override
    public void replaceDescendant(Promise y, Promise x) {
        if (this.value != null) {
            if (this.value.equals(x)) {
                this.value = y;
            } else {
                this.value.replaceDescendant(y, x);
            }
        }
        if (this.fields != null) {
            for (Map.Entry<String, Promise> p : this.fields.entrySet()) {
                String key = p.getKey();
                Promise value = p.getValue();
                if (value.equals(x)) {
                    this.fields.remove(key);
                    this.fields.put(key, y);
                    continue;
                }
                value.replaceDescendant(y, x);
            }
        }
    }

    @Override
    public Promise value() {
        return this.value;
    }

    @Override
    public HashMap<String, Promise> fields() {
        return this.fields;
    }
}

