/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types.constr;

import java.io.Serializable;
import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.Receiver;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ast.Variable;
import polyglot.ext.hj.ast.Here;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_BinaryTerm;
import polyglot.ext.hj.types.constr.C_BinaryTerm_c;
import polyglot.ext.hj.types.constr.C_Field;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Lit_c;
import polyglot.ext.hj.types.constr.C_Local;
import polyglot.ext.hj.types.constr.C_Local_c;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Type;
import polyglot.ext.hj.types.constr.C_Type_c;
import polyglot.ext.hj.types.constr.C_UnaryTerm;
import polyglot.ext.hj.types.constr.C_UnaryTerm_c;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Constraint_c;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;

public class TypeTranslator
implements Serializable {
    private final HjTypeSystem typeSystem;

    public TypeTranslator(HjTypeSystem xts) {
        this.typeSystem = xts;
    }

    public C_UnaryTerm trans(Unary t) throws SemanticException {
        return new C_UnaryTerm_c(t.operator().toString(), this.trans((Receiver)t.expr()), t.type());
    }

    public C_Field trans(Field t) throws SemanticException {
        return new C_Field_c(t, (C_Var)this.trans(t.target()));
    }

    public C_Special trans(HjSpecial t) throws SemanticException {
        return new C_Special_c(t);
    }

    public C_Local trans(LocalInstance t) throws SemanticException {
        return new C_Local_c(t);
    }

    public C_Type trans(TypeNode t) throws SemanticException {
        return new C_Type_c(t);
    }

    public C_Lit trans(Lit t) throws SemanticException {
        return new C_Lit_c(t.constantValue(), t.type());
    }

    public C_BinaryTerm trans(Binary t) throws SemanticException {
        String op = t.operator().toString();
        Expr left = t.left();
        Expr right = t.right();
        return new C_BinaryTerm_c(op, this.trans((Receiver)left), this.trans((Receiver)right), t.type());
    }

    public C_Var trans(Variable term) throws SemanticException {
        if (term instanceof Field) {
            return this.trans((Field)term);
        }
        if (term instanceof HjSpecial) {
            return this.trans((HjSpecial)term);
        }
        if (term instanceof Local) {
            LocalInstance li = ((Local)term).localInstance();
            return this.trans(li);
        }
        throw new SemanticException("Cannot translate term |" + term + "| into a constraint." + "It must be a field, special or local.");
    }

    public C_Term trans(Receiver term) throws SemanticException {
        if (term == null) {
            return null;
        }
        if (term instanceof Lit) {
            return this.trans((Lit)term);
        }
        if (term instanceof Here) {
            return ((HjTypeSystem)term.type().typeSystem()).here();
        }
        if (term instanceof Variable) {
            return this.trans((Variable)term);
        }
        if (term instanceof HjSpecial) {
            return this.trans((HjSpecial)term);
        }
        if (term instanceof Unary) {
            Unary u = (Unary)term;
            Expr t2 = u.expr();
            TypeSystem ts = t2.type().typeSystem();
            Unary.Operator op = u.operator();
            if (op.equals((Object)Unary.POS)) {
                return this.trans((Receiver)t2);
            }
            if (op.equals((Object)Unary.NEG) && t2 instanceof Lit) {
                return this.trans((Lit)t2).neg();
            }
            if (op.equals((Object)Unary.NOT) && t2 instanceof Lit && ts.typeEquals(t2.type(), (Type)ts.Boolean())) {
                return this.trans((Lit)t2).not();
            }
            return this.trans((Unary)term);
        }
        if (term instanceof Binary) {
            return this.trans((Binary)term);
        }
        if (term instanceof TypeNode) {
            return this.trans((TypeNode)term);
        }
        throw new SemanticException("Cannot translate |" + term + "|(" + term.getClass().getName() + ")" + " to a term.");
    }

    public Constraint constraint(Binary term, Constraint c) throws SemanticException {
        String op = term.operator().toString();
        Expr left = term.left();
        Expr right = term.right();
        if (op.equals("==")) {
            if (left instanceof Variable) {
                return c.addBinding(this.trans((Variable)left), (C_Var)this.trans((Receiver)right));
            }
            if (left instanceof HjSpecial) {
                HjSpecial s = (HjSpecial)left;
                if (!s.kind().toString().equals("self")) {
                    throw new SemanticException("Cannot constrain this.");
                }
                return c.addBinding(this.trans(s), (C_Var)this.trans((Receiver)right));
            }
            if (right instanceof Variable) {
                return c.addBinding(this.trans((Variable)right), (C_Var)this.trans((Receiver)left));
            }
            if (right instanceof HjSpecial) {
                HjSpecial s = (HjSpecial)right;
                if (!s.kind().toString().equals("self")) {
                    throw new SemanticException("Cannot constrain this.");
                }
                return c.addBinding(this.trans(s), (C_Var)this.trans((Receiver)left));
            }
        }
        if (op.equals("&&")) {
            c = this.constraint(left, c);
            c = this.constraint(right, c);
            return c;
        }
        throw new SemanticException("Cannot translate term |" + term + "| into a constraint." + "It must be a conjunction of equalities.");
    }

    public Constraint constraint(Expr term, Constraint c) throws SemanticException {
        if (term == null) {
            return c;
        }
        HjTypeSystem ts = (HjTypeSystem)term.type().typeSystem();
        if (!ts.typeEquals(term.type(), (Type)ts.Boolean())) {
            throw new SemanticException("Cannot build constraint from expression |" + term + "| of type " + term.type() + " (not Boolean).");
        }
        if (term instanceof Binary) {
            return this.constraint((Binary)term, c);
        }
        C_Var t = (C_Var)this.trans((Receiver)term);
        c.addTerm(t);
        return c;
    }

    public Constraint constraint(Expr e) throws SemanticException {
        Constraint_c c = new Constraint_c(this.typeSystem);
        return this.constraint(e, (Constraint)c);
    }

    public static C_Term translate(Receiver r, HjTypeSystem xts) throws SemanticException {
        return new TypeTranslator(xts).trans(r);
    }

    public static boolean isPureTerm(Term t) {
        boolean result = false;
        if (t instanceof Variable) {
            Variable v = (Variable)t;
            result = v.flags().isFinal();
        }
        return result;
    }
}

