/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.CodeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.AssignPropertyBody;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class AssignPropertyChecker
extends DataFlow {
    ConstructorDecl cd;
    DataFlowItem[][] cache = new DataFlowItem[4][4];

    public AssignPropertyChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false);
    }

    protected FlowGraph initGraph(CodeNode code, Term root) {
        if (code instanceof ConstructorDecl) {
            HjType xt;
            HjConstructorInstance xci;
            ConstructorDecl d;
            this.cd = d = (ConstructorDecl)code;
            if (d.constructorInstance() instanceof HjConstructorInstance && (xci = (HjConstructorInstance)d.constructorInstance()).container() instanceof HjType && !(xt = (HjType)xci.container()).definedProperties().isEmpty()) {
                return super.initGraph(code, root);
            }
        }
        return null;
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        return this.createItem(0, 0);
    }

    public boolean needsProperty() {
        HjConstructorInstance xci = (HjConstructorInstance)this.cd.constructorInstance();
        HjType xt = (HjType)xci.container();
        return xt.isConstrained() || xci.returnType().isConstrained();
    }

    public DataFlowItem increment(DataFlowItem in) {
        int min = in != null && (in.min == 1 || in.min == 2) ? 2 : 1;
        int max = in != null && (in.max == 1 || in.max == 2) ? 2 : 1;
        return this.createItem(min, max);
    }

    protected DataFlowItem createItem(int min, int max) {
        DataFlowItem i = this.cache[min][max];
        if (i == null) {
            this.cache[min][max] = i = new DataFlowItem(min, max);
        }
        return i;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term n, boolean entry, Set succEdgeKeys) {
        ConstructorCall cc;
        if (entry) {
            return AssignPropertyChecker.itemToMap((DataFlow.Item)in, (Set)succEdgeKeys);
        }
        DataFlowItem inItem = (DataFlowItem)in;
        if (n instanceof Return) {
            return AssignPropertyChecker.itemToMap((DataFlow.Item)this.createItem(0, 0), (Set)succEdgeKeys);
        }
        if (graph.exitPeers().contains(n)) {
            if (this.needsProperty()) {
                Map m = AssignPropertyChecker.itemToMap((DataFlow.Item)this.createItem(3, 3), (Set)succEdgeKeys);
                if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
                    m.put(FlowGraph.EDGE_KEY_OTHER, this.createItem(0, 0));
                }
                if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
                    m.put(FlowGraph.EDGE_KEY_TRUE, this.createItem(0, 0));
                }
                if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
                    m.put(FlowGraph.EDGE_KEY_FALSE, this.createItem(0, 0));
                }
                return m;
            }
            return AssignPropertyChecker.itemToMap((DataFlow.Item)this.createItem(0, 0), (Set)succEdgeKeys);
        }
        if (n instanceof AssignPropertyBody) {
            return AssignPropertyChecker.itemToMap((DataFlow.Item)this.increment(inItem), (Set)succEdgeKeys);
        }
        if (n instanceof ConstructorCall && (cc = (ConstructorCall)n).kind() == ConstructorCall.THIS) {
            return AssignPropertyChecker.itemToMap((DataFlow.Item)this.increment(inItem), (Set)succEdgeKeys);
        }
        return AssignPropertyChecker.itemToMap((DataFlow.Item)in, (Set)succEdgeKeys);
    }

    protected DataFlow.Item confluence(List items, Term node, boolean entry, FlowGraph graph) {
        int min = 3;
        int max = 3;
        for (DataFlowItem dfi : items) {
            if (min == 3 || dfi.min != 3 && dfi.min < min) {
                min = dfi.min;
            }
            if (max != 3 && (dfi.max == 3 || dfi.max <= max)) continue;
            max = dfi.max;
        }
        return this.createItem(min, max);
    }

    public void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        if (entry) {
            return;
        }
        if (graph.entryPeers().contains(n)) {
            DataFlowItem outItem;
            if (outItems != null && !outItems.isEmpty() && (outItem = (DataFlowItem)((Object)outItems.values().iterator().next())) != null) {
                if (outItem.max == 2) {
                    throw new SemanticException("The constructor may have initialized properties more than once.  There is a path with more than one property(...) statement or this(...) call.", this.cd.position());
                }
                if (!this.needsProperty() || outItem.min != 0) {
                    return;
                }
            }
            throw new SemanticException("The constructor incorrectly initializes properties.  There is a path without a property(...) statement or this(...) call.", this.cd.position());
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        public final int min;
        public final int max;
        public static final int ZERO = 0;
        public static final int ONE = 1;
        public static final int MANY = 2;
        public static final int DONT_CARE = 3;

        protected DataFlowItem(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "propertyAssignCount=" + this.min + ".." + this.max;
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                DataFlowItem i = (DataFlowItem)((Object)o);
                return this.min == i.min && this.max == i.max;
            }
            return false;
        }

        public int hashCode() {
            return Integer.valueOf(this.min).hashCode() + Integer.valueOf(this.max << 2).hashCode();
        }
    }
}

