/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.LocalAssign;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.Atomic;
import polyglot.visit.NodeVisitor;

public class AtomicElimination
extends NodeVisitor {
    private final boolean DEBUG_ = false;

    public Node leave(Node old, Node n, NodeVisitor v) {
        Atomic as;
        Stmt as_body;
        Stmt simple_stmt;
        Node ret = n;
        if (n instanceof Atomic && (simple_stmt = this.checkIfSimpleBlock_(as_body = (as = (Atomic)n).body())) != null && this.isOptimizableStmt_(simple_stmt)) {
            ret = simple_stmt;
        }
        return ret;
    }

    private Stmt checkIfSimpleBlock_(Stmt s) {
        Stmt the_one_stmt = null;
        if (s instanceof Block) {
            Block b = (Block)s;
            List l = b.statements();
            if (l.size() == 1) {
                the_one_stmt = (Stmt)l.get(0);
            }
        } else {
            the_one_stmt = s;
        }
        return the_one_stmt;
    }

    private boolean isOptimizableStmt_(Stmt s) {
        Eval e;
        Expr e_expr;
        boolean ret = false;
        if (s instanceof Eval && ((e_expr = (e = (Eval)s).expr()) instanceof ArrayAccessAssign || e_expr instanceof FieldAssign || e_expr instanceof LocalAssign)) {
            Assign a = (Assign)e_expr;
            ret = this.numFieldRefs_(a.left()) == 0 && this.numFieldRefs_(a.right()) <= 1;
        }
        return ret;
    }

    private int numFieldRefs_(Expr e) {
        final Ctr c = new Ctr();
        e.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof Field || n instanceof ArrayAccess || n instanceof ArrayAccessAssign || n instanceof FieldAssign) {
                    ++c.ctr;
                } else if (n instanceof ProcedureCall || n instanceof New || n instanceof NewArray) {
                    c.ctr += 2;
                }
                return n;
            }
        });
        return c.ctr;
    }

    private class Ctr {
        int ctr;

        private Ctr() {
        }
    }
}

