/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import polyglot.ast.Call;
import polyglot.ast.ClassDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjMLSourceFile;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class HjMLVerifier
extends ContextVisitor {
    public HjMLVerifier(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Call f;
        ClassDecl fd;
        Expr e;
        TypeNode tn;
        if (n.position() == null) {
            n = n.position(Position.COMPILER_GENERATED);
        }
        if (n instanceof SourceFile) {
            if (!(n instanceof HjMLSourceFile)) {
                throw new InternalCompilerError("Non-XML file loaded via XML parser.", n.position());
            }
            return n;
        }
        if (n instanceof TypeNode && ((tn = (TypeNode)n).type() == null || !tn.type().isCanonical())) {
            throw new SemanticException("Missing or invalid type " + tn, n.position());
        }
        if (n instanceof Expr && ((e = (Expr)n).type() == null || !e.type().isCanonical())) {
            throw new SemanticException("Missing or invalid type for expression " + e, n.position());
        }
        if (n instanceof ClassDecl && ((fd = (ClassDecl)n).type() == null || !fd.type().isCanonical())) {
            throw new SemanticException("Missing type for class declaration " + fd, n.position());
        }
        if (n instanceof Call && ((f = (Call)n).methodInstance() == null || !f.methodInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid MethodInstance for call " + f, n.position());
        }
        if (n instanceof FieldDecl && ((fd = (FieldDecl)n).fieldInstance() == null || !fd.fieldInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid FieldInstance for declaration " + fd, n.position());
        }
        if (n instanceof Field && ((f = (Field)n).fieldInstance() == null || !f.fieldInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid FieldInstance for field access " + f, n.position());
        }
        if (n instanceof MethodDecl && ((fd = (MethodDecl)n).methodInstance() == null || !fd.methodInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid MethodInstance for declaration " + fd, n.position());
        }
        if (n instanceof Call && ((f = (Call)n).methodInstance() == null || !f.methodInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid MethodInstance for call " + f, n.position());
        }
        if (n instanceof ConstructorDecl && ((fd = (ConstructorDecl)n).constructorInstance() == null || !fd.constructorInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid ConstructorInstance for declaration " + fd, n.position());
        }
        if (n instanceof ConstructorCall && ((f = (ConstructorCall)n).constructorInstance() == null || !f.constructorInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid ConstructorInstance for constructor call " + f, n.position());
        }
        if (n instanceof New && ((f = (New)n).constructorInstance() == null || !f.constructorInstance().isCanonical())) {
            throw new SemanticException("Missing or invalid ConstructorInstance for new expression " + f, n.position());
        }
        return n;
    }
}

