/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.hj.visit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.objinl.hj.visit.HjPointInlineSafetyAnalyzer;
import polyglot.objinl.hj.visit.HjPointInliner;
import polyglot.objinl.hj.visit.HjPointRankTypeAnalyzer;
import polyglot.objinl.util.TreeUtils;
import polyglot.types.VarInstance;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPointInlineCleanup
extends NodeVisitor {
    HjNodeFactory nf;
    HjTypeSystem ts;

    public HjPointInlineCleanup(HjNodeFactory nf, HjTypeSystem ts) {
        this.nf = nf;
        this.ts = ts;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof Return) {
            Return ret = (Return)n;
            Expr possiblePointReconstExpr = this.performedInlPointReconstruction(ret.expr());
            ret = ret.expr(possiblePointReconstExpr);
            return ret;
        }
        if (n instanceof Binary) {
            Binary binary = (Binary)n;
            Expr possiblePointReconstExpr = this.performedInlPointReconstruction((Expr)binary);
            return possiblePointReconstExpr;
        }
        if (n instanceof Call) {
            Call c = (Call)n;
            LinkedList<Expr> possiblePointReconstArgs = this.reconstructInlPointArgs(c.arguments());
            c = (Call)c.arguments(possiblePointReconstArgs);
            return c;
        }
        if (n instanceof ConstructorCall) {
            ConstructorCall cc = (ConstructorCall)n;
            LinkedList<Expr> possiblePointReconstArgs = this.reconstructInlPointArgs(cc.arguments());
            cc = (ConstructorCall)cc.arguments(possiblePointReconstArgs);
            return cc;
        }
        return n;
    }

    private Expr performedInlPointReconstruction(Expr expr) {
        if (expr instanceof Binary) {
            Binary binary = (Binary)expr;
            binary = binary.left(this.performedInlPointReconstruction(binary.left()));
            binary = binary.right(this.performedInlPointReconstruction(binary.right()));
            return binary;
        }
        Expr replaceExpr = this.reconstructionInlPoint(expr);
        return replaceExpr;
    }

    private Return reconstructInlPointRet(Return ret) {
        VarInstance[] inlPoint;
        Expr retExpr = ret.expr();
        VarInstance retExprInst = TreeUtils.getVarInstance((Node)retExpr);
        if (retExprInst != null && (inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(retExprInst)) != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(retExprInst)) {
            Expr reconstructPt = HjPointInliner.rebuildPoint(inlPoint, retExpr, this.nf, this.ts);
            if (reconstructPt.equals(retExpr) && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(retExprInst)) {
                HjPointInlineSafetyAnalyzer.unSafePointsToInline.add(retExprInst);
            }
            ret = ret.expr(reconstructPt);
        }
        return ret;
    }

    private LinkedList<Expr> reconstructInlPointArgs(List<Expr> args) {
        Iterator<Expr> argsIt = args.iterator();
        LinkedList<Expr> newArgs = new LinkedList<Expr>();
        while (argsIt.hasNext()) {
            Expr currArg = argsIt.next();
            newArgs.add(this.reconstructionInlPoint(currArg));
        }
        return newArgs;
    }

    private Expr reconstructionInlPoint(Expr expr) {
        VarInstance[] inlPoint;
        VarInstance vi = TreeUtils.getVarInstance((Node)expr);
        if (vi != null && (inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(vi)) != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(vi)) {
            Expr reconstructPt = HjPointInliner.rebuildPoint(inlPoint, expr, this.nf, this.ts);
            if (reconstructPt.equals(expr)) {
                HjPointInlineSafetyAnalyzer.unSafePointsToInline.add(vi);
            }
            return reconstructPt;
        }
        return expr;
    }
}

