/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.hj.visit;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.ArrayConstructor;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.ConstantDistMaker;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjCall_c;
import polyglot.ext.hj.ast.HjLoop;
import polyglot.ext.hj.ast.ParExpr;
import polyglot.ext.hj.ast.RectRegionMaker;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.frontend.goals.Goal;
import polyglot.objinl.hj.visit.HjPointRankTypeAnalyzer;
import polyglot.objinl.util.TreeUtils;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPointInlineSafetyAnalyzer
extends NodeVisitor {
    public static LinkedList<VarInstance> unSafePointsToInline = new LinkedList();
    public static LinkedList<VarInstance> unSafePointAssociates = new LinkedList();
    public static boolean ranAllJobs = false;
    public static boolean rerun = false;
    Job job;
    Collection jobs;
    ExtensionInfo.HjScheduler sched;
    HjTypeSystem ts;

    public HjPointInlineSafetyAnalyzer(Job job, Collection jobs, HjTypeSystem ts, ExtensionInfo.HjScheduler sched) {
        this.job = job;
        this.jobs = jobs;
        this.ts = ts;
        this.sched = sched;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof SourceFile) {
            this.runAllJobsPass();
        }
        if (n instanceof ProcedureDecl) {
            ProcedureDecl pd = (ProcedureDecl)n;
            this.checkForUnsafePointFormalParams(pd.formals());
            return n;
        }
        if (n instanceof Closure) {
            Closure cl = (Closure)n;
            this.checkForUnsafePointFormalParams(cl.formals());
            return n;
        }
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            this.declHelper((VarInstance)ld.localInstance(), ld.init());
            return n;
        }
        if (n instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)n;
            this.declHelper((VarInstance)fd.fieldInstance(), fd.init());
            return n;
        }
        if (n instanceof Assign) {
            Assign assign = (Assign)n;
            Type type = assign.type();
            if (this.ts.isPoint(type)) {
                this.checkForUnsafePointAssign(assign);
            } else if (this.ts.isRegion(type)) {
                this.checkForUnsafeRegionAssign(assign);
            } else if (this.ts.isDistribution(type)) {
                this.checkForUnsafeDistAssign(assign);
            } else if (this.ts.isHjArrayView(type)) {
                this.checkForUnsafeHjArrayAssign(assign);
            }
            return n;
        }
        if (n instanceof HjArrayAccess1) {
            HjArrayAccess1 xaa1 = (HjArrayAccess1)n;
            this.checkForUnsafePointAccess(xaa1);
            return n;
        }
        if (n instanceof HjLoop) {
            HjLoop loop = (HjLoop)n;
            this.checkForUnsafePointDeclInHjLoopHeader((VarInstance)loop.formal().localInstance(), loop.domain());
            return n;
        }
        return n;
    }

    private void declHelper(VarInstance varInst, Expr init) {
        Type type = varInst.type();
        if (this.ts.isPoint(type)) {
            this.checkForUnsafePointDecl(varInst, init);
        } else if (this.ts.isRegion(type)) {
            this.checkForUnsafeRegionDecl(varInst, init);
        } else if (this.ts.isDistribution(type)) {
            this.checkForUnsafeDistDecl(varInst, init);
        } else if (this.ts.isHjArrayView(type)) {
            this.checkForUnsafeHjArrayDecl(varInst, init);
        }
    }

    private void checkForUnsafePointFormalParams(List<Formal> formals) {
        Iterator<Formal> formalsIt = formals.iterator();
        while (formalsIt.hasNext()) {
            LocalInstance li = formalsIt.next().localInstance();
            VarInstance[] inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(li);
            if (inlPoint == null || unSafePointsToInline.contains(li)) continue;
            unSafePointsToInline.add((VarInstance)li);
            rerun = true;
        }
    }

    private void checkForUnsafePointAccess(HjArrayAccess1 xaa1) {
        Expr array = xaa1.array();
        Expr index = xaa1.index();
        VarInstance arrayInst = TreeUtils.getVarInstance((Node)array);
        if (arrayInst != null && HjPointRankTypeAnalyzer.pointToIndicesMap.get(arrayInst) != null && !(index instanceof IntLit) && !unSafePointsToInline.contains(arrayInst)) {
            unSafePointsToInline.add(arrayInst);
            rerun = true;
        }
    }

    private void checkForUnsafePointDecl(VarInstance ptInst, Expr init) {
        if (this.safePoint(ptInst) && this.safePoint(init) && this.notPointWithMultRanks(ptInst, init)) {
            return;
        }
        this.markInlPointsUnSafe(ptInst);
        this.markInlPointsUnSafe(init);
    }

    private void checkForUnsafePointDeclInHjLoopHeader(VarInstance ptInst, Expr domain) {
        VarInstance[] inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(ptInst);
        Integer numDims = HjPointRankTypeAnalyzer.findRegionRank(ptInst, TreeUtils.getVarInstance((Node)domain), (Receiver)domain, this.ts);
        if (this.safePoint(ptInst) && this.safePointAssoc(this.getDomainVarInst((Receiver)domain)) && numDims != null && numDims == inlPoint.length) {
            return;
        }
        this.markInlPointsUnSafe(ptInst);
        this.markUnSafePointAssocs(domain);
    }

    private void checkForUnsafeRegionDecl(VarInstance regInst, Expr init) {
        if (this.safePointAssoc(regInst) && this.safeRegion(init) && this.notRegionDistOrHjArrayWithMultRanks(regInst, init)) {
            return;
        }
        this.markUnSafePointAssocs(regInst);
        this.markUnSafePointAssocs(init);
    }

    private void checkForUnsafeDistDecl(VarInstance distInst, Expr init) {
        if (this.safePointAssoc(distInst) && this.safeDist(init, false) && this.notRegionDistOrHjArrayWithMultRanks(distInst, init)) {
            return;
        }
        this.markUnSafePointAssocs(distInst);
        this.markUnSafePointAssocs(init);
    }

    private void checkForUnsafeHjArrayDecl(VarInstance arrayInst, Expr init) {
        if (this.safePointAssoc(arrayInst) && this.safeArray(init) && this.notRegionDistOrHjArrayWithMultRanks(arrayInst, init)) {
            return;
        }
        this.markUnSafePointAssocs(arrayInst);
        this.markUnSafePointAssocs(init);
    }

    private boolean safeDist(Expr distExpr, boolean fromArrayConstr) {
        while (distExpr instanceof ParExpr) {
            distExpr = ((ParExpr)distExpr).expr();
        }
        if (distExpr instanceof ConstantDistMaker) {
            ConstantDistMaker cdm = (ConstantDistMaker)distExpr;
            Expr regArg = (Expr)cdm.arguments().get(0);
            return this.safeRegion(regArg);
        }
        if (distExpr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjConstDistConstr((HjCall_c)distExpr, this.ts)) {
            HjCall_c dc = (HjCall_c)distExpr;
            Expr regArg = (Expr)dc.arguments().get(0);
            return this.safeRegion(regArg);
        }
        if (distExpr instanceof Local || distExpr instanceof Field) {
            VarInstance distInst = TreeUtils.getVarInstance((Node)distExpr);
            return this.safePointAssoc(distInst);
        }
        if (fromArrayConstr && distExpr instanceof Call) {
            Call call = (Call)distExpr;
            return this.safeRegion((Expr)call.target());
        }
        return false;
    }

    private boolean safeArray(Expr arrExpr) {
        while (arrExpr instanceof ParExpr) {
            arrExpr = ((ParExpr)arrExpr).expr();
        }
        if (arrExpr instanceof ArrayConstructor) {
            ArrayConstructor ac = (ArrayConstructor)arrExpr;
            Expr distExpr = ac.distribution();
            return this.safeDist(distExpr, true);
        }
        if (arrExpr instanceof Local || arrExpr instanceof Field) {
            VarInstance arrInst = TreeUtils.getVarInstance((Node)arrExpr);
            return this.safePointAssoc(arrInst);
        }
        return false;
    }

    private boolean safeRegion(Expr regExpr) {
        while (regExpr instanceof ParExpr) {
            regExpr = ((ParExpr)regExpr).expr();
        }
        if (regExpr instanceof RectRegionMaker) {
            return true;
        }
        if (regExpr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjRectRegionConstr((HjCall_c)regExpr, this.ts)) {
            HjCall_c regConstr = (HjCall_c)regExpr;
            boolean regArgsSafe = true;
            for (Object currArg : regConstr.arguments()) {
                if (currArg instanceof IntLit) {
                    return true;
                }
                regArgsSafe = regArgsSafe && this.safeRegion((Expr)currArg);
            }
            return regArgsSafe;
        }
        if (regExpr instanceof Local || regExpr instanceof Field) {
            VarInstance regInst = TreeUtils.getVarInstance((Node)regExpr);
            return this.safePointAssoc(regInst);
        }
        return false;
    }

    private boolean safePointAssoc(VarInstance vi) {
        boolean hasRank = this.hasRank(vi);
        return hasRank & !unSafePointAssociates.contains(vi);
    }

    private VarInstance getDomainVarInst(Receiver receiver) {
        VarInstance vi = TreeUtils.getVarInstance((Node)receiver);
        if (this.hasRank(vi)) {
            return vi;
        }
        if (receiver instanceof Field) {
            return this.getDomainVarInst(((Field)receiver).target());
        }
        if (receiver instanceof Call) {
            return this.getDomainVarInst(((Call)receiver).target());
        }
        return vi;
    }

    private boolean hasRank(VarInstance vi) {
        return vi != null && (HjPointRankTypeAnalyzer.regionToRangesMap.get(vi) != null || HjPointRankTypeAnalyzer.distToRegionMap.get(vi) != null || HjPointRankTypeAnalyzer.arrayToRegionMap.get(vi) != null);
    }

    private void markUnSafePointAssocs(Expr expr) {
        while (expr instanceof ParExpr) {
            expr = ((ParExpr)expr).expr();
        }
        if (expr instanceof Local || expr instanceof Field) {
            VarInstance vi = TreeUtils.getVarInstance((Node)expr);
            this.markUnSafePointAssocs(vi);
        }
    }

    private void markUnSafePointAssocs(VarInstance vi) {
        if (!unSafePointAssociates.contains(vi)) {
            unSafePointAssociates.add(vi);
            rerun = true;
        }
    }

    private void checkForUnsafePointAssign(Assign assign) {
        Expr left = assign.left();
        Expr right = assign.right();
        if (this.safePoint(left) && this.safePoint(right) && this.notPointWithMultRanks(TreeUtils.getVarInstance((Node)left), right)) {
            return;
        }
        this.markInlPointsUnSafe(left);
        this.markInlPointsUnSafe(right);
    }

    private void checkForUnsafeRegionAssign(Assign assign) {
        Expr left = assign.left();
        Expr right = assign.right();
        if (this.safeRegion(left) && this.safeRegion(right) && this.notRegionDistOrHjArrayWithMultRanks(TreeUtils.getVarInstance((Node)left), right)) {
            return;
        }
        this.markUnSafePointAssocs(left);
        this.markUnSafePointAssocs(right);
    }

    private void checkForUnsafeDistAssign(Assign assign) {
        Expr left = assign.left();
        Expr right = assign.right();
        if (this.safeDist(left, false) && this.safeDist(right, false) && this.notRegionDistOrHjArrayWithMultRanks(TreeUtils.getVarInstance((Node)left), right)) {
            return;
        }
        this.markUnSafePointAssocs(left);
        this.markUnSafePointAssocs(right);
    }

    private void checkForUnsafeHjArrayAssign(Assign assign) {
        Expr left = assign.left();
        Expr right = assign.right();
        if (this.safeArray(left) && this.safeArray(right) && this.notRegionDistOrHjArrayWithMultRanks(TreeUtils.getVarInstance((Node)left), right)) {
            return;
        }
        this.markUnSafePointAssocs(left);
        this.markUnSafePointAssocs(right);
    }

    private boolean safePoint(Expr ptExpr) {
        while (ptExpr instanceof ParExpr) {
            ptExpr = ((ParExpr)ptExpr).expr();
        }
        if (ptExpr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjPointConstr((HjCall_c)ptExpr, this.ts)) {
            return true;
        }
        if (ptExpr instanceof Local || ptExpr instanceof Field) {
            VarInstance ptInst = TreeUtils.getVarInstance((Node)ptExpr);
            return this.safePoint(ptInst);
        }
        if (ptExpr instanceof Binary) {
            Binary binary = (Binary)ptExpr;
            return this.safePoint(binary.left()) && this.safePoint(binary.right());
        }
        return false;
    }

    private boolean safePoint(VarInstance ptInst) {
        VarInstance[] inlPoint = null;
        if (ptInst != null) {
            inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(ptInst);
        }
        return inlPoint != null && !unSafePointsToInline.contains(ptInst);
    }

    private boolean notPointWithMultRanks(VarInstance vi, Expr expr) {
        VarInstance[] inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(vi);
        Integer numDims = HjPointRankTypeAnalyzer.getPointNumDims(expr, this.ts);
        return numDims != null && numDims == inlPoint.length;
    }

    private boolean notRegionDistOrHjArrayWithMultRanks(VarInstance vi, Expr expr) {
        Integer numDims1 = HjPointRankTypeAnalyzer.findRegionRank(vi, vi, null, this.ts);
        Integer numDims2 = HjPointRankTypeAnalyzer.findRegionRank(vi, TreeUtils.getVarInstance((Node)expr), (Receiver)expr, this.ts);
        return numDims1 != null && numDims2 != null && numDims1.equals(numDims2);
    }

    private void markInlPointsUnSafe(Expr ptExpr) {
        while (ptExpr instanceof ParExpr) {
            ptExpr = ((ParExpr)ptExpr).expr();
        }
        if (ptExpr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjPointConstr((HjCall_c)ptExpr, this.ts)) {
            return;
        }
        if (ptExpr instanceof Local || ptExpr instanceof Field) {
            VarInstance ptInst = TreeUtils.getVarInstance((Node)ptExpr);
            this.markInlPointsUnSafe(ptInst);
        }
        if (ptExpr instanceof Binary) {
            Binary binary = (Binary)ptExpr;
            this.markInlPointsUnSafe(binary.left());
            this.markInlPointsUnSafe(binary.right());
        }
    }

    private void markInlPointsUnSafe(VarInstance ptInst) {
        VarInstance[] inlPoint = null;
        if (ptInst != null) {
            inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(ptInst);
        }
        if (inlPoint != null && !unSafePointsToInline.contains(ptInst)) {
            unSafePointsToInline.add(ptInst);
            rerun = true;
        }
    }

    private void runAllJobsPass() {
        if (!ranAllJobs) {
            ranAllJobs = true;
            do {
                rerun = false;
                for (Job j : this.jobs) {
                    if (j.equals((Object)this.job)) continue;
                    Goal goal = this.sched.HjPointInlineSafetyAnalyzed(j);
                    goal.setState(0);
                    this.sched.attemptGoal(goal);
                }
            } while (rerun);
            Iterator unsafePointsIt = unSafePointsToInline.iterator();
            while (unsafePointsIt.hasNext()) {
                HjPointRankTypeAnalyzer.pointToIndicesMap.remove(unsafePointsIt.next());
            }
        }
    }
}

