/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.hj.visit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Id;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjArrayAccess1Assign;
import polyglot.ext.hj.ast.HjArrayAccessAssign;
import polyglot.ext.hj.ast.HjCall_c;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.HjNodeFactory_c;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.objinl.hj.visit.HjPointInlineSafetyAnalyzer;
import polyglot.objinl.hj.visit.HjPointRankTypeAnalyzer;
import polyglot.objinl.util.TreeUtils;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.VarInstance;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPointInliner
extends NodeVisitor {
    HjTypeSystem ts;
    HjNodeFactory nf;

    public HjPointInliner(HjTypeSystem ts, HjNodeFactory nf) {
        this.ts = ts;
        this.nf = nf;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof ClassBody) {
            ClassBody cb = (ClassBody)n;
            Iterator membersIt = cb.members().iterator();
            LinkedList<ClassMember> inlinedMembersList = new LinkedList<ClassMember>();
            while (membersIt.hasNext()) {
                inlinedMembersList.addAll(this.inlineClassMember((ClassMember)membersIt.next()));
            }
            cb = cb.members(inlinedMembersList);
            return cb;
        }
        if (n instanceof Block) {
            Block block = (Block)n;
            Iterator stmtsIt = block.statements().iterator();
            LinkedList<Stmt> inlinedStmtsList = new LinkedList<Stmt>();
            while (stmtsIt.hasNext()) {
                inlinedStmtsList.addAll(this.inlineStmt((Stmt)stmtsIt.next()));
            }
            block = block.statements(inlinedStmtsList);
            return block;
        }
        if (n instanceof HjArrayAccess1Assign) {
            n = this.transformHjArrayAccess1Assign((HjArrayAccess1Assign)n);
            return n;
        }
        if (n instanceof HjArrayAccess1) {
            n = this.transformHjArrayAccess1((HjArrayAccess1)n);
            return n;
        }
        return n;
    }

    private List<ClassMember> inlineClassMember(ClassMember cm) {
        FieldInstance[] globalInlPoint;
        List<FieldDecl> inlGlobalPoint;
        FieldDecl fd;
        LinkedList<ClassMember> inlMems = new LinkedList<ClassMember>();
        if (cm instanceof FieldDecl && this.ts.isPoint((fd = (FieldDecl)cm).declType()) && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(fd.fieldInstance()) && (inlGlobalPoint = HjPointInliner.createFieldInlPointDecl(this.nf, this.ts, globalInlPoint = (FieldInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(fd.fieldInstance()), fd.init())) != null) {
            inlMems.addAll(inlGlobalPoint);
            return inlMems;
        }
        inlMems.add(cm);
        return inlMems;
    }

    private List<Stmt> inlineStmt(Stmt s) {
        LinkedList<Stmt> inlStmt = new LinkedList<Stmt>();
        if (s instanceof LocalDecl) {
            LocalInstance[] localInlPoint;
            List<LocalDecl> inlLocPoint;
            LocalDecl ld = (LocalDecl)s;
            if (this.ts.isPoint(ld.declType()) && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(ld.localInstance()) && (inlLocPoint = HjPointInliner.createLocalInlPointDecl(this.nf, this.ts, localInlPoint = (LocalInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(ld.localInstance()), ld.init())) != null) {
                inlStmt.addAll(inlLocPoint);
                return inlStmt;
            }
        } else if (s instanceof Eval && ((Eval)s).expr() instanceof Assign) {
            Assign assign = (Assign)((Eval)s).expr();
            VarInstance leftVarInst = TreeUtils.getVarInstance((Node)assign.left());
            if (this.ts.isPoint(assign.left().type()) && leftVarInst != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(leftVarInst)) {
                List<Expr> lhsInlPoint = HjPointInliner.inlPointExpr(assign.left(), this.nf, this.ts);
                List<Expr> rhsInlPoint = HjPointInliner.inlPointExpr(assign.right(), this.nf, this.ts);
                if (lhsInlPoint != null && rhsInlPoint != null) {
                    for (int i = 0; i < lhsInlPoint.size(); ++i) {
                        Assign inlAssign = this.createInlAssign(assign.position(), lhsInlPoint.get(i), rhsInlPoint.get(i));
                        Eval inlEval = this.nf.Eval(s.position(), (Expr)inlAssign);
                        inlStmt.add((Stmt)inlEval);
                    }
                    return inlStmt;
                }
            }
        }
        inlStmt.add(s);
        return inlStmt;
    }

    public static Expr rebuildPoint(VarInstance[] inlPoint, Expr currArg, HjNodeFactory nf, HjTypeSystem ts) {
        Integer rank = new Integer(inlPoint.length);
        HjCall_c pointConstr = HjPointRankTypeAnalyzer.pointConstrMap.get(rank);
        if (pointConstr == null) {
            return currArg;
        }
        LinkedList inlPointIndices = null;
        if (inlPoint instanceof LocalInstance[]) {
            inlPointIndices = HjPointInliner.createLocalInlPointRef(nf, (LocalInstance[])inlPoint);
        } else if (inlPoint instanceof FieldInstance[]) {
            inlPointIndices = HjPointInliner.createFieldInlPointRef(nf, (FieldInstance[])inlPoint, ((Field)currArg).target());
        }
        if (inlPointIndices != null) {
            pointConstr = (HjCall_c)pointConstr.arguments(inlPointIndices);
            return pointConstr;
        }
        return currArg;
    }

    private Assign createInlAssign(Position pos, Expr lhs, Expr rhs) {
        Assign assign = this.nf.Assign(pos, lhs, Assign.ASSIGN, rhs);
        assign = (Assign)assign.type(rhs.type());
        return assign;
    }

    public static LinkedList optInlBinaryPointOperation(Binary pointOp, HjNodeFactory nf, HjTypeSystem ts) {
        List lhsList = HjPointInliner.getIndiceList(pointOp.left(), nf, ts);
        List rhsList = HjPointInliner.getIndiceList(pointOp.right(), nf, ts);
        LinkedList<Binary> inlIndexList = null;
        if (lhsList != null && rhsList != null) {
            inlIndexList = new LinkedList<Binary>();
            Iterator lhsIterator = lhsList.iterator();
            Iterator rhsIterator = rhsList.iterator();
            while (lhsIterator.hasNext() && rhsIterator.hasNext()) {
                Expr lhsExpr = (Expr)lhsIterator.next();
                Expr rhsExpr = (Expr)rhsIterator.next();
                Binary inlBinary = nf.Binary(pointOp.position(), lhsExpr, pointOp.operator(), rhsExpr);
                inlBinary = (Binary)inlBinary.type(lhsExpr.type());
                inlIndexList.add(inlBinary);
            }
        }
        return inlIndexList;
    }

    private static List getIndiceList(Expr expr, HjNodeFactory nf, HjTypeSystem ts) {
        Field field;
        FieldInstance pointInst;
        FieldInstance[] globalInlPoint;
        VarInstance pointInst2;
        LocalInstance[] locInlPoint;
        if (expr instanceof Call && ((Call)expr).name().equals("point")) {
            return ((Call)expr).arguments();
        }
        if (expr instanceof Local && ts.isPoint(expr.type()) && (locInlPoint = (LocalInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(pointInst2 = TreeUtils.getVarInstance((Node)expr))) != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(pointInst2)) {
            return HjPointInliner.createLocalInlPointRef(nf, locInlPoint);
        }
        if (expr instanceof Field && ts.isPoint(expr.type()) && (globalInlPoint = (FieldInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(pointInst = (field = (Field)expr).fieldInstance())) != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(pointInst)) {
            return HjPointInliner.createFieldInlPointRef(nf, globalInlPoint, (Receiver)field.target().copy());
        }
        if (expr instanceof Binary) {
            return HjPointInliner.optInlBinaryPointOperation((Binary)expr, nf, ts);
        }
        return null;
    }

    private Node transformHjArrayAccess1Assign(HjArrayAccess1Assign hjAAOneAssign) {
        if (hjAAOneAssign.left() instanceof HjArrayAccess) {
            HjArrayAccess left = (HjArrayAccess)hjAAOneAssign.left();
            Expr right = hjAAOneAssign.right();
            HjArrayAccessAssign hjaaa = ((HjNodeFactory_c)this.nf).HjArrayAccessAssign(hjAAOneAssign.position(), left, hjAAOneAssign.operator(), right);
            hjaaa = (HjArrayAccessAssign)hjaaa.type(hjAAOneAssign.type());
            return hjaaa;
        }
        if (!(hjAAOneAssign.left() instanceof HjArrayAccess1)) {
            Expr left = hjAAOneAssign.left();
            Expr right = hjAAOneAssign.right();
            Assign assign = this.nf.Assign(hjAAOneAssign.position(), left, Assign.ASSIGN, right);
            assign = (Assign)assign.type(hjAAOneAssign.type());
            return assign;
        }
        return hjAAOneAssign;
    }

    private Node transformHjArrayAccess1(HjArrayAccess1 hjArrayAccessOne) {
        Binary binary;
        LinkedList indices;
        Expr array = hjArrayAccessOne.array();
        Expr index = hjArrayAccessOne.index();
        VarInstance indexInst = TreeUtils.getVarInstance((Node)index);
        if (this.ts.isPoint(array.type()) && index instanceof IntLit) {
            VarInstance arrayInst = TreeUtils.getVarInstance((Node)array);
            VarInstance[] inlPoint = null;
            if (arrayInst != null) {
                inlPoint = HjPointRankTypeAnalyzer.pointToIndicesMap.get(arrayInst);
            }
            if (inlPoint != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(arrayInst)) {
                int dim = (int)((IntLit)index).value();
                if (inlPoint instanceof LocalInstance[]) {
                    return HjPointInliner.createLocalIndice(this.nf, (LocalInstance)inlPoint[dim]);
                }
                if (inlPoint instanceof FieldInstance[]) {
                    return HjPointInliner.createFieldIndice(this.nf, (FieldInstance)inlPoint[dim], ((Field)array).target());
                }
            }
        }
        if (indexInst != null && HjPointRankTypeAnalyzer.pointToIndicesMap.get(indexInst) != null && !HjPointInlineSafetyAnalyzer.unSafePointsToInline.contains(indexInst)) {
            Receiver target = null;
            if (index instanceof Field) {
                target = (Receiver)((Field)index).target().copy();
            }
            if ((indices = HjPointInliner.inlinePointSubScript(this.nf, HjPointRankTypeAnalyzer.pointToIndicesMap.get(indexInst), target)) != null) {
                Node hjaa = this.hjArrayAccessCreator(hjArrayAccessOne, indices);
                return hjaa;
            }
        } else if (index instanceof Binary && this.ts.isPoint((binary = (Binary)index).left().type()) && (indices = HjPointInliner.optInlBinaryPointOperation(binary, this.nf, this.ts)) != null) {
            Node hjaa = this.hjArrayAccessCreator(hjArrayAccessOne, indices);
            return hjaa;
        }
        return hjArrayAccessOne;
    }

    private static List<Expr> inlPointExpr(Expr expr, HjNodeFactory nf, HjTypeSystem ts) {
        if (expr != null) {
            if (expr instanceof Local) {
                LocalInstance locInst = ((Local)expr).localInstance();
                LocalInstance[] locInlPoint = (LocalInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(locInst);
                if (locInlPoint != null) {
                    return HjPointInliner.createLocalInlPointRef(nf, locInlPoint);
                }
            } else if (expr instanceof Field) {
                Field field = (Field)expr;
                FieldInstance globalInst = field.fieldInstance();
                FieldInstance[] globalInlPoint = (FieldInstance[])HjPointRankTypeAnalyzer.pointToIndicesMap.get(globalInst);
                if (globalInlPoint != null) {
                    return HjPointInliner.createFieldInlPointRef(nf, globalInlPoint, field.target());
                }
            } else {
                if (expr instanceof Call && ((Call)expr).name().equals("point")) {
                    return ((Call)expr).arguments();
                }
                if (expr instanceof Binary) {
                    return HjPointInliner.optInlBinaryPointOperation((Binary)expr, nf, ts);
                }
            }
        }
        return null;
    }

    private static LinkedList inlinePointSubScript(HjNodeFactory nf, VarInstance[] inlPoint, Receiver rec) {
        if (inlPoint instanceof LocalInstance[]) {
            return HjPointInliner.createLocalInlPointRef(nf, (LocalInstance[])inlPoint);
        }
        if (inlPoint instanceof FieldInstance[]) {
            return HjPointInliner.createFieldInlPointRef(nf, (FieldInstance[])inlPoint, rec);
        }
        return null;
    }

    private static Local createLocalIndice(HjNodeFactory nf, LocalInstance indiceInst) {
        Id name = nf.Id(indiceInst.position(), indiceInst.name());
        Local localIndice = nf.Local(indiceInst.position(), name);
        localIndice = localIndice.localInstance(indiceInst);
        localIndice = (Local)localIndice.type(indiceInst.type());
        return localIndice;
    }

    private static LocalDecl createLocalDeclIndice(HjNodeFactory nf, LocalInstance indiceInst, Expr init) {
        Position pos = indiceInst.position();
        Id name = nf.Id(pos, indiceInst.name());
        CanonicalTypeNode tn = nf.CanonicalTypeNode(pos, indiceInst.type());
        LocalDecl localInlPtDecl = nf.LocalDecl(pos, indiceInst.flags(), (TypeNode)tn, name, init);
        localInlPtDecl = localInlPtDecl.localInstance(indiceInst);
        return localInlPtDecl;
    }

    private static LinkedList createLocalInlPointRef(HjNodeFactory nf, LocalInstance[] locInlPoint) {
        LinkedList<Local> exprList = null;
        if (locInlPoint != null) {
            exprList = new LinkedList<Local>();
            for (int index = 0; index < locInlPoint.length; ++index) {
                LocalInstance indiceInst = locInlPoint[index];
                Local local = HjPointInliner.createLocalIndice(nf, indiceInst);
                exprList.add(local);
            }
        }
        return exprList;
    }

    private static List<LocalDecl> createLocalInlPointDecl(HjNodeFactory nf, HjTypeSystem ts, LocalInstance[] locInlPoint, Expr init) {
        LinkedList<LocalDecl> inlDeclList = null;
        if (locInlPoint != null) {
            inlDeclList = new LinkedList<LocalDecl>();
            List<Expr> inlInitList = HjPointInliner.inlPointExpr(init, nf, ts);
            for (int index = 0; index < locInlPoint.length; ++index) {
                LocalInstance indiceInst = locInlPoint[index];
                LocalDecl localDecl = inlInitList != null ? HjPointInliner.createLocalDeclIndice(nf, indiceInst, inlInitList.get(index)) : HjPointInliner.createLocalDeclIndice(nf, indiceInst, null);
                inlDeclList.add(localDecl);
            }
        }
        return inlDeclList;
    }

    private static Field createFieldIndice(HjNodeFactory nf, FieldInstance indiceInst, Receiver rec) {
        Position pos = indiceInst.position();
        Id name = nf.Id(pos, indiceInst.name());
        Field fieldIndice = nf.Field(pos, rec, name);
        fieldIndice = fieldIndice.fieldInstance(indiceInst);
        fieldIndice = (Field)fieldIndice.type(indiceInst.type());
        return fieldIndice;
    }

    private static FieldDecl createFieldDeclIndice(HjNodeFactory nf, FieldInstance indiceInst, Expr init) {
        Position pos = indiceInst.position();
        Id name = nf.Id(pos, indiceInst.name());
        CanonicalTypeNode tn = nf.CanonicalTypeNode(pos, indiceInst.type());
        FieldDecl fieldInlPtDecl = nf.FieldDecl(pos, indiceInst.flags(), (TypeNode)tn, name, init);
        fieldInlPtDecl = fieldInlPtDecl.fieldInstance(indiceInst);
        return fieldInlPtDecl;
    }

    private static LinkedList createFieldInlPointRef(HjNodeFactory nf, FieldInstance[] globalInlPoint, Receiver rec) {
        LinkedList<Field> exprList = null;
        if (globalInlPoint != null) {
            exprList = new LinkedList<Field>();
            for (int index = 0; index < globalInlPoint.length; ++index) {
                FieldInstance indiceInst = globalInlPoint[index];
                Field fd = HjPointInliner.createFieldIndice(nf, indiceInst, (Receiver)rec.copy());
                exprList.add(fd);
            }
        }
        return exprList;
    }

    private static List<FieldDecl> createFieldInlPointDecl(HjNodeFactory nf, HjTypeSystem ts, FieldInstance[] globalInlPoint, Expr init) {
        LinkedList<FieldDecl> inlDeclList = null;
        if (globalInlPoint != null) {
            inlDeclList = new LinkedList<FieldDecl>();
            List<Expr> inlInitList = HjPointInliner.inlPointExpr(init, nf, ts);
            for (int index = 0; index < globalInlPoint.length; ++index) {
                FieldInstance indiceInst = globalInlPoint[index];
                FieldDecl fd = inlInitList != null ? HjPointInliner.createFieldDeclIndice(nf, indiceInst, inlInitList.get(index)) : HjPointInliner.createFieldDeclIndice(nf, indiceInst, null);
                inlDeclList.add(fd);
            }
        }
        return inlDeclList;
    }

    Node hjArrayAccessCreator(HjArrayAccess1 hjArrayAccessOne, LinkedList indiceList) {
        if (indiceList.size() == 1) {
            HjArrayAccess1 xaa = this.nf.HjArrayAccess1(hjArrayAccessOne.position(), hjArrayAccessOne.array(), (Expr)indiceList.getFirst());
            xaa = (HjArrayAccess1)xaa.type(hjArrayAccessOne.type());
            return xaa;
        }
        HjArrayAccess xaa = this.nf.HjArrayAccess(hjArrayAccessOne.position(), hjArrayAccessOne.array(), indiceList);
        xaa = (HjArrayAccess)xaa.type(hjArrayAccessOne.type());
        return xaa;
    }
}

