/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.hj.visit;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.ast.ArrayConstructor;
import polyglot.ext.hj.ast.ConstantDistMaker;
import polyglot.ext.hj.ast.ForLoop;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjCall_c;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.Range;
import polyglot.ext.hj.ast.Range_c;
import polyglot.ext.hj.ast.RectRegionMaker;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.frontend.goals.Goal;
import polyglot.objinl.hj.visit.HjPointForLoopConverter;
import polyglot.objinl.hj.visit.HjProcToFormalsMapper;
import polyglot.objinl.util.TreeUtils;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPointRankTypeAnalyzer
extends NodeVisitor {
    HjTypeSystem ts;
    HjNodeFactory nf;
    Job job;
    Collection jobs;
    ExtensionInfo.HjScheduler sched;
    public static Hashtable<VarInstance, Integer> pointToRankMap = new Hashtable();
    public static Hashtable<VarInstance, Integer> arrayToRankMap = new Hashtable();
    public static Hashtable<Integer, HjCall_c> pointConstrMap = new Hashtable();
    public static Hashtable<VarInstance, LinkedList<Range>> regionToRangesMap = new Hashtable();
    public static Hashtable<VarInstance, VarInstance> distToRegionMap = new Hashtable();
    public static Hashtable<VarInstance, VarInstance> arrayToRegionMap = new Hashtable();
    public static Hashtable<VarInstance, VarInstance[]> pointToIndicesMap = new Hashtable();
    public static boolean rerun = false;
    public static boolean ranAllJobs = false;

    public HjPointRankTypeAnalyzer(Job job, HjTypeSystem ts, HjNodeFactory nf, Collection jobs, ExtensionInfo.HjScheduler sched) {
        this.ts = ts;
        this.nf = nf;
        this.job = job;
        this.jobs = jobs;
        this.sched = sched;
    }

    public NodeVisitor enter(Node n) {
        ForLoop hjLoop;
        Formal formal;
        if (n instanceof ForLoop && this.ts.isPoint((formal = (hjLoop = (ForLoop)n).formal()).declType())) {
            Expr domain = hjLoop.domain();
            VarInstance pointInst = TreeUtils.getVarInstance((Node)formal);
            VarInstance regInst = TreeUtils.getVarInstance((Node)domain);
            Integer regionNumDims = HjPointRankTypeAnalyzer.findRegionRank(pointInst, regInst, (Receiver)domain, this.ts);
            if (formal instanceof HjFormal) {
                HjFormal hjFormal = (HjFormal)formal;
                LocalInstance[] locInstances = hjFormal.localInstances();
                VarInstance[] inlPoint = pointToIndicesMap.get(hjFormal.localInstance());
                if (locInstances.length == 0 && inlPoint == null) {
                    if (regionNumDims != null) {
                        locInstances = HjPointForLoopConverter.createInlinedIndices(regionNumDims, hjFormal.localInstance(), this.ts);
                        pointToIndicesMap.put((VarInstance)hjFormal.localInstance(), (VarInstance[])locInstances);
                    }
                } else if (inlPoint == null) {
                    pointToIndicesMap.put((VarInstance)hjFormal.localInstance(), (VarInstance[])locInstances);
                }
            }
        }
        return this;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof SourceFile) {
            this.runAllJobsPass();
        }
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            LocalInstance leftInst = ld.localInstance();
            if (ld.init() != null) {
                this.assignHelper((VarInstance)leftInst, ld.init());
            }
            return n;
        }
        if (n instanceof FieldDecl) {
            FieldDecl fd = (FieldDecl)n;
            FieldInstance leftInst = fd.fieldInstance();
            if (fd.init() != null) {
                this.assignHelper((VarInstance)leftInst, fd.init());
            }
            return n;
        }
        if (n instanceof Assign) {
            Assign assign = (Assign)n;
            Expr left = assign.left();
            Expr right = assign.right();
            VarInstance leftInst = TreeUtils.getVarInstance((Node)left);
            this.assignHelper(leftInst, right);
            return n;
        }
        if (n instanceof Call) {
            Call c = (Call)n;
            this.storeIfPointConstr(c);
            Iterator actArgsIt = c.arguments().iterator();
            LinkedList<LocalInstance> formals = HjProcToFormalsMapper.procToProcFormalsTable.get(c.methodInstance());
            if (formals != null) {
                Iterator formalsIt = formals.iterator();
                while (actArgsIt.hasNext() && formalsIt.hasNext()) {
                    Expr currArg = (Expr)actArgsIt.next();
                    LocalInstance currFormal = (LocalInstance)formalsIt.next();
                    this.assignHelper((VarInstance)currFormal, currArg);
                }
            }
            return n;
        }
        if (n instanceof HjArrayAccess1) {
            this.hjArrayAccessHelper((HjArrayAccess1)n);
        }
        return n;
    }

    private void storeIfPointConstr(Call c) {
        Integer rank;
        if (c instanceof HjCall_c && HjPointRankTypeAnalyzer.hjPointConstr((HjCall_c)c, this.ts) && pointConstrMap.get(rank = new Integer(c.arguments().size())) == null) {
            pointConstrMap.put(rank, (HjCall_c)c);
        }
    }

    public static boolean hjPointConstr(HjCall_c c, HjTypeSystem ts) {
        TypeNode tn;
        Field fd;
        Receiver rec;
        return c.name().equals("point") && (rec = c.target()) instanceof Field && (fd = (Field)rec).name().equals("factory") && fd.target() instanceof TypeNode && ts.isPoint((tn = (TypeNode)fd.target()).type());
    }

    public static boolean hjRectRegionConstr(HjCall_c c, HjTypeSystem ts) {
        TypeNode tn;
        Field fd;
        Receiver rec;
        return c.name().equals("region") && (rec = c.target()) instanceof Field && (fd = (Field)rec).name().equals("factory") && fd.target() instanceof TypeNode && ts.isRegion((tn = (TypeNode)fd.target()).type());
    }

    public static boolean hjConstDistConstr(HjCall_c c, HjTypeSystem ts) {
        TypeNode tn;
        Field fd;
        Receiver rec;
        return c.name().equals("constant") && (rec = c.target()) instanceof Field && (fd = (Field)rec).name().equals("factory") && fd.target() instanceof TypeNode && ts.isDistribution((tn = (TypeNode)fd.target()).type());
    }

    public static Integer findRegionRank(VarInstance definedInst, VarInstance varInst, Receiver expr, HjTypeSystem ts) {
        if (definedInst != null && varInst != null) {
            if (ts.isRegion(varInst.type())) {
                List rangeList = regionToRangesMap.get(varInst);
                if (rangeList != null && pointToRankMap.get(definedInst) == null) {
                    Integer numDims = new Integer(rangeList.size());
                    pointToRankMap.put(definedInst, numDims);
                    rerun = true;
                    return numDims;
                }
                if (rangeList != null) {
                    Integer numDims = new Integer(rangeList.size());
                    return numDims;
                }
                if (rangeList == null) {
                    if (expr instanceof Call) {
                        Receiver target = ((Call)expr).target();
                        varInst = TreeUtils.getVarInstance((Node)target);
                        return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, target, ts);
                    }
                    if (expr instanceof Field) {
                        Receiver target = ((Field)expr).target();
                        varInst = TreeUtils.getVarInstance((Node)target);
                        return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, target, ts);
                    }
                }
            } else {
                if (ts.isDistribution(varInst.type())) {
                    varInst = distToRegionMap.get(varInst);
                    return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, expr, ts);
                }
                if (ts.isHjArrayView(varInst.type())) {
                    varInst = arrayToRegionMap.get(varInst);
                    return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, expr, ts);
                }
            }
        } else {
            if (expr instanceof RectRegionMaker) {
                RectRegionMaker rrm = (RectRegionMaker)expr;
                return new Integer(rrm.arguments().size());
            }
            if (expr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjRectRegionConstr((HjCall_c)expr, ts)) {
                HjCall_c xc = (HjCall_c)expr;
                Integer rank = HjPointRankTypeAnalyzer.findRankRegionConstrLongHand(xc.arguments(), ts);
                return rank;
            }
            if (expr instanceof ConstantDistMaker) {
                ConstantDistMaker cdm = (ConstantDistMaker)expr;
                Expr regArg = (Expr)cdm.arguments().get(0);
                return HjPointRankTypeAnalyzer.findRegionRank(definedInst, TreeUtils.getVarInstance((Node)regArg), (Receiver)regArg, ts);
            }
            if (expr instanceof HjCall_c && HjPointRankTypeAnalyzer.hjConstDistConstr((HjCall_c)expr, ts)) {
                HjCall_c xc = (HjCall_c)expr;
                Expr regArg = (Expr)xc.arguments().get(0);
                return HjPointRankTypeAnalyzer.findRegionRank(definedInst, TreeUtils.getVarInstance((Node)regArg), (Receiver)regArg, ts);
            }
            if (expr instanceof ArrayConstructor) {
                ArrayConstructor ac = (ArrayConstructor)expr;
                Expr distExpr = ac.distribution();
                return HjPointRankTypeAnalyzer.findRegionRank(definedInst, TreeUtils.getVarInstance((Node)distExpr), (Receiver)distExpr, ts);
            }
            if (expr instanceof Call) {
                Receiver target = ((Call)expr).target();
                varInst = TreeUtils.getVarInstance((Node)target);
                return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, target, ts);
            }
            if (expr instanceof Field) {
                Receiver target = ((Field)expr).target();
                varInst = TreeUtils.getVarInstance((Node)target);
                return HjPointRankTypeAnalyzer.findRegionRank(definedInst, varInst, target, ts);
            }
        }
        return null;
    }

    private void assignHelper(VarInstance leftInst, Expr right) {
        if (leftInst != null && leftInst.type() != null) {
            if (this.ts.isRegion(leftInst.type())) {
                LinkedList<Range> rangeList = new LinkedList<Range>();
                this.buildRangeList(leftInst, right, rangeList);
                if (!rangeList.isEmpty() && regionToRangesMap.get(leftInst) == null) {
                    regionToRangesMap.put(leftInst, rangeList);
                    rerun = true;
                }
            } else if (this.ts.isDistribution(leftInst.type())) {
                VarInstance regInst = HjPointRankTypeAnalyzer.getDistRegion((Receiver)right, this.ts);
                if (regInst != null && distToRegionMap.get(leftInst) == null) {
                    distToRegionMap.put(leftInst, regInst);
                    rerun = true;
                }
            } else if (this.ts.isPoint(leftInst.type())) {
                Integer numDims;
                VarInstance[] inlPoint = pointToIndicesMap.get(leftInst);
                if (inlPoint == null && (numDims = HjPointRankTypeAnalyzer.getPointNumDims(right, this.ts)) != null && (inlPoint = this.createInlinedPoint(leftInst, numDims)) != null) {
                    pointToIndicesMap.put(leftInst, inlPoint);
                    pointToRankMap.put(leftInst, new Integer(inlPoint.length));
                    rerun = true;
                }
            } else if (this.ts.isHjArrayView(leftInst.type()) && right instanceof ArrayConstructor) {
                ArrayConstructor ac = (ArrayConstructor)right;
                VarInstance distInst = TreeUtils.getVarInstance((Node)ac.distribution());
                VarInstance regInst = null;
                if (distInst != null) {
                    regInst = distToRegionMap.get(distInst);
                }
                if (regInst == null) {
                    regInst = HjPointRankTypeAnalyzer.getDistRegion((Receiver)ac.distribution(), this.ts);
                }
                if (regInst != null && arrayToRegionMap.get(leftInst) == null) {
                    arrayToRegionMap.put(leftInst, regInst);
                    rerun = true;
                }
            }
        }
    }

    public static Integer getPointNumDims(Expr expr, HjTypeSystem ts) {
        if (expr instanceof Local && ts.isPoint(expr.type())) {
            Local local = (Local)expr;
            return pointToRankMap.get(local.localInstance());
        }
        if (expr instanceof Field && ts.isPoint(expr.type())) {
            Field field = (Field)expr;
            return pointToRankMap.get(field.fieldInstance());
        }
        if (expr instanceof Call) {
            Call c = (Call)expr;
            if (c.name().equals("point")) {
                return new Integer(c.arguments().size());
            }
        } else if (expr instanceof Binary) {
            Binary binary = (Binary)expr;
            Integer lDim = HjPointRankTypeAnalyzer.getPointNumDims(binary.left(), ts);
            Integer rDim = HjPointRankTypeAnalyzer.getPointNumDims(binary.right(), ts);
            if (lDim != null && rDim != null && lDim.equals(rDim)) {
                return lDim;
            }
        }
        return null;
    }

    private VarInstance[] createInlinedPoint(VarInstance varInst, int num) {
        if (varInst instanceof LocalInstance) {
            LocalInstance[] inlPoint = new LocalInstance[num];
            for (int i = 0; i < num; ++i) {
                LocalInstance currLocInst;
                String name = varInst.name() + "_" + i;
                inlPoint[i] = currLocInst = this.ts.localInstance(varInst.position(), varInst.flags(), (Type)this.ts.Int(), name);
            }
            return inlPoint;
        }
        if (varInst instanceof FieldInstance) {
            FieldInstance[] inlPoint = new FieldInstance[num];
            for (int i = 0; i < num; ++i) {
                FieldInstance currFieldInst;
                String name = varInst.name() + "_" + i;
                inlPoint[i] = currFieldInst = this.ts.fieldInstance(varInst.position(), ((FieldInstance)varInst).container(), varInst.flags(), (Type)this.ts.Int(), name);
            }
            return inlPoint;
        }
        return null;
    }

    private void hjArrayAccessHelper(HjArrayAccess1 xaaOne) {
        VarInstance pointInst;
        Expr array;
        VarInstance arrayInst;
        Expr pointExpr = xaaOne.index();
        if (this.ts.isPoint(pointExpr.type()) && (arrayInst = TreeUtils.getVarInstance((Node)(array = xaaOne.array()))) != null && arrayToRankMap.get(arrayInst) == null && (pointInst = TreeUtils.getVarInstance((Node)pointExpr)) != null) {
            Integer arrayRank = pointToRankMap.get(pointInst);
            VarInstance[] pointInlList = pointToIndicesMap.get(pointInst);
            if (arrayRank == null && pointInlList != null) {
                arrayRank = new Integer(pointInlList.length);
            }
            if (arrayRank != null) {
                rerun = true;
                arrayToRankMap.put(arrayInst, arrayRank);
            }
        }
    }

    private void buildRangeList(VarInstance leftInst, Expr right, LinkedList<Range> rangeList) {
        VarInstance rhsInst;
        List rhsRangeList;
        Integer size = null;
        if (right instanceof RectRegionMaker) {
            RectRegionMaker rrm = (RectRegionMaker)right;
            size = new Integer(rrm.arguments().size());
        } else if (right instanceof HjCall_c && HjPointRankTypeAnalyzer.hjRectRegionConstr((HjCall_c)right, this.ts)) {
            HjCall_c xc = (HjCall_c)right;
            size = HjPointRankTypeAnalyzer.findRankRegionConstrLongHand(xc.arguments(), this.ts);
        } else if ((right instanceof Local || right instanceof Field) && (rhsRangeList = (List)regionToRangesMap.get(rhsInst = TreeUtils.getVarInstance((Node)right))) != null) {
            size = new Integer(rhsRangeList.size());
        }
        if (size != null) {
            this.buildRangeListFromRegionBounds(leftInst, size, rangeList);
        }
    }

    private static Integer findRankRegionConstrLongHand(List<Expr> args, HjTypeSystem ts) {
        Expr arg0 = args.get(0);
        if (ts.isRegion(arg0.type())) {
            return new Integer(args.size());
        }
        if (arg0 instanceof IntLit) {
            return new Integer(1);
        }
        return null;
    }

    private void buildRangeListFromRegionBounds(VarInstance leftInst, int size, LinkedList<Range> rangeList) {
        for (int i = 0; i < size; ++i) {
            if (!(leftInst instanceof LocalInstance)) continue;
            Expr low = this.buildRangeListFromRegionBoundsHelper((LocalInstance)leftInst, i, "low");
            Expr high = this.buildRangeListFromRegionBoundsHelper((LocalInstance)leftInst, i, "high");
            IntLit stride = this.nf.IntLit(low.position(), IntLit.INT, 1L);
            Range_c range = new Range_c(low.position(), low, high, (Expr)stride);
            rangeList.add(range);
        }
    }

    private Expr buildRangeListFromRegionBoundsHelper(LocalInstance leftInst, int dim, String bound) {
        Id name = this.nf.Id(leftInst.position(), leftInst.name());
        Local regionVar = this.nf.Local(leftInst.position(), name);
        regionVar = regionVar.localInstance(leftInst);
        regionVar = (Local)regionVar.type(leftInst.type());
        Call rankCall = HjPointForLoopConverter.createRankCall((Receiver)regionVar, dim, this.nf, this.ts);
        Call boundCall = HjPointForLoopConverter.createCallHelper((Receiver)rankCall, bound, (Type)this.ts.Int(), this.nf, this.ts);
        return boundCall;
    }

    private Range buildRange(Expr low, Iterator argsIt) {
        Expr high = null;
        Expr stride = null;
        if (argsIt.hasNext()) {
            high = (Expr)argsIt.next();
        }
        if (argsIt.hasNext()) {
            stride = (Expr)argsIt.next();
        }
        if (stride == null) {
            stride = this.nf.IntLit(low.position(), IntLit.INT, 1L);
        }
        return new Range_c(low.position(), low, high, stride);
    }

    public static VarInstance getDistRegion(Receiver right, HjTypeSystem ts) {
        if (right != null && ts.isRegion(right.type())) {
            return TreeUtils.getVarInstance((Node)right);
        }
        if (right instanceof ConstantDistMaker) {
            for (Expr currArg : ((ConstantDistMaker)right).arguments()) {
                if (!ts.isRegion(currArg.type())) continue;
                return TreeUtils.getVarInstance((Node)currArg);
            }
        }
        if (right instanceof HjCall_c && HjPointRankTypeAnalyzer.hjConstDistConstr((HjCall_c)right, ts)) {
            for (Expr currArg : ((HjCall_c)right).arguments()) {
                if (!ts.isRegion(currArg.type())) continue;
                return TreeUtils.getVarInstance((Node)currArg);
            }
        }
        if (right instanceof Call) {
            Call call = (Call)right;
            return HjPointRankTypeAnalyzer.getDistRegion(call.target(), ts);
        }
        if (right instanceof Field) {
            Field fd = (Field)right;
            return HjPointRankTypeAnalyzer.getDistRegion(fd.target(), ts);
        }
        return null;
    }

    private void runAllJobsPass() {
        if (!ranAllJobs) {
            ranAllJobs = true;
            do {
                rerun = false;
                for (Job j : this.jobs) {
                    if (j.equals((Object)this.job)) continue;
                    Goal goal = this.sched.HjPointRankTypeAnalyzed(j);
                    goal.setState(0);
                    this.sched.attemptGoal(goal);
                }
            } while (rerun);
        }
    }
}

