/*
 * Decompiled with CFR 0.152.
 */
package polyglot.objinl.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ast.VarDecl;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.Type;
import polyglot.types.VarInstance;

public class TreeUtils {
    public static VarInstance getVarInstance(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Local) {
            return ((Local)node).localInstance();
        }
        if (node instanceof Field) {
            return ((Field)node).fieldInstance();
        }
        if (node instanceof ArrayAccess) {
            return TreeUtils.getVarInstance((Node)((ArrayAccess)node).array());
        }
        if (node instanceof VarDecl) {
            return ((VarDecl)node).localInstance();
        }
        if (node instanceof FieldDecl) {
            return ((FieldDecl)node).fieldInstance();
        }
        return null;
    }

    public static TypeNode getTypeNode(Node node) {
        if (node instanceof VarDecl) {
            return ((VarDecl)node).type();
        }
        if (node instanceof FieldDecl) {
            return ((FieldDecl)node).type();
        }
        return null;
    }

    public static TypeNode getTypeNode(NodeFactory nf, Receiver target) {
        VarInstance varInst;
        if (target instanceof TypeNode) {
            return (TypeNode)target;
        }
        if (target instanceof Expr && (varInst = TreeUtils.getVarInstance((Node)((Expr)target))) != null) {
            return nf.CanonicalTypeNode(target.position(), varInst.type());
        }
        return null;
    }

    public static Type getBaseType(VarInstance varInst) {
        Type baseType = null;
        if (varInst != null && (baseType = varInst.type()) instanceof ArrayType) {
            baseType = ((ArrayType)baseType).base();
        }
        return baseType;
    }

    public static Hashtable setUpFormalsMapForMethInlining(ProcedureDecl pd, ProcedureCall c) {
        Hashtable<LocalInstance, Expr> formalsTable = new Hashtable<LocalInstance, Expr>();
        if (pd != null) {
            Iterator formalsIt = pd.formals().iterator();
            Iterator actualsIt = c.arguments().iterator();
            while (formalsIt.hasNext() && actualsIt.hasNext()) {
                Formal currFormal = (Formal)formalsIt.next();
                Expr currActual = (Expr)actualsIt.next();
                formalsTable.put(currFormal.localInstance(), currActual);
            }
        }
        return formalsTable;
    }

    public static Expr getExplicitTarget(Call c) {
        if (!c.isTargetImplicit() && c.target() instanceof Expr) {
            return (Expr)c.target();
        }
        return null;
    }

    public static Node getAST(ParsedClassType pct, Map jobs) {
        Job j;
        Source source = pct.fromSource();
        if (source != null && (j = (Job)jobs.get(source)) != null) {
            return j.ast();
        }
        return null;
    }

    public static Job getJob(ParsedClassType pct, Map jobs) {
        Source source = pct.fromSource();
        if (source != null) {
            Object j = jobs.get(source);
            if (j instanceof Job) {
                return (Job)j;
            }
            System.out.println("getJob(): " + j.getClass().getName() + ", " + j);
        }
        return null;
    }
}

