/*
 * Decompiled with CFR 0.152.
 */
package CnCParser;

import CnCParser.Ast.AbstractVisitor;
import CnCParser.Ast.Iinstance;
import CnCParser.Ast.Itag_type;
import CnCParser.Ast.StepExecution;
import CnCParser.Ast.StepPrescription;
import CnCParser.Ast.instanceList;
import CnCParser.Ast.item_instance;
import CnCParser.Ast.statementList;
import CnCParser.Ast.step_instance;
import CnCParser.Ast.step_instanceList;
import CnCParser.Ast.tag_definition;
import CnCParser.Ast.tag_instance;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class CncHjGenerator
extends AbstractVisitor {
    private static final String CNC_FILE_EXTENSION = ".cnc";
    Hashtable tag_map = new Hashtable();
    Hashtable tag_steps = new Hashtable();
    Hashtable item_collections = new Hashtable();
    String filename;
    String graphClass;
    Hashtable all_steps = new Hashtable();
    Hashtable all_steps_types = new Hashtable();

    public void unimplementedVisitor(String s) {
    }

    public CncHjGenerator(String filename_) {
        File f = new File(filename_);
        this.graphClass = this.filename = f.getName();
        if (this.graphClass.endsWith(CNC_FILE_EXTENSION)) {
            this.graphClass = this.filename.substring(0, this.filename.lastIndexOf(CNC_FILE_EXTENSION));
            this.graphClass = this.graphClass + "Graph";
        }
    }

    public boolean visit(StepPrescription n) {
        ArrayList<String> step_list;
        tag_instance tag = n.gettag_instance();
        step_instanceList step_instance_list = n.getstep_instance_list();
        String tag_name = tag.gettag_definition().getname().toString();
        tag_instance t = (tag_instance)this.tag_map.get(tag_name);
        if (t == null) {
            this.tag_map.put(tag_name, tag);
        }
        if ((step_list = (ArrayList<String>)this.tag_steps.get(tag_name)) == null) {
            step_list = new ArrayList<String>();
        }
        for (int i = 0; i < step_instance_list.size(); ++i) {
            step_instance si = (step_instance)step_instance_list.getstep_instanceAt(i);
            String si_name = si.getname().toString();
            step_list.add(si_name);
        }
        this.tag_steps.put(tag_name, step_list);
        return false;
    }

    public boolean visit(tag_definition n) {
        Itag_type type = n.gettag_type();
        String tagtype = type != null ? type + "" : "String";
        this.all_steps_types.put(n.getname().toString(), tagtype);
        return false;
    }

    public boolean visit(StepExecution n) {
        if (n.getstep_instance() instanceof step_instance) {
            item_instance item;
            String instanceName;
            Iinstance instance;
            int i;
            step_instance si = (step_instance)n.getstep_instance();
            instanceList inputList = n.getinputList();
            instanceList outputList = n.getoutputList();
            ArrayList<Argument> arguments = (ArrayList<Argument>)this.all_steps.get(si.getname().toString());
            if (arguments == null) {
                arguments = new ArrayList<Argument>();
            }
            for (i = 0; i < inputList.size(); ++i) {
                instance = inputList.getinstanceAt(i);
                if (instance instanceof item_instance) {
                    instanceName = ((item_instance)instance).getitem_definition().getname().toString();
                    arguments.add(new InputArgument(instanceName));
                    item = (item_instance)this.item_collections.get(instanceName);
                    if (item != null) continue;
                    this.item_collections.put(instanceName, instance);
                    continue;
                }
                if (!(instance instanceof tag_instance)) continue;
                arguments.add(new TagArgument(((tag_instance)instance).gettag_definition().getname().toString()));
            }
            for (i = 0; i < outputList.size(); ++i) {
                instance = outputList.getinstanceAt(i);
                if (instance instanceof item_instance) {
                    instanceName = ((item_instance)instance).getitem_definition().getname().toString();
                    arguments.add(new OutputArgument(instanceName));
                    item = (item_instance)this.item_collections.get(instanceName);
                    if (item != null) continue;
                    this.item_collections.put(instanceName, instance);
                    continue;
                }
                if (!(instance instanceof tag_instance)) continue;
                arguments.add(new TagArgument(((tag_instance)instance).gettag_definition().getname().toString()));
            }
            this.all_steps.put(si.getname().toString(), arguments);
        }
        return false;
    }

    public void endVisit(statementList n) {
        this.generateGraph();
        this.generateTagCollection();
        this.generateSteps();
    }

    private void generateGraph() {
        try {
            String tag_name;
            PrintStream graphOut = new PrintStream(new File(this.graphClass + ".hj"));
            this.printHeader(graphOut);
            graphOut.println("import java.util.ArrayList;");
            graphOut.println();
            graphOut.println("public class " + this.graphClass + " extends Graph{");
            graphOut.println("   CnCRuntime runtime;");
            Enumeration e = this.tag_map.keys();
            while (e.hasMoreElements()) {
                tag_name = (String)e.nextElement();
                graphOut.println("   TagCollection " + tag_name + ";");
            }
            e = this.item_collections.keys();
            while (e.hasMoreElements()) {
                tag_name = (String)e.nextElement();
                graphOut.println("   ItemCollection " + tag_name + ";");
            }
            graphOut.println();
            graphOut.print("   public static " + this.graphClass + " Factory(");
            e = this.all_steps.keys();
            while (e.hasMoreElements()) {
                String step_name = (String)e.nextElement();
                graphOut.print("A" + step_name + " " + step_name.toLowerCase() + "_");
                if (!e.hasMoreElements()) continue;
                graphOut.print(", ");
            }
            graphOut.println(") {");
            graphOut.println("      " + this.graphClass + " g1 = new " + this.graphClass + "();");
            graphOut.println("      ArrayList cl = new ArrayList();");
            e = this.tag_map.keys();
            while (e.hasMoreElements()) {
                tag_name = (String)e.nextElement();
                graphOut.print("      g1." + tag_name + " = new " + tag_name + "Collection(g1, ");
                ArrayList step_list = (ArrayList)this.tag_steps.get(tag_name);
                Iterator i = step_list.iterator();
                while (i.hasNext()) {
                    String si_name = (String)i.next();
                    graphOut.print(si_name.toLowerCase() + "_");
                    if (!i.hasNext()) continue;
                    graphOut.print(", ");
                }
                graphOut.println(");");
                graphOut.println("      cl.add(g1." + tag_name + ");");
            }
            e = this.item_collections.keys();
            while (e.hasMoreElements()) {
                tag_name = (String)e.nextElement();
                graphOut.println("      g1." + tag_name + " = ItemCollectionFactory.Create( \"" + tag_name + "\");");
            }
            graphOut.println("      g1.runtime = new CnCRuntime(cl, g1);");
            graphOut.println("      return g1;");
            graphOut.println("   }");
            graphOut.println("}");
        }
        catch (IOException ie) {
            System.err.println(ie.getMessage());
            ie.printStackTrace();
        }
    }

    private void generateTagCollection() {
        try {
            Enumeration e = this.tag_map.keys();
            while (e.hasMoreElements()) {
                String si_name_lower_case;
                String tag_name = (String)e.nextElement();
                String tag_type = (String)this.all_steps_types.get(tag_name);
                tag_instance tag = (tag_instance)this.tag_map.get(tag_name);
                PrintStream out = new PrintStream(new File(tag_name + "Collection.hj"));
                this.printHeader(out);
                out.println("class " + tag_name + "Collection extends java.lang.Object implements TagCollection {");
                out.println("    " + this.graphClass + " g;");
                out.println("    String name;");
                out.println("    public String name(){return name;}");
                ArrayList step_list = (ArrayList)this.tag_steps.get(tag_name);
                int num_steps = 0;
                Iterator i = step_list.iterator();
                while (i.hasNext()) {
                    out.println();
                    String si_name = (String)i.next();
                    si_name_lower_case = si_name.toLowerCase();
                    out.println("    A" + si_name + " " + si_name_lower_case + ";");
                    out.println();
                    ++num_steps;
                }
                out.println("    public void Put(final java.lang.Object tag) {");
                out.println("        Closure[] steps = new Closure[" + num_steps + "];");
                int curr_step = 0;
                Iterator i2 = step_list.iterator();
                while (i2.hasNext()) {
                    out.println();
                    String si_name = (String)i2.next();
                    String si_name_lower_case2 = si_name.toLowerCase();
                    out.println("            steps[" + curr_step + "] = new Closure () {");
                    out.print("                public boolean ready() { return ");
                    ArrayList arguments = (ArrayList)this.all_steps.get(si_name);
                    Argument firstInputCollection = null;
                    if (arguments != null) {
                        Iterator iter = arguments.iterator();
                        while (iter.hasNext() && firstInputCollection == null) {
                            Argument arg = (Argument)iter.next();
                            if (!(arg instanceof InputArgument)) continue;
                            firstInputCollection = (InputArgument)arg;
                        }
                    }
                    if (firstInputCollection != null) {
                        out.print("g." + firstInputCollection.name() + ".isEagerEvaluate() || ");
                    }
                    out.print(si_name_lower_case2 + ".ready((" + this.all_steps_types.get(tag_name) + ")tag");
                    if (arguments != null) {
                        for (Argument arg : arguments) {
                            if (arg instanceof InputArgument) {
                                out.print(", new ItemCollectionProxy ( this, g." + arg.name() + ")");
                                continue;
                            }
                            out.print(", g." + arg.name());
                        }
                    }
                    out.println("); }");
                    out.print("                public CnCReturnValue compute() { return " + si_name_lower_case2 + ".compute((" + this.all_steps_types.get(tag_name) + ")tag");
                    if (arguments != null) {
                        for (Argument arg : arguments) {
                            if (arg instanceof InputArgument) {
                                out.print(", new ItemCollectionProxy ( this, g." + arg.name() + ")");
                                continue;
                            }
                            out.print(", g." + arg.name());
                        }
                    }
                    out.println("); }");
                    out.println("            };");
                    ++curr_step;
                }
                out.println("        g.runtime.PutTag(tag, this, steps);");
                out.println("    }");
                out.println();
                out.print("    " + tag_name + "Collection(" + this.graphClass + " g_");
                for (String si_name : step_list) {
                    out.print(", A" + si_name + " " + si_name.toLowerCase() + "_");
                }
                out.println(") {");
                out.println("        g = g_;");
                out.println("        name = \"" + tag_name + "Collection\";");
                i2 = step_list.iterator();
                while (i2.hasNext()) {
                    si_name_lower_case = ((String)i2.next()).toLowerCase();
                    out.println("        " + si_name_lower_case + " = " + si_name_lower_case + "_;");
                }
                out.println("    }");
                out.println("}");
            }
        }
        catch (IOException ie) {
            System.err.println(ie.getMessage());
            ie.printStackTrace();
        }
    }

    private void generateSteps() {
        Enumeration e = this.all_steps.keys();
        while (e.hasMoreElements()) {
            try {
                String step_name = (String)e.nextElement();
                ArrayList arguments = (ArrayList)this.all_steps.get(step_name);
                String step_classname = "A" + step_name;
                PrintStream out = new PrintStream(new File(step_classname + ".hj"));
                this.printHeader(out);
                out.println("abstract class " + step_classname + " extends Step {");
                String tagName = this.resolveStepTagType(step_name);
                String tagType = (String)this.all_steps_types.get(tagName);
                out.print("    abstract CnCReturnValue compute(" + tagType + " tag");
                for (Argument arg : arguments) {
                    if (arg instanceof InputArgument) {
                        out.print(", InputCollection " + arg.name());
                        continue;
                    }
                    if (arg instanceof OutputArgument) {
                        out.print(", OutputCollection " + arg.name());
                        continue;
                    }
                    if (!(arg instanceof TagArgument)) continue;
                    out.print(", TagCollection " + arg.name());
                }
                out.println(");");
                out.print("    abstract boolean ready(" + tagType + " tag");
                for (Argument arg : arguments) {
                    if (arg instanceof InputArgument) {
                        out.print(", InputCollection " + arg.name());
                        continue;
                    }
                    if (arg instanceof OutputArgument) {
                        out.print(", OutputCollection " + arg.name());
                        continue;
                    }
                    if (!(arg instanceof TagArgument)) continue;
                    out.print(", TagCollection " + arg.name());
                }
                out.println(");");
                out.println("}");
            }
            catch (IOException ie) {
                System.err.println(ie.getMessage());
                ie.printStackTrace();
            }
        }
    }

    String resolveStepTagType(String step_name) {
        for (Map.Entry entry : this.tag_steps.entrySet()) {
            ArrayList l = (ArrayList)entry.getValue();
            for (String arrayEntry : l) {
                if (arrayEntry.compareTo(step_name) != 0) continue;
                return (String)entry.getKey();
            }
        }
        System.out.println("error key " + step_name + " not found");
        return null;
    }

    void printHeader(PrintStream out) {
        out.println();
        out.println("   // ***** AUTO-GENERATED FILE FROM " + this.filename + ", DO NOT MODIFY!  *****//");
        out.println();
        out.println("//Standard imports://");
        out.println("import CnCHJ.api.*;");
        out.println("import CnCHJ.runtime.*;");
        out.println();
    }

    private class TagArgument
    extends Argument {
        public TagArgument(String name) {
            super(name);
        }
    }

    private class OutputArgument
    extends Argument {
        public OutputArgument(String name) {
            super(name);
        }
    }

    private class InputArgument
    extends Argument {
        public InputArgument(String name) {
            super(name);
        }
    }

    private class Argument {
        String name;

        public Argument(String name_) {
            this.name = name_;
        }

        public String name() {
            return this.name;
        }
    }
}

