/*
 * Decompiled with CFR 0.152.
 */
package CnCParser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Option {
    String fileName = "input";
    boolean dumpTokens = false;
    boolean dumpKeywords = false;
    boolean print = false;
    char[] inputChars;

    public Option(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-d")) {
                    this.dumpTokens = true;
                    continue;
                }
                if (args[i].equals("-k")) {
                    this.dumpKeywords = true;
                    continue;
                }
                if (args[i].equals("-p")) {
                    this.print = true;
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                this.Usage();
                System.exit(1);
                continue;
            }
            this.fileName = args[i];
            break;
        }
    }

    public void Usage() {
        System.err.println("Usage:");
        System.err.println("CnCc [options] filename");
        System.err.println("Options:");
        System.err.println("-d: dump parsed tokens");
        System.err.println("-k: dump keywords");
        System.err.println("-p: print the AST");
        System.err.println("filename: the source file containing the CnC code");
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean dumpTokens() {
        return this.dumpTokens;
    }

    public boolean dumpKeywords() {
        return this.dumpKeywords;
    }

    public boolean printTokens() {
        return this.print;
    }

    public char[] getInputChars() {
        return this.inputChars;
    }

    public int readInputChars() throws IOException {
        int rlen = 0;
        try {
            File f = new File(this.fileName);
            int len = (int)f.length();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.inputChars = new char[len];
            rlen = in.read(this.inputChars, 0, len);
        }
        catch (Exception e) {
            IOException io = new IOException();
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw io;
        }
        return rlen;
    }
}

