/* A class for comparing the contents of two square matrices that are in two text files
 * 
 * @author Zoran Budimlic (zoran@rice.edu)
 */


import java.io.*;

public class Compare {

    //	 Compare the two matrices. The numbers in the matrix 
    //   are whitespace separated
    public static void compare (String fname1, String fname2) throws java.io.IOException
    {
	Reader r1 = new BufferedReader(new FileReader(fname1));
	StreamTokenizer stok1 = new StreamTokenizer(r1);
	Reader r2 = new BufferedReader(new FileReader(fname2));
	StreamTokenizer stok2 = new StreamTokenizer(r2);
	stok1.parseNumbers();
	stok1.nextToken();
	stok2.parseNumbers();
	stok2.nextToken();
	int i = 0;
	while(stok1.ttype != StreamTokenizer.TT_EOF && stok2.ttype != StreamTokenizer.TT_EOF){
	    if (stok1.ttype != StreamTokenizer.TT_NUMBER) throw new IOException("A non-number has been read from the file: "+stok1.sval);
	    if (stok2.ttype != StreamTokenizer.TT_NUMBER) throw new IOException("A non-number has been read from the file: "+stok2.sval);
	    if (stok1.nval != stok2.nval) throw new IOException("The matrices are different. First different element is at position " + i);
	    stok1.nextToken();
	    stok2.nextToken();
	    i++;
	}
	        
    }

    
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
	    int n;
	    String filename1 = null, filename2 = null;
	    if (args.length == 2){
	    	filename1 = args[0];
	    	filename2 = args[1];
	    } else {
	    	System.out.println("Usage: Compare filename1 filename2");
	    	System.exit(1);
	    }
	    
	    try{
			compare(filename1,filename2);
			System.out.println("The matrices are identical.");
	    } catch (java.io.IOException e){
			System.err.println(e.getMessage());
			e.printStackTrace();
			System.exit(1);
	    }
	}

}
