////////////////////////////////////////////////////////////////////////////////
// Blame Sagnak Tasirlar for the code
// sagnak@rice.edu
// influenced by Aparna Chandramowlishwaran's Intel CnC C++ implementation
// and by Zoran Budimlic's Habanero CnC Java implementation
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// item collection declarations

[ int numTiles ];
[ int tileSize ];

[ Object Lkji ];           // The input/result matrix
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// tags declarations (comments are Aparna's)

< point singletonTag > ;
< point controlS1Tag > ;    // Tag values are indices of Step 1 [k = 0...p-1]
< point controlS2Tag > ;    // Tag values are indices of Step 2 [j = k+1...p-1]
< point controlS3Tag > ;    // Tag values are indices of Step 3 [i = k+1...j]
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Step Prescriptions

< singletonTag > :: ( kComputeStep ) ;
< controlS1Tag > :: ( kjComputeStep ) , ( s1ComputeStep ) ;		
< controlS2Tag > :: ( kjiComputeStep ) , ( s2ComputeStep ) ;
< controlS3Tag > :: ( s3ComputeStep ) ;
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Input output relationships (comments are Aparna's)
//
// The kComputeStep produces 'k' loop indices (in the form of tag instance)
[ numTiles ] -> ( kComputeStep ) -> < controlS1Tag > ;

// The kjCompute step produces 'j' loop indices (in the form of tag instance)
[ numTiles ] -> ( kjComputeStep ) -> < controlS2Tag > ;

// The kjiComputeStep produces 'i' loop indices (in the form of tag instance)
( kjiComputeStep ) -> < controlS3Tag > ;

// Step 1 Executions
[ tileSize ] , [ Lkji ] -> ( s1ComputeStep ) -> [ Lkji ] ;
 
// Step 2 Executions
[ tileSize ] , [ Lkji ] -> ( s2ComputeStep ) -> [ Lkji ] ;

// Step 3 Executions
[ tileSize ] , [ Lkji ] -> ( s3ComputeStep ) -> [ Lkji ] ;

// Input from the caller: tile pointers, tile size and loop end value
env -> [ Lkji ] , [ tileSize ] , [ numTiles ] , < singletonTag > ;
 
// Return to the caller
[ Lkji ] -> env;

