// sagnak tasirlar jan 28, 2010
// a comparator for cholesky applied matrices which allows round off errors and 
// capable of reading floats like 1.23e-5 which the java version fails to read
//
//

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <cmath>
#define THRESHOLD 1.0e-6

int main ( int argc , char* argv[] ) {
	if ( argc <= 2 ) {
		std::cerr << "Usage comparator filename1 filename2" << std::endl;
		return 1;
	}
	std::ifstream file1(argv[1]);
	std::ifstream file2(argv[2]);

	if ( !file1.good() || !file2.good() ) {
		std::cerr << "can not open files" << std::endl;
		return 1;
	}

	double currFromFile1 = 0.0 , currFromFile2 = 0.0;
	size_t index = 0;
	do {
		++index;
		file1 >> currFromFile1;
		file2 >> currFromFile2;
		if ( fabs( currFromFile1 - currFromFile2 ) > THRESHOLD ) {
			std::cerr << "index "<<index << "is different in files"<< std::endl;
			std::cerr << "values are " << currFromFile1 << " "<< currFromFile2 << std::endl;
		}
	} while ( !file1.eof() && !file2.eof() );
	
	return 0;
}
