module Paths_dyna (
    version,
    getBinDir, getLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where

import qualified Control.Exception as Exception
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude

catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
catchIO = Exception.catch


version :: Version
version = Version {versionBranch = [0,4], versionTags = []}
bindir, libdir, datadir, libexecdir, sysconfdir :: FilePath

bindir     = "/home/dyna/.cabal/bin"
libdir     = "/home/dyna/.cabal/lib/x86_64-linux-ghc-7.6.3/dyna-0.4"
datadir    = "/home/dyna/.cabal/share/x86_64-linux-ghc-7.6.3/dyna-0.4"
libexecdir = "/home/dyna/.cabal/libexec"
sysconfdir = "/home/dyna/.cabal/etc"

getBinDir, getLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath
getBinDir = catchIO (getEnv "dyna_bindir") (\_ -> return bindir)
getLibDir = catchIO (getEnv "dyna_libdir") (\_ -> return libdir)
getDataDir = catchIO (getEnv "dyna_datadir") (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "dyna_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "dyna_sysconfdir") (\_ -> return sysconfdir)

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir ++ "/" ++ name)
