/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.AmbPrefix;
import polyglot.ast.Disamb;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.ast.Prefix;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbPrefix_c
extends Node_c
implements AmbPrefix {
    protected Prefix prefix;
    protected Id name;

    public AmbPrefix_c(Position pos, Prefix prefix, Id name) {
        super(pos);
        assert (name != null);
        this.prefix = prefix;
        this.name = name;
    }

    public Id nameNode() {
        return this.name;
    }

    public AmbPrefix name(Id name) {
        AmbPrefix_c n = (AmbPrefix_c)this.copy();
        n.name = name;
        return n;
    }

    public Prefix prefix() {
        return this.prefix;
    }

    public AmbPrefix prefix(Prefix prefix) {
        AmbPrefix_c n = (AmbPrefix_c)this.copy();
        n.prefix = prefix;
        return n;
    }

    protected AmbPrefix_c reconstruct(Prefix prefix, Id name) {
        if (prefix != this.prefix || name != this.name) {
            AmbPrefix_c n = (AmbPrefix_c)this.copy();
            n.prefix = prefix;
            n.name = name;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Prefix prefix = (Prefix)this.visitChild(this.prefix, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(prefix, name);
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        Position pos = this.position();
        Disamb disamb = ar.nodeFactory().disamb();
        Node n = disamb.disambiguate(this, ar, pos, this.prefix, this.name);
        if (n instanceof Prefix) {
            return n;
        }
        throw new SemanticException("Could not find " + (this.prefix != null ? this.prefix + "." : "") + this.name, pos);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        return this;
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.prefix != null) {
            this.print(this.prefix, w, tr);
            w.write(".");
        }
        tr.print(this, this.name, w);
    }

    public String toString() {
        return (this.prefix == null ? this.name.toString() : this.prefix.toString() + "." + this.name.toString()) + "{amb}";
    }
}

