/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.AmbTypeNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Prefix;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.types.LazyRef;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class AmbTypeNode_c
extends TypeNode_c
implements AmbTypeNode {
    protected Prefix prefix;
    protected Id name;

    public AmbTypeNode_c(Position pos, Prefix qual, Id name) {
        super(pos);
        assert (name != null);
        this.prefix = qual;
        this.name = name;
    }

    public Id name() {
        return this.name;
    }

    public AmbTypeNode name(Id name) {
        AmbTypeNode_c n = (AmbTypeNode_c)this.copy();
        n.name = name;
        return n;
    }

    public Prefix prefix() {
        return this.prefix;
    }

    public AmbTypeNode prefix(Prefix prefix) {
        AmbTypeNode_c n = (AmbTypeNode_c)this.copy();
        n.prefix = prefix;
        return n;
    }

    protected AmbTypeNode_c reconstruct(Prefix qual, Id name) {
        if (qual != this.prefix || name != this.name) {
            AmbTypeNode_c n = (AmbTypeNode_c)this.copy();
            n.prefix = qual;
            n.name = name;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Prefix prefix = (Prefix)this.visitChild(this.prefix, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(prefix, name);
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        SemanticException ex;
        try {
            Node n = ar.nodeFactory().disamb().disambiguate(this, ar, this.position(), this.prefix, this.name);
            if (n instanceof TypeNode) {
                TypeNode tn = (TypeNode)n;
                LazyRef sym2 = (LazyRef)this.type;
                sym2.update(tn.typeRef().get());
                Goal resolver = Globals.Scheduler().LookupGlobalType(sym2);
                resolver.update(Goal.Status.SUCCESS);
                sym2.setResolver(resolver);
                return n;
            }
            ex = new SemanticException("Could not find type \"" + (this.prefix == null ? this.name.id() : this.prefix.toString() + "." + this.name.id()) + "\".", this.position());
        }
        catch (SemanticException e) {
            ex = e;
        }
        LazyRef sym3 = (LazyRef)this.type;
        sym3.update(ar.typeSystem().unknownType(this.position()));
        throw ex;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.prefix != null) {
            this.print(this.prefix, w, tr);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(this, this.name, w);
    }

    public String toString() {
        return (this.prefix == null ? this.name.toString() : this.prefix.toString() + "." + this.name.toString()) + "{amb}";
    }
}

