/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAccess_c
extends Expr_c
implements ArrayAccess {
    protected Expr array;
    protected Expr index;

    public ArrayAccess_c(Position pos, Expr array, Expr index) {
        super(pos);
        assert (array != null && index != null);
        this.array = array;
        this.index = index;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Expr array() {
        return this.array;
    }

    @Override
    public ArrayAccess array(Expr array) {
        ArrayAccess_c n = (ArrayAccess_c)this.copy();
        n.array = array;
        return n;
    }

    @Override
    public Expr index() {
        return this.index;
    }

    @Override
    public ArrayAccess index(Expr index) {
        ArrayAccess_c n = (ArrayAccess_c)this.copy();
        n.index = index;
        return n;
    }

    @Override
    public Flags flags() {
        return Flags.NONE;
    }

    protected ArrayAccess_c reconstruct(Expr array, Expr index) {
        if (array != this.array || index != this.index) {
            ArrayAccess_c n = (ArrayAccess_c)this.copy();
            n.array = array;
            n.index = index;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr array = (Expr)this.visitChild(this.array, v);
        Expr index = (Expr)this.visitChild(this.index, v);
        return this.reconstruct(array, index);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.array.type().isArray()) {
            throw new SemanticException("Subscript can only follow an array type.", this.position());
        }
        if (!ts.isImplicitCastValid(this.index.type(), ts.Int(), tc.context())) {
            throw new SemanticException("Array subscript must be an integer.", this.position());
        }
        return this.type(this.array.type().toArray().base());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.index) {
            return ts.Int();
        }
        if (child == this.array) {
            return ts.arrayOf(this.type);
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.array + "[" + this.index + "]";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.array, w, tr);
        w.write("[");
        this.printBlock(this.index, w, tr);
        w.write("]");
    }

    @Override
    public Term firstChild() {
        return this.array;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.array, this.index, 1);
        v.visitCFG(this.index, this, 0);
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return CollectionUtil.list(ts.OutOfBoundsException(), ts.NullPointerException(), new Type[0]);
    }
}

