/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.ErrorRef_c;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call_c
extends Expr_c
implements Call {
    protected Receiver target;
    protected Id name;
    protected List<Expr> arguments;
    protected MethodInstance mi;
    protected boolean targetImplicit;

    public Call_c(Position pos, Receiver target, Id name, List<Expr> arguments) {
        super(pos);
        assert (name != null && arguments != null);
        this.target = target;
        this.name = name;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        this.targetImplicit = target == null;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Receiver target() {
        return this.target;
    }

    @Override
    public Call target(Receiver target) {
        Call_c n = (Call_c)this.copy();
        n.target = target;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public Call name(Id name) {
        Call_c n = (Call_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.methodInstance();
    }

    @Override
    public MethodInstance methodInstance() {
        return this.mi;
    }

    @Override
    public Call methodInstance(MethodInstance mi) {
        if (mi == this.mi) {
            return this;
        }
        Call_c n = (Call_c)this.copy();
        n.mi = mi;
        return n;
    }

    @Override
    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    @Override
    public Call targetImplicit(boolean targetImplicit) {
        if (targetImplicit == this.targetImplicit) {
            return this;
        }
        Call_c n = (Call_c)this.copy();
        n.targetImplicit = targetImplicit;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public ProcedureCall arguments(List<Expr> arguments) {
        Call_c n = (Call_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    protected Call_c reconstruct(Receiver target, Id name, List<Expr> arguments) {
        if (target != this.target || name != this.name || !CollectionUtil.allEqual(arguments, this.arguments)) {
            Call_c n = (Call_c)this.copy();
            n.targetImplicit = n.targetImplicit && target == n.target;
            n.target = target;
            n.name = name;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild(this.target, v);
        Id name = (Id)this.visitChild(this.name, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(target, name, arguments);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Call_c n = (Call_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        MethodInstance mi = ts.createMethodInstance(this.position(), new ErrorRef_c(ts, this.position(), "Cannot get MethodDef before type-checking method invocation."));
        return n.methodInstance(mi);
    }

    protected Node typeCheckNullTarget(ContextVisitor tc, List<Type> argTypes) throws SemanticException {
        Receiver r;
        TypeSystem ts = tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Context c = tc.context();
        MethodInstance mi = c.findMethod(ts.MethodMatcher(null, this.name.id(), argTypes, c));
        if (mi.flags().isStatic()) {
            Type container = this.findContainer(ts, mi);
            r = nf.CanonicalTypeNode(this.position().startOf(), container).typeRef(Types.ref(container));
        } else {
            ClassType scope = c.findMethodScope(this.name.id());
            r = !ts.typeEquals(scope, c.currentClass(), c) ? (Special)nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position().startOf(), scope)).del().typeCheck(tc) : (Special)nf.This(this.position().startOf()).del().typeCheck(tc);
        }
        Call_c call = (Call_c)this.targetImplicit(true).target(r);
        call = (Call_c)call.methodInstance(mi).type(mi.returnType());
        return call;
    }

    protected Type findContainer(TypeSystem ts, MethodInstance mi) {
        return mi.container();
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            argTypes.add(e.type());
        }
        if (this.target == null) {
            return this.typeCheckNullTarget(tc, argTypes);
        }
        Type targetType = this.target.type();
        MethodInstance mi = ts.findMethod(targetType, ts.MethodMatcher(targetType, this.name.id(), argTypes, c));
        boolean staticContext = this.target instanceof TypeNode;
        if (staticContext && !mi.flags().isStatic()) {
            throw new SemanticException("Cannot call non-static method " + this.name.id() + " of " + this.target.type() + " in static " + "context.", this.position());
        }
        if (this.target instanceof Special && ((Special)this.target).kind() == Special.SUPER && mi.flags().isAbstract()) {
            throw new SemanticException("Cannot call an abstract method of the super class", this.position());
        }
        Call_c call = (Call_c)this.methodInstance(mi).type(mi.returnType());
        call.checkConsistency(c);
        return call;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.mi.container();
        }
        Iterator<Expr> i = this.arguments.iterator();
        Iterator<Type> j = this.mi.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetImplicit ? "" : this.target.toString() + ".");
        sb.append(this.name);
        sb.append("(");
        int count = 0;
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            Expr n = i.next();
            sb.append(n.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target != null) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.write(this.name + "(");
        if (this.arguments.size() > 0) {
            w.allowBreak(2, 2, "", 0);
            w.begin(0);
            Iterator<Expr> i = this.arguments.iterator();
            while (i.hasNext()) {
                Expr e = i.next();
                this.print(e, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
        }
        w.write(")");
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(targetImplicit " + this.targetImplicit + ")");
        w.end();
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(arguments " + this.arguments + ")");
        w.end();
    }

    @Override
    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return Call_c.listChild(this.arguments, null);
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.target instanceof Term) {
            Term t = (Term)((Object)this.target);
            if (!this.arguments.isEmpty()) {
                v.visitCFG(t, Call_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(t, this, 0);
            }
        }
        return succs;
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.mi == null) {
            throw new InternalCompilerError(this.position(), "Null method instance after type check.");
        }
        return super.exceptionCheck(ec);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>();
        assert (this.mi != null) : "null mi for " + this;
        l.addAll(this.mi.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            l.add(ts.NullPointerException());
        }
        return l;
    }

    protected void checkConsistency(Context c) throws SemanticException {
        if (this.targetImplicit) {
            MethodInstance methodInstance = c.findMethod(c.typeSystem().MethodMatcher(null, this.name.id(), this.mi.formalTypes(), c));
        }
    }
}

