/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Node;
import polyglot.ast.TypeNode_c;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalTypeNode_c
extends TypeNode_c
implements CanonicalTypeNode {
    public CanonicalTypeNode_c(Position pos, Ref<? extends Type> type) {
        super(pos);
        assert (type != null);
        this.type = type;
    }

    @Override
    public CanonicalTypeNode typeRef(Ref<? extends Type> type) {
        return (CanonicalTypeNode)super.typeRef(type);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        if (((Type)this.type.get()).isClass() && ((ct = ((Type)this.type.get()).toClass()).isTopLevel() || ct.isMember()) && !ts.classAccessible((ClassDef)ct.def(), tc.context())) {
            throw new SemanticException("Cannot access class \"" + ct + "\" from the body of \"" + tc.context().currentClass() + "\".", this.position());
        }
        return this;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.type == null) {
            w.write("<unknown-type>");
        } else {
            ((Type)this.type.get()).print(w);
        }
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        w.write(((Type)this.type.get()).translate(tr.context()));
    }

    @Override
    public String toString() {
        if (this.type == null) {
            return "<unknown-type>";
        }
        return this.type.toString();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(type " + this.type + ")");
        w.end();
    }
}

