/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBody_c
extends Term_c
implements ClassBody {
    protected List<ClassMember> members;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "context", new String[0]);

    public ClassBody_c(Position pos, List<ClassMember> members) {
        super(pos);
        assert (members != null);
        this.members = TypedList.copyAndCheck(members, ClassMember.class, true);
    }

    @Override
    public List<ClassMember> members() {
        return this.members;
    }

    @Override
    public ClassBody members(List<ClassMember> members) {
        ClassBody_c n = (ClassBody_c)this.copy();
        n.members = TypedList.copyAndCheck(members, ClassMember.class, true);
        return n;
    }

    @Override
    public ClassBody addMember(ClassMember member) {
        ClassBody_c n = (ClassBody_c)this.copy();
        ArrayList<ClassMember> l = new ArrayList<ClassMember>(this.members.size() + 1);
        l.addAll(this.members);
        l.add(member);
        n.members = TypedList.copyAndCheck(l, ClassMember.class, true);
        return n;
    }

    protected ClassBody_c reconstruct(List<ClassMember> members) {
        if (!CollectionUtil.allEqual(members, this.members)) {
            ClassBody_c n = (ClassBody_c)this.copy();
            n.members = TypedList.copyAndCheck(members, ClassMember.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List members = this.visitList(this.members, v);
        return this.reconstruct(members);
    }

    @Override
    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        return this;
    }

    @Override
    public String toString() {
        return "{ ... }";
    }

    protected void duplicateFieldCheck(ContextVisitor tc) throws SemanticException {
        ClassDef type = tc.context().currentClassDef();
        ArrayList<FieldDef> l = new ArrayList<FieldDef>(type.fields());
        for (int i = 0; i < l.size(); ++i) {
            FieldDef fi = l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                FieldDef fj = l.get(j);
                if (!fi.name().equals(fj.name())) continue;
                throw new SemanticException("Duplicate field \"" + fj + "\".", fj.position());
            }
        }
    }

    protected void duplicateConstructorCheck(ContextVisitor tc) throws SemanticException {
        ClassDef type = tc.context().currentClassDef();
        TypeSystem ts = tc.typeSystem();
        ArrayList<ConstructorDef> l = new ArrayList<ConstructorDef>(type.constructors());
        for (int i = 0; i < l.size(); ++i) {
            ConstructorDef ci = l.get(i);
            ConstructorInstance ti = ci.asInstance();
            for (int j = i + 1; j < l.size(); ++j) {
                ConstructorDef cj = l.get(j);
                ConstructorInstance tj = cj.asInstance();
                if (!ti.hasFormals(tj.formalTypes(), tc.context())) continue;
                throw new SemanticException("Duplicate constructor \"" + cj + "\".", cj.position());
            }
        }
    }

    protected void duplicateMethodCheck(ContextVisitor tc) throws SemanticException {
        ClassDef type = tc.context().currentClassDef();
        TypeSystem ts = tc.typeSystem();
        ArrayList<MethodDef> l = new ArrayList<MethodDef>(type.methods());
        for (int i = 0; i < l.size(); ++i) {
            MethodDef mi = l.get(i);
            MethodInstance ti = mi.asInstance();
            for (int j = i + 1; j < l.size(); ++j) {
                MethodDef mj = l.get(j);
                MethodInstance tj = mj.asInstance();
                if (!ti.isSameMethod(tj, tc.context())) continue;
                throw new SemanticException("Duplicate method \"" + mj + "\".", mj.position());
            }
        }
    }

    protected void duplicateMemberClassCheck(ContextVisitor tc) throws SemanticException {
        ClassDef type = tc.context().currentClassDef();
        ArrayList<Ref<? extends ClassType>> l = new ArrayList<Ref<? extends ClassType>>(type.memberClasses());
        for (int i = 0; i < l.size(); ++i) {
            Type mi = l.get(i).get();
            for (int j = i + 1; j < l.size(); ++j) {
                Type mj = l.get(j).get();
                if (!(mi instanceof Named) || !(mj instanceof Named) || !((Named)((Object)mi)).name().equals(((Named)((Object)mj)).name())) continue;
                throw new SemanticException("Duplicate member type \"" + mj + "\".", mj.position());
            }
        }
    }

    protected boolean isSameMethod(TypeSystem ts, MethodInstance mi, MethodInstance mj, Context context) {
        return mi.isSameMethod(mj, context);
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        this.duplicateFieldCheck(tc);
        this.duplicateConstructorCheck(tc);
        this.duplicateMethodCheck(tc);
        this.duplicateMemberClassCheck(tc);
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.members.isEmpty()) {
            w.newline(4);
            w.begin(0);
            ClassMember prev = null;
            Iterator<ClassMember> i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember member = i.next();
                if (member instanceof CodeDecl || prev instanceof CodeDecl) {
                    w.newline(0);
                }
                prev = member;
                this.printBlock(member, w, tr);
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        return succs;
    }
}

