/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbReceiver;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.Context;
import polyglot.types.ErrorRef_c;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field_c
extends Expr_c
implements Field {
    protected Receiver target;
    protected Id name;
    protected FieldInstance fi;
    protected boolean targetImplicit;
    Exception e;

    public Field_c(Position pos, Receiver target, Id name) {
        super(pos);
        assert (target != null && name != null);
        this.target = target;
        this.name = name;
        this.targetImplicit = false;
        this.e = new Exception();
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Receiver target() {
        return this.target;
    }

    @Override
    public Field target(Receiver target) {
        Field_c n = (Field_c)this.copy();
        n.target = target;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public Field name(Id name) {
        Field_c n = (Field_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Flags flags() {
        return this.fi.flags();
    }

    @Override
    public VarInstance varInstance() {
        return this.fi;
    }

    @Override
    public FieldInstance fieldInstance() {
        return this.fi;
    }

    @Override
    public Field fieldInstance(FieldInstance fi) {
        if (fi == this.fi) {
            return this;
        }
        Field_c n = (Field_c)this.copy();
        assert (fi != null);
        n.fi = fi;
        return n;
    }

    @Override
    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    @Override
    public Field targetImplicit(boolean implicit) {
        Field_c n = (Field_c)this.copy();
        n.targetImplicit = implicit;
        return n;
    }

    protected Field_c reconstruct(Receiver target, Id name) {
        if (target != this.target || name != this.name) {
            Field_c n = (Field_c)this.copy();
            n.target = target;
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild(this.target, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(target, name);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Field_c n = (Field_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        FieldInstance fi = ts.createFieldInstance(this.position(), (Ref<? extends FieldDef>)new ErrorRef_c<FieldDef>(ts, this.position(), "Cannot get FieldDef before type-checking field access."){

            public String toString() {
                Field_c.this.e.printStackTrace();
                return super.toString();
            }
        });
        return n.fieldInstance(fi);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        FieldInstance fi = ts.findField(this.target.type(), ts.FieldMatcher(this.target.type(), this.name.id(), c));
        if (fi == null) {
            throw new InternalCompilerError("Cannot access field on node of type " + this.target.getClass().getName() + ".");
        }
        Field_c f = (Field_c)this.fieldInstance(fi).type(fi.type());
        f.checkConsistency(c);
        return f;
    }

    @Override
    public Node checkConstants(ContextVisitor tc) throws SemanticException {
        this.isConstant();
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.fi.container();
        }
        return child.type();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target instanceof TypeNode || this.target instanceof AmbReceiver) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(this, this.name, w);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name \"" + this.name + "\")");
        w.end();
    }

    @Override
    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.target instanceof Term) {
            v.visitCFG((Term)((Object)this.target), this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        return (this.target != null ? this.target + "." : "") + this.name;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            return Collections.singletonList(ts.NullPointerException());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isConstant() {
        if (this.fi != null && (this.target instanceof TypeNode || this.target instanceof Special && this.targetImplicit)) {
            return this.fi.isConstant();
        }
        return false;
    }

    @Override
    public Object constantValue() {
        if (this.isConstant()) {
            return this.fi.constantValue();
        }
        return null;
    }

    protected void checkConsistency(Context c) {
        if (this.targetImplicit) {
            VarInstance<?> vi = c.findVariableSilent(this.name.id());
            if (vi instanceof FieldInstance) {
                FieldInstance rfi = (FieldInstance)vi;
                if (c.typeSystem().equals((TypeObject)rfi.def(), (TypeObject)this.fi.def())) {
                    return;
                }
                System.out.println("(found) rfi is " + rfi.def());
                System.out.println("(actual) fi is " + this.fi.def());
            }
            throw new InternalCompilerError("Field " + this + " has an " + "implicit target, but the name " + this.name.id() + " resolves to " + vi + " instead of " + this.target, this.position());
        }
    }
}

