/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Id;
import polyglot.ast.Labeled;
import polyglot.ast.Node;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Labeled_c
extends Stmt_c
implements Labeled {
    protected Id label;
    protected Stmt statement;

    public Labeled_c(Position pos, Id label, Stmt statement) {
        super(pos);
        assert (label != null && statement != null);
        this.label = label;
        this.statement = statement;
    }

    @Override
    public Id labelNode() {
        return this.label;
    }

    @Override
    public Labeled labelNode(Id label) {
        Labeled_c n = (Labeled_c)this.copy();
        n.label = label;
        return n;
    }

    @Override
    public Stmt statement() {
        return this.statement;
    }

    @Override
    public Labeled statement(Stmt statement) {
        Labeled_c n = (Labeled_c)this.copy();
        n.statement = statement;
        return n;
    }

    protected Labeled_c reconstruct(Id label, Stmt statement) {
        if (label != this.label || statement != this.statement) {
            Labeled_c n = (Labeled_c)this.copy();
            n.label = label;
            n.statement = statement;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id label = (Id)this.visitChild(this.label, v);
        Node statement = this.visitChild(this.statement, v);
        if (statement instanceof NodeList) {
            NodeList nl = (NodeList)statement;
            ArrayList<Node> stmts = new ArrayList<Node>(nl.nodes());
            Stmt first = (Stmt)stmts.get(0);
            first = this.reconstruct(label, first);
            stmts.set(0, first);
            return nl.nodes(stmts);
        }
        return this.reconstruct(label, (Stmt)statement);
    }

    @Override
    public String toString() {
        return this.label + ": " + this.statement;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.label + ": ");
        this.print(this.statement, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.statement;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.push(this).visitCFG(this.statement, this, 0);
        return succs;
    }
}

