/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.FlagsNode;
import polyglot.ast.Id;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.LocalDef;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarDef;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDecl_c
extends Stmt_c
implements LocalDecl {
    protected FlagsNode flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected LocalDef li;

    public LocalDecl_c(Position pos, FlagsNode flags, TypeNode type, Id name, Expr init) {
        super(pos);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.li);
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public LocalDecl flags(FlagsNode flags) {
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public LocalDecl type(TypeNode type) {
        if (type == this.type) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.type = type;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public LocalDecl name(Id name) {
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Expr init() {
        return this.init;
    }

    @Override
    public LocalDecl init(Expr init) {
        if (init == this.init) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.init = init;
        return n;
    }

    @Override
    public LocalDecl localDef(LocalDef li) {
        if (li == this.li) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        assert (li != null);
        n.li = li;
        return n;
    }

    @Override
    public LocalDef localDef() {
        return this.li;
    }

    @Override
    public VarDef varDef() {
        return this.li;
    }

    protected LocalDecl_c reconstruct(FlagsNode flags, TypeNode type, Id name, Expr init) {
        if (this.flags != flags || this.type != type || this.name != name || this.init != init) {
            LocalDecl_c n = (LocalDecl_c)this.copy();
            n.flags = flags;
            n.type = type;
            n.name = name;
            n.init = init;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        Id name = (Id)this.visitChild(this.name, v);
        Expr init = (Expr)this.visitChild(this.init, v);
        return this.reconstruct(flags, type, name, init);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.init) {
            c = c.pushBlock();
            this.addDecls(c);
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public void addDecls(Context c) {
        c.addVariable(this.li.asInstance());
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        LocalDecl_c n = (LocalDecl_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalDef li = ts.localDef(this.position(), this.flags().flags(), this.type.typeRef(), this.name.id());
        return n.localDef(li);
    }

    @Override
    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = null;
        try {
            outerLocal = c.findLocal(this.li.name());
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (outerLocal != null && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        return super.typeCheckEnter(tc);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkLocalFlags(this.flags.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.init != null) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type(), tc.context()) || ts.typeEquals(this.init.type(), this.type.type(), tc.context()) || ts.numericConversionValid(this.type.type(), this.init.constantValue(), tc.context()))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        return this;
    }

    @Override
    public Node checkConstants(ContextVisitor tc) throws SemanticException {
        if (this.init == null || !this.init.isConstant() || !this.li.flags().isFinal()) {
            this.li.setNotConstant();
        } else {
            this.li.setConstantValue(this.init.constantValue());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(this.type.type(), child.constantValue(), av.context())) {
                return child.type();
            }
            return this.type.type();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "") + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean printSemi = tr.appendSemicolon(true);
        boolean printType = tr.printType(true);
        this.print(this.flags, w, tr);
        if (printType) {
            this.print(this.type, w, tr);
            w.write(" ");
        }
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, " ");
            this.print(this.init, w, tr);
        }
        if (printSemi) {
            w.write(";");
        }
        tr.printType(printType);
        tr.appendSemicolon(printSemi);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    @Override
    public Term firstChild() {
        return this.type();
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.init() != null) {
            v.visitCFG(this.type(), this.init(), 1);
            v.visitCFG(this.init(), this, 0);
        } else {
            v.visitCFG(this.type(), this, 0);
        }
        return succs;
    }
}

