/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.ErrorRef_c;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Local_c
extends Expr_c
implements Local {
    protected Id name;
    protected LocalInstance li;

    public Local_c(Position pos, Id name) {
        super(pos);
        assert (name != null);
        this.name = name;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public Local name(Id name) {
        Local_c n = (Local_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Flags flags() {
        return this.li.flags();
    }

    @Override
    public VarInstance varInstance() {
        return this.li;
    }

    @Override
    public LocalInstance localInstance() {
        return this.li;
    }

    @Override
    public Local localInstance(LocalInstance li) {
        if (li == this.li) {
            return this;
        }
        Local_c n = (Local_c)this.copy();
        n.li = li;
        return n;
    }

    protected Local_c reconstruct(Id name) {
        if (name != this.name) {
            Local_c n = (Local_c)this.copy();
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(name);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Local_c n = (Local_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.createLocalInstance(this.position(), new ErrorRef_c(ts, this.position(), "Cannot get LocalDef before type-checking local variable."));
        return n.localInstance(li);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        LocalInstance li;
        Context c = tc.context();
        if (!c.isLocal((li = c.findLocal(this.name.id())).name()) && !li.flags().isFinal()) {
            throw new SemanticException("Local variable \"" + li.name() + "\" is accessed from an inner class, and must be declared " + "final.", this.position());
        }
        return this.localInstance(li).type(li.type());
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        return succs;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.print(this, this.name, w);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    @Override
    public boolean isConstant() {
        return this.li != null && this.li.isConstant();
    }

    @Override
    public Object constantValue() {
        if (!this.isConstant()) {
            return null;
        }
        return this.li.constantValue();
    }
}

